<?php

if (version_compare(PHP_VERSION, '7.2.0', '>=')) {
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
}
use Illuminate\Http\Request;

/* 
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group([ 'domain' => env('API_URL', 'localhost'), 'middleware'=> ['api', 'subdomain.setup']], function() {
	
	Route::get('/', function($clinicKey)
	{
  		return Redirect::to("http://".$clinicKey.".mypatientportal.xyz");
	});
	
    Route::group([ 'prefix' => 'patientportal'], function() {
		Route::get('firebase','FirebaseController@index');
		
		// ##############################  Patient's section #################################
		
        Route::post('login', 'PatientController@patientPortalLogin');
        //validate otp
        Route::post('valiate/otp', 'PatientController@validateOtp')->middleware('usersession');
        //Occupations
        Route::get('patient/occupations', 'PatientController@getPatientOccupations');
        //city
        Route::get('patient/city', 'PatientController@getPatientCity');
        //Province
        Route::get('province', 'PatientController@getProvince');
        //Referrals
        Route::get('patient/referrals', 'PatientController@getPatientReferrals');
        //Register Patient
        Route::post('patient/create', 'PatientController@createPatient');
        //Office Location
        Route::get('officelocation', 'PatientController@getOfficeLocation');
        Route::get('officelocationdetails', 'PatientController@getOfficeLocation_details');
		 Route::get('clinic/locations', 'PatientController@getClinicLocations');
        
		//Insurance
        Route::get('insurance', 'PatientController@getInsurance');
		//Get Online Patients
        Route::get('getonlinepatients', 'PatientController@getOnlinePatients');
		
		 //Get Online Patient Booked appointments
	    Route::get('getPxAptStatus', 'PatientController@getPxAptStatus');
		Route::post('updatePxStatus', 'PatientController@updatePxStatus');
		Route::post('getonlinenewpatients', 'PatientController@getOnlinenewPatientsNotifications');	  
		Route::get('getPxAptStatus1', 'PatientController@getPxAptStatus');
		Route::get('getPatientPortalBg/{location_id}', 'PatientController@getPatientPortalBg');
		 Route::post('deletePxNotifications', 'PatientController@deletePxNotifications');        
        Route::get('getClinicLogo/{location_id}', 'PatientController@getClinicLogo');
		//unsubscribe
		Route::get('unsubscribe/{p}/{e}', 'PatientController@getunsubscribe_by_link');
    	Route::post('unsubscribeto', 'PatientController@getunsubscribeto_by_link');  
		
		Route::get('onlinepaymentdetails/{transaction_no}', 'PatientController@getOnlinePaymentDetails');
		Route::post('confirmonlinepayement/{transaction_no}/{status}', 'PatientController@confirmOnlinePayment');
        Route::get('updatenotificationcount/{location_id}', 'PatientController@updateNotificationCount');
		
		// ##############################  Appointment section #################################
		   
		//Doctors
        Route::get('doctors/{location_id}', 'AppointmentController@getPxDoctor');
        //Appointment Code
        Route::get('appoinment/codes', 'AppointmentController@getAppoinmentCodes');
        //Doctor Schedule Availability
        Route::get('doctoravailable', 'AppointmentController@getDoctorAvailable');
        //Available Book Appointent
        Route::post('bookavailable', 'AppointmentController@getBookAvailable');
        //Book Appointent
        Route::post('bookappointment', 'AppointmentController@bookAppointment');
        //Get Book Appointent
        Route::get('getbookappointment', 'AppointmentController@getBookAppointment');
        
        //Get Online Booked appointments
        Route::get('getonlineappointments/{id}', 'AppointmentController@getOnlineAppointments');
      
	   	Route::get('getonlinepatientappointment', 'AppointmentController@getOnlinePatientAppointment');
        Route::post('getonlinenewpatients1', 'AppointmentController@getOnlinenewPatients');
        Route::get('getOnlinenewPatientsbyid/{id}', 'PatientController@getOnlinenewPatientsbyid');
		Route::get('getOnlinenewAppointmentsbyid/{id}', 'AppointmentController@getOnlinenewAppointmentsbyid');
		
        Route::post('updateAptStatus', 'AppointmentController@updateAptStatus');
        Route::get('confirm_appointment_by_link/{p}', 'AppointmentController@getconfirm_appointment_by_link');

		Route::post('activeappointment', 'AppointmentController@getactiveappointment');
		
		// ##############################  Questionaire section #################################
		
	    Route::post('questionairevalues','QuestionaireController@getQuestionaireValues');
		Route::post('savequestionaire','QuestionaireController@saveQuestionaireValues');
		Route::post('updateQnStatus', 'QuestionaireController@updateQnStatus');
		Route::get('treating/doctors', 'QuestionaireController@getTreatingDoctors');
        Route::get('questionairevalueconf','QuestionaireController@getQuestionaireValueConf');	
        Route::post('getonlinequestionairevalues', 'QuestionaireController@getonlinequestionairevalues');
		Route::post('getonlinenewquestionnaire', 'QuestionaireController@getOnlinenewQuestionnaire');   
		
		// ##############################  Existing Patient Login #################################
		
		Route::post('exising-px-login', 'PatientController@exisingPatientPortalLogin');
		Route::post('verify-existing-px-link/{pat_uid}', 'PatientController@verifyPatientPortalDirectLink');
    });	

	Route::group(['prefix' => 'online-payment','middleware' => ['Age']], function () {
		Route::post('submit', 'PatientController@submitOnlinePayment');  
	});
});
