<?php

/**
 * Created by Reliese Model.
 * Date: Tue, 29 Aug 2017 16:04:38 +0000.
 */

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

/**
 * Class Ecuser
 * 
 * @property int $USERID
 * @property string $LOGIN
 * @property string $password
 * @property string $FIRST_NAME
 * @property string $LAST_NAME
 * @property string $INITIAL
 * @property string $ADDRESS1
 * @property string $ADDRESS2
 * @property string $CITY
 * @property string $CONTACT_NUMBER
 * @property string $CELL
 * @property int $ALLOW_EMAIL
 * @property string $EMAIL
 * @property string $EMAIL_PASSWORD
 * @property string $EMAIL_SERVER
 * @property string $EMAIL_SERVICE
 * @property string $EMAIL_PORT
 * @property string $SMTP_URL
 * @property string $STATUS
 * @property string $USER_TYPE
 * @property \Carbon\Carbon $DATE_CREATED
 * @property \Carbon\Carbon $DATE_EDITED
 * @property string $COLOR
 * @property int $UPMAPID
 * @property string $licenseNumber
 * @property string $orglicensenumber
 * @property int $showLicenseNumber
 * @property string $ohipRegNum
 * @property string $signature_password
 * @property string $signaturepath
 * @property int $MOH_ID
 * @property string $STATE
 * @property string $POSTALCODE
 * @property string $FAX
 * @property string $NOTES
 * @property int $IS_ONLINE
 * @property \Carbon\Carbon $LAST_SEEN
 * @property int $LAST_CHAT_ID
 * @property int $LAST_CHAT_HIS_ID
 * @property int $LAST_CHAT_NOTIFY_ID
 * @property \Carbon\Carbon $LAST_LOGIN_DATE
 * @property string $LAST_LOGIN_IP
 * @property int $GROUP_ID
 *
 * @package App\Models
 */
class User extends Authenticatable
{
	//Add HasApiTokens to your User model

	protected $connection = 'mysql';
	protected $table = 'ecusers';
	protected $primaryKey = 'USERID';
	public $timestamps = false;

	protected $casts = [
		'ALLOW_EMAIL' => 'int',
		'UPMAPID' => 'int',
		'showLicenseNumber' => 'int',
		'MOH_ID' => 'int',
		'IS_ONLINE' => 'int',
		'LAST_CHAT_ID' => 'int',
		'LAST_CHAT_HIS_ID' => 'int',
		'LAST_CHAT_NOTIFY_ID' => 'int',
		'GROUP_ID' => 'int'
	];

	protected $dates = [
		'DATE_CREATED',
		'DATE_EDITED',
		'LAST_SEEN',
		'LAST_LOGIN_DATE'
	];

	protected $hidden = [
		'signature_password'
	];

	protected $fillable = [
		'LOGIN',
		'password',
		'FIRST_NAME',
		'LAST_NAME',
		'INITIAL',
		'ADDRESS1',
		'ADDRESS2',
		'CITY',
		'CONTACT_NUMBER',
		'CELL',
		'ALLOW_EMAIL',
		'EMAIL',
		'EMAIL_PASSWORD',
		'EMAIL_SERVER',
		'EMAIL_SERVICE',
		'EMAIL_PORT',
		'SMTP_URL',
		'STATUS',
		'USER_TYPE',
		'DATE_CREATED',
		'DATE_EDITED',
		'COLOR',
		'UPMAPID',
		'licenseNumber',
		'orglicensenumber',
		'showLicenseNumber',
		'ohipRegNum',
		'signature_password',
		'signaturepath',
		'MOH_ID',
		'STATE',
		'POSTALCODE',
		'FAX',
		'NOTES',
		'IS_ONLINE',
		'LAST_SEEN',
		'LAST_CHAT_ID',
		'LAST_CHAT_HIS_ID',
		'LAST_CHAT_NOTIFY_ID',
		'LAST_LOGIN_DATE',
		'LAST_LOGIN_IP',
		'GROUP_ID'
	];
}
