<?php
namespace App\Repository;
use App\Models\Ecuser;
use App\Models\Ecpatalert;
use App\Models\Ecpatnote;
use App\Models\Ecpatcasehistory;
use App\Models\Ecregnumq;
use App\Models\Ecpatactiverecall;
use App\Models\Ecpatfamily;
use App\Http\Classes\DateUtil;

use DB;
use Carbon\Carbon;

class UserRepository {

    protected $model;

    public function __construct() {
        $this->model = new Ecuser();
    }

    public function getAll($active = false) {
        if ( $active === true )
        {
            return $this->model->where('active', true)->get();
        }

        return $this->model->all();
    }

    /* get patient family detail */
    public function getPatientFamilyDetail($patientId) {   
		$now = Carbon::now();     
		$ecpatfamily = new Ecpatfamily();
		$result = $ecpatfamily
				->leftJoin('ecpatmaster', 'ecpatmaster.PAT_ID', 'ecpatfamily.relation_id')
				->where("ecpatfamily.PAT_ID",'=',$patientId)->where('ecpatfamily.status', '1')
				->select('ecpatfamily.id','ecpatmaster.PAT_ID','ecpatmaster.FIRST_NAME','ecpatmaster.LAST_NAME','ecpatmaster.GENDER'
				,'ecpatmaster.DOB','ecpatfamily.relation_id','ecpatmaster.CONTACT_NUM','ecpatmaster.CELL','ecpatmaster.EMAIL_ID','ecpatmaster.OHIP','ecpatmaster.CATEGORY','ecpatfamily.updateddate', 'ecpatfamily.status')
                ->get();
		foreach($result as $app) {
			$app -> updateddt =  date("Y-m-d" , strtotime($app -> updateddate ));
			$app -> UAGE  = DateUtil::age($app -> DOB);
			$app ->nextappointment = '';
			$ecregnumq = new Ecregnumq();
			$nxtApt = $ecregnumq
			->where('ecregnumq.PAT_ID','=',$app->relation_id)
			->where('ecregnumq.STARTDATE','>',$now)
			->orderBy('ecregnumq.STARTDATE')
			->select('ecregnumq.STARTDATE')
			->first();	
			if($nxtApt){
				$app ->nextappointment = $nxtApt['STARTDATE'];
			}
		}
        return $result;
    }
    // get patient future appointments
    public function getPatientFutureApp($patientId) {
		$now = Carbon::now();        
		$ecregnumq = new Ecregnumq();
        return $ecregnumq->select('STARTDATE','APPOINTMENTCODE')->whereRaw('PAT_ID = '.$patientId.' AND STARTDATE >=\''.$now.'\'')->orderBy('STARTDATE', 'asc')->where(['IS_DELETED'=> 0])->orWhere(['IS_DELETED'=> NULL])->get();
	}
	
	public function getPatientNextRecall($patientId)
	{
		$now = Carbon::now();        
		$ecpatactiverecall = new  Ecpatactiverecall();
		return $ecpatactiverecall->select( DB::raw('DATE_FORMAT(ecpatactiverecalls.recallDate, "%Y-%m-%d") as recalldate'))->whereRaw('patId = '.$patientId.' AND recallDate >=\''.$now.'\'')->orderBy('recallDate', 'asc')->first();
	}

    // get patient past appointments
    public function getPatientPastApp($patientId) {   
		$now = Carbon::now();        
        $ecregnumq = new Ecregnumq();
        return $ecregnumq->select('STARTDATE','APPOINTMENTCODE')->whereRaw('PAT_ID = '.$patientId.' AND STARTDATE <\''.$now.'\'')->orderBy('STARTDATE', 'desc')->get();
    }

    /* get patient detail */
    public function getPatientDetail($patientId) {
	/*
        $query = "SELECT ecpatmaster.ONLINE_ACCESS ,ecpatmaster.PAT_ID,ecpatmaster.TITLE,ecpatmaster.FIRST_NAME,ecpatmaster.LAST_NAME, ecpatmaster.PREFERRED_NAME,ecpatmaster.MIDDLE_INITIAL ,ecpatmaster.GENDER,MARITAL,ecpatmaster.DOB,ecpatmaster.AGE,ecpatmaster.ADDRESS1, ecpatmaster.ADDRESS2, ecpatmaster.CITY, ecpatmaster.PROVINCE, ecpatmaster.COUNTRY, ecpatmaster.POSTAL_CODE, ecpatmaster.CONTACT_NUM,ecpatmaster.REG_STATUS, ecpatmaster.CELL, ecpatmaster.BUS_NUM ,ecpatmaster.EMAIL_ID, ecpatmaster.OHIP, ecpatmaster.FAX_NUM, ecpatmaster.REFERRALS, ecpatmaster.DIAGNOSIS,CATEGORY, ecpatmaster.FAMILYPHY, ecpatmaster.IMAGE_PATH,ecpatmaster.INACTIVE,ecpatmaster.DECEASED,ecaddressbook.ab_first_name,ecaddressbook.ab_last_name, ecpatmaster.COMMENTS, ecpatmaster.PREF_COMM,ecusers.USERID, ecusers.FIRST_NAME as DFNAME, ecusers.LAST_NAME as DLNAME,IFNULL(ecpatoccupations.OCC_NAME,'')AS OCC_NAME , ecpatoccupations.id,  YEAR(CURDATE()) - YEAR(ecpatmaster.DOB) AS UAGE FROM ecpatmaster LEFT JOIN ecusers ON ecpatmaster.PREFERRED_DOC = ecusers.USERID LEFT JOIN ecpatoccupations ON ecpatmaster.EMPLOYEMENT = ecpatoccupations.id LEFT JOIN ecaddressbook ON  ecpatmaster.FAMILYPHY = ecaddressbook.ab_id WHERE PAT_ID = '$patientId'";*/
		
		$query = "SELECT IFNULL(ecpatmaster.ONLINE_ACCESS,'')AS ONLINE_ACCESS,IFNULL(ecpatmaster.PAT_ID,'')AS PAT_ID,
		          IFNULL(ecpatmaster.TITLE,'')AS TITLE,IFNULL(ecpatmaster.FIRST_NAME,'')AS FIRST_NAME,
				  IFNULL(ecpatmaster.LAST_NAME,'')AS LAST_NAME,IFNULL(ecpatmaster.PREFERRED_NAME,'')AS PREFERRED_NAME,
				  IFNULL(ecpatmaster.MIDDLE_INITIAL,'')AS MIDDLE_INITIAL,IFNULL(ecpatmaster.GENDER,'')AS GENDER,
				  IFNULL(ecpatmaster.DOB,'')AS DOB,IFNULL(ecpatmaster.AGE,'')AS AGE,IFNULL(ecpatmaster.ADDRESS1,'')AS ADDRESS1,
				  IFNULL(ecpatmaster.ADDRESS2,'')AS ADDRESS2,IFNULL(ecpatmaster.CITY,'')AS CITY,IFNULL(ecpatmaster.PROVINCE,'')AS PROVINCE,
				  IFNULL(ecpatmaster.COUNTRY,'')AS COUNTRY,IFNULL(ecpatmaster.POSTAL_CODE,'')AS POSTAL_CODE,
				  IFNULL(ecpatmaster.CONTACT_NUM,'')AS CONTACT_NUM,
				  IFNULL(ecpatmaster.REG_STATUS,'')AS REG_STATUS,
				  IFNULL(ecpatmaster.REG_NUM,'')AS REG_NUM,
				  IFNULL(ecpatmaster.CELL,'')AS CELL,
				  IFNULL(ecpatmaster.IS_SUBSCRIBE_EMAIL,-1)AS IS_SUBSCRIBE_EMAIL,
				  IFNULL(ecpatmaster.AUTO_CELL, 0)AS AUTO_CELL,
				  IFNULL(ecpatmaster.AUTO_EMAIL_ID,0)AS AUTO_EMAIL_ID,
				  IFNULL(ecpatmaster.AUTO_CONTACT_NUM,0)AS AUTO_CONTACT_NUM,
				  IFNULL(ecpatmaster.BUS_NUM,'')AS BUS_NUM,
				  IFNULL(ecpatmaster.EMAIL_ID,'')AS EMAIL_ID,
				  IFNULL(ecpatmaster.OHIP,'')AS OHIP,
				  IFNULL(ecpatmaster.INSURANCE,'')AS INSURANCE,
				  IFNULL(ecpatmaster.FAX_NUM,'')AS FAX_NUM,
				  IFNULL(ecpatmaster.REFERRALS,'')AS REFERRALS,
				  IFNULL(ecreferrals.referral_name,'')AS referrals_name,
				  IFNULL(ecpatmaster.DIAGNOSIS,'')AS DIAGNOSIS,
				  IFNULL(CATEGORY,'')AS CATEGORY,
				  IFNULL(ecpatmaster.FAMILYPHY,'')AS FAMILYPHY,
				  IFNULL(ecpatmaster.IMAGE_PATH,'')AS IMAGE_PATH,
				  IFNULL(ecpatmaster.INACTIVE,'')AS INACTIVE,
				  IFNULL(ecpatmaster.DECEASED,'')AS DECEASED,
				  IFNULL(ecpatmaster.IS_DNR,'')AS IS_DNR,
				  IFNULL(ecaddressbook.ab_first_name,'')AS ab_first_name,
				  IFNULL(ecaddressbook.ab_last_name,'')AS ab_last_name ,
				  IFNULL(ecpatmaster.COMMENTS,'')AS COMMENTS ,
				  IFNULL(ecpatmaster.PREF_COMM,'')AS PREF_COMM ,
				  IFNULL(ecpatmaster.PREFERRED_DOC,'')AS PREFERRED_DOC ,
				  IFNULL(ecpatmaster.CREATED_DATE,'')AS CREATED_DATE ,
				  IFNULL(ecpatmaster.MODIFIED_DATE,'')AS MODIFIED_DATE ,
				  IFNULL(ecpatmaster.LAST_EXAM_DATE,'')AS LAST_EXAM_DATE ,
				  IFNULL(ecpatmaster.OLD_INFO,'')AS OLD_INFO ,
				  IFNULL(ecpatmaster.IS_NEW_BORN_BABY,'')AS IS_NEW_BORN_BABY ,
				  IFNULL(ecusers.USERID,'')AS USERID ,
				  IFNULL(ecusers.FIRST_NAME,'')AS DFNAME ,
				  IFNULL(ecusers.LAST_NAME,'')AS DLNAME ,
				  IFNULL(ecpatmaster.employement,'') AS employement ,
				  concat(ecaddressbook.ab_first_name,' ', ecaddressbook.ab_last_name) as familyphy_name,
				  IFNULL(ecpatoccupations.id,'')AS id,
				  IFNULL(ecpatoccupations.occ_name,'')AS employement_name FROM ecpatmaster 
				  LEFT JOIN ecusers ON ecpatmaster.PREFERRED_DOC = ecusers.USERID 
				  LEFT JOIN ecpatoccupations ON ecpatmaster.EMPLOYEMENT = ecpatoccupations.id
				  LEFT JOIN ecreferrals ON ecpatmaster.REFERRALS = ecreferrals.id 
				  LEFT JOIN ecaddressbook ON  ecpatmaster.FAMILYPHY = ecaddressbook.ab_id 
				  WHERE PAT_ID = '$patientId'";
		
		
        $result = DB::select($query);
		foreach($result as $app) {
			$app -> UAGE  = DateUtil::age($app -> DOB);
		}
        return (count($result) > 0) ? $result[0] : $result;
    }

    public function getUserAlerts($patientId) {
        $ecpatalert = new Ecpatalert();
        return $ecpatalert->where(['PAT_ID' => $patientId])->get();
    }
	
	 public function isPatAlertExist($patientId) {
        $ecpatnote = new Ecpatnote();
        return $ecpatnote->where(['PAT_ID' => $patientId, 'APP_ID' => '1'])->count();
    }

    public function getUserNotes($patientId) {
        $ecpatnote = new Ecpatnote();
        return $ecpatnote->where(['PAT_ID' => $patientId])->get();
    }

    public function getUserCaseHistory($caseId, $status) {
        $ecpatcasehistory = new Ecpatcasehistory();
        return $ecpatcasehistory->where(['caseid' => $caseId, 'to_status' => $status])->get();
    }
}