<?php

/**
 * Created by Reliese Model.
 * Date: Tue, 09 Jun 2020 02:24:02 -0400.
 */

namespace App\Models;

use Reliese\Database\Eloquent\Model as Eloquent;

/**
 * Class PatientPortalNotification
 * 
 * @property int $id
 * @property \Carbon\Carbon $created_date
 * @property string $first_name
 * @property string $last_name
 * @property int $pat_id
 * @property int $evc_pat_id
 * @property int $px_status
 * @property \Carbon\Carbon $px_updated_date
 * @property int $ecrq_id
 * @property int $evc_ecrq_id
 * @property int $app_status
 * @property \Carbon\Carbon $app_updated_date
 * @property int $questionaire_id
 * @property int $evc_questionaire_id
 * @property int $questionaire_status
 * @property \Carbon\Carbon $questionaire_updated_date
 *
 * @package App\Models
 */
class PatientPortalNotification extends Eloquent
{
	protected $connection = 'mysql';
	protected $table = 'patient_portal_notifications';
	protected $primaryKey = 'id';
	public $timestamps = false;

	protected $casts = [
		'pat_id' => 'int',
		'evc_pat_id' => 'int',
		'px_status' => 'int',
		'ecrq_id' => 'int',
		'evc_ecrq_id' => 'int',
		'app_status' => 'int',
		'questionaire_id' => 'int',
		'evc_questionaire_id' => 'int',
		'questionaire_status' => 'int'
	];

	/*protected $dates = [
		'created_date',
		'px_updated_date',
		'app_updated_date',
		'questionaire_updated_date'
	];*/

	public $fillable = [
		'created_date',
		'location_id',
		'first_name',
		'last_name',
		'gender',
		'dob',
		'pat_id',
		'evc_pat_id',
		'px_status',
		'px_updated_date',
		'ecrq_id',
		'evc_ecrq_id',
		'app_status',
		'app_updated_date',
		'app_updated_by',
		'questionaire_id',
		'evc_questionaire_id',
		'questionaire_status',
		'questionaire_updated_date',
		'questionaire_updated_by',
		'px_updated_by',
		'evc_updated_by',
		'is_deleted',
		'deleted_by'
	];
}
