<?php 
namespace App\Http\Models;

class JSONResponse {
	private $statusCode;
	private $message;
	private $data;
	private $errors;

	 function __construct () {
		$this->data = [];
		$this->errors = [];
	}

	public function getStatusCode(){
		return $this->statusCode;
	}

	public function setStatusCode($statusCode){
		$this->statusCode = $statusCode;
	}

	public function getMessage(){
		return $this->message;
	}

	public function setMessage($message){
		$this->message = $message;
	}

	public function getData(){		
		return $this->data;
	}

	public function setData($data){
		$this->data = $data;
	}

	public function getErrors(){		
		return $this->errors;
	}

	public function setErrors($errors){
		$this->errors = $errors;
	}
	
	public function output() {
		$data = $this->formatResponse();
		$updatedData = $this->transformKeys($data);
		return response()->json($updatedData, 200);
	}
	
	private function formatResponse() {
		$data =  $this->getData();
		$errors = $this->getErrors();
		
		return array(
			'status_code' => $this->getStatusCode(),
			'total_records' => count($data),
			'message' => $this->getMessage(),
			'errors' => $errors,
			'data' => $data,			
		);
	}

	private function camelCase($array) {
		return collect($array)->keyBy(function ($value, $key) {
			return camel_case($key);
		});
	}

	private function transformKeys(&$array) {
		foreach (array_keys($array) as $key) {
			# Working with references here to avoid copying the value,
			# since you said your data is quite large.
			$value = &$array[$key];
			unset($array[$key]);
			# This is what you actually want to do with your keys:
			#  - remove exclamation marks at the front
			#  - camelCase to snake_case
			$transformedKey = strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', ltrim($key, '!')));
			# Work recursively
			if (is_array($value)) $this->transformKeys($value);
			# Store with new key
			$array[$transformedKey] = $value;      
			# Do not forget to unset references!
			unset($value);
		}
		return $array;
	}
}