<?php
namespace App\Http\Middleware;
use Closure;
use Carbon\Carbon;
use File;

class ApiDataLogger
{
    private $startTime;
	/**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $this->startTime = microtime(true);
		return $next($request);
    }
	public function terminate($request, $response)
	{   
		if (!env('APP_DEBUG', false)) {
			return;
	   }   
	   $end_time = microtime(true);
	   $filename = date('d_m_Y') . '_api_datalogger_' . '.log';
	   $failedfilename = date('d_m_Y') . '_failed_api_datalogger_' . '.log';
	   $data = 'Time: ' . gmdate("F j, Y, g:i a") . "\n";
	   $data .= 'Duration: ' . number_format($end_time - LARAVEL_START, 3) . "\n";   $data.= 'IP Address: ' . $request->ip() . "\n";
	   $data.= 'URL: ' . $request->fullUrl() . "\n";
	   $data.= 'Method: ' . $request->method() . "\n";
	   $data.= 'Input: ' . $request->getContent() . "\n";
	   $data.= 'Status Code: ' . $response->getStatusCode() . "\n";
	   
	   $folder = "logs" . DIRECTORY_SEPARATOR . Carbon::now()->format('Y');
	   if(!file_exists(storage_path($folder))) {
	   		mkdir(storage_path($folder));
	   }
	   $folder .=  DIRECTORY_SEPARATOR . Carbon::now()->format('m');
	   if(!file_exists(storage_path($folder))) {
	   		mkdir(storage_path($folder));
	   }
	   
	   $folder .=  DIRECTORY_SEPARATOR . $_SERVER['HTTP_HOST'];
	   if(!file_exists(storage_path($folder))) {
	   		mkdir(storage_path($folder));
	   }
	   if($response->getStatusCode() != 200) {
	   		$data.= 'Output: ' . strip_tags($response->getContent()) . "\n";
	   		File::append(storage_path($folder . DIRECTORY_SEPARATOR . $failedfilename), $data. "\n" . str_repeat("=", 20) . "\n\n");
			}
		else {
			$data.= 'Output: ' . $response->getContent() . "\n";
			File::append(storage_path($folder . DIRECTORY_SEPARATOR . $filename), $data. "\n" . str_repeat("=", 20) . "\n\n");
			}
	 }
}

?>