<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Helper;
use DateTime;
use DB;
use App\Http\Classes\DateUtil;
use App\Models\Ecpatmaster;
use App\Models\Ecofficelocation;
use App\Models\Ecuserotp;
use App\Models\Ecdoctoronlineaval;
use App\Models\Eccodes;
use App\Models\Ecregnumq;
use App\Models\Messagesetup;
use App\Models\Ecpatappointment;
use App\Models\Ecpatoccupation;
use App\Models\Ecpatcity;
use App\Models\Ecpatprovince;
use App\Models\Ecreferral;
use App\Models\Ecuser;
use App\Models\Ecpatquestionaire1;
use App\Models\Ecpatquestionaire2;
use App\Models\Ecpatquestionaire3;
use App\Models\Ecpatquestionaire4;
use App\Models\Ecpatquestionaire5;
use App\Models\PatientPortalNotification;
use App\Http\Classes\EmailAlerts;
use App\Http\Constants\UserLogConstants;
use App\Http\Classes\UserLog;
use App\Http\Requests\PatientRequest;
use App\Http\Requests\OtpRequest;
use Carbon\Carbon;
use stdClass;
use File;
use Response;
use Twilio\Rest\Client;
use Illuminate\Pagination\Paginator;
use App\Http\Controllers\FirebaseController;
use App\Http\Models\JSONResponse;
class QuestionaireController extends FirebaseController {

	var $PAGE_5_ELEMENTS = array("cataracts" => "Cataracts","lazy_eye" => "Lazy Eye","macular_degeneration" => "Macular Degeneration","high_blood_pressure" => "High Blood Pressure","glaucoma" => "Glaucoma","heart_disease" => "Heart Disease","cholesterol" => "Cholesterol","stroke" => "Stroke","diabetes_i" => "Diabetes Type I","thyroid" => "Thyroid","diabetes_ii" => "Diabetes Type II","hiv" => "HIV/AIDS","hepatitis" => "Hepatitis","herpes" => "Herpes","arthritis" => "Arthritis","asthma" => "Asthma" );
  
 //Get Questionnaire values
 	public function getQuestionaireValues(Request $request){
	$evc_pat_id = $request->session()->get('user')['EVC_PAT_ID'];
	$pat_id     = $request->session()->get('user')['PAT_ID'];
	
	/*$pat_id     = $request->pat_id;
	$evc_pat_id = $request->evc_pat_id;	*/
	
	$questionaireall = [];
	$ecquestionaire1 = new Ecpatquestionaire1();
	$ecquestionaire2 = new Ecpatquestionaire2();
	$ecquestionaire3 = new Ecpatquestionaire3();
	$ecquestionaire4 = new Ecpatquestionaire4();
	$ecquestionaire5 = new Ecpatquestionaire5();
		
	$objRpt = new \stdClass();
		
	if($evc_pat_id =="0"){
	        $pat_count = $ecquestionaire1->where(['pat_id' => $pat_id])->count();
	        
	      if($pat_count > 0){
		$questionaireall['page1'] = $ecquestionaire1::orderBy('id', 'DESC')->where(['pat_id' => $pat_id])->take(1)->first();
		$questionaire_id = $questionaireall['page1']->id;
		
		$questionaireall['page2'] = $ecquestionaire2::orderBy('id', 'DESC')->where(['questionaire_id' => $questionaire_id])->take(1)->first();
		$questionaireall['page3'] = $ecquestionaire3::orderBy('id', 'DESC')->where(['questionaire_id' => $questionaire_id])->take(1)->first();
		$questionaireall['page4'] = $ecquestionaire4::orderBy('id', 'DESC')->where(['questionaire_id' => $questionaire_id])->take(1)->first();
		
		  
		 
		$namesArr = $this -> PAGE_5_ELEMENTS; // declared at top
		$questionaireall['page5'] = [];
		foreach($namesArr as $key=>$value) {
			$questionaireall['page5'][$key] = $ecquestionaire5::orderBy('id',  'ASC')->where(['questionaire_id' => $questionaire_id, 'name' => $value])->first();
		}
			
		return $this->sendResponse($questionaireall);
		}else{
			$questionaireall['page1'] =null;
			$questionaireall['page2'] =null;
			$questionaireall['page3'] =null;
			$questionaireall['page4'] =null;
			$questionaireall['page5'] =null;
			return $this->sendResponse($questionaireall);
		}			
		   }else
			    {
				//Existing Patient Section
				
				$expat_count = $ecquestionaire1->where(['evc_pat_id' => $evc_pat_id])->count();
				if($expat_count > 0) {
				
					$questionaireall['page1'] = $ecquestionaire1::orderBy('id', 'DESC')->where(['evc_pat_id' => $evc_pat_id])->take(1)->first();
					$questionaire_id  = $questionaireall['page1']->id;
					$online_qn_status = $questionaireall['page1']->online_qn_status;
					if($online_qn_status =="1"){
					
						$resultAPI = $this -> callEvcAPI("POST", "ws/patientportal/questionairevalues", json_encode( array("pat_id" => $evc_pat_id,"case_id" => $request->case_id)));
			 			return $resultAPI; 
					}else{
						$questionaireall['page1'] = $ecquestionaire1::orderBy('id', 'DESC')->where(['evc_pat_id' => $evc_pat_id])->take(1)->first();
					        $questionaire_id  = $questionaireall['page1']->id;
						$questionaireall['page2'] = $ecquestionaire2::orderBy('id', 'DESC')->where(['questionaire_id' => $questionaire_id ])->take(1)->first();
						$questionaireall['page3'] = $ecquestionaire3::orderBy('id', 'DESC')->where(['questionaire_id' => $questionaire_id ])->take(1)->first();
						$questionaireall['page4'] = $ecquestionaire4::orderBy('id', 'DESC')->where(['questionaire_id' => $questionaire_id ])->take(1)->first();
						
						$namesArr = $this -> PAGE_5_ELEMENTS; // declared at top
						$questionaireall['page5'] = [];
						foreach($namesArr as $key=>$value) {
							$questionaireall['page5'][$key] = $ecquestionaire5::orderBy('id',  'ASC')->where(['questionaire_id' => $questionaire_id, 'name' => $value])->first();
						}
		
						return $this->sendResponse($questionaireall);	
					}			
		    }else{
		
		  	$resultAPI = $this -> callEvcAPI("POST", "ws/patientportal/questionairevalues", json_encode( array("pat_id" => $evc_pat_id,"case_id" => $request->case_id)));
		  	return $resultAPI; 	
		   }
	   }
	}

	
    //Save Questionnaire 

public function saveQuestionaireValues(Request $request, $clinicKey){
	
		$userInfo = PatientController::updateLocationId($request);
		$evc_pat_id = $userInfo['EVC_PAT_ID'];
		$pat_id     = $userInfo['PAT_ID'];
		$location_id = $userInfo['LOCATION_ID'];
		$first_name = $userInfo['FIRST_NAME'];
		$last_name  = $userInfo['LAST_NAME'];
		$dob	    = $userInfo['DOB'];
		if($pat_id && !$evc_pat_id) {
			$t = Ecpatmaster::where('PAT_ID', $pat_id)->first();
			if($t) {
				$evc_pat_id = $t -> EVC_PAT_ID;
			}
		}
		
		$questionaire1 = new Ecpatquestionaire1();
		$questionaire2 = new Ecpatquestionaire2();
		$questionaire3 = new Ecpatquestionaire3();
		$questionaire4 = new Ecpatquestionaire4();
		$questionaire5 = new Ecpatquestionaire5();
		
		//Existing user 
		if($evc_pat_id =="0"){
		   //New pateint
		    $pat_count = $questionaire1->where(['pat_id' => $pat_id])->count();
	        if($pat_count > 0){
		   $questionaire_id_val = $questionaire1 ->where(['pat_id' => $pat_id])->select('id')->first();
		   $questionaire_id   =  $questionaire_id_val->id;
		    $questionaire1= $questionaire1 -> find($questionaire_id);
		    $questionaire2= $questionaire2 -> find($questionaire_id);
		    $questionaire3= $questionaire3 -> find($questionaire_id);
		    $questionaire4= $questionaire4 -> find($questionaire_id);
		    $questionaire5= $questionaire5 -> find($questionaire_id);
		       if ($questionaire1=== null) {
		                $questionaire1 = new Ecpatquestionaire1();
		         }
		       if ($questionaire2=== null) {
		                $questionaire2 = new Ecpatquestionaire2();
		       }
		       if ($questionaire3=== null) {
		                $questionaire3= new Ecpatquestionaire3();
		       }
		       if ($questionaire4=== null) {
		                $questionaire4 = new Ecpatquestionaire4();
		       }
		       if ($questionaire5=== null) {
		                $questionaire5 = new Ecpatquestionaire5();
		       }
		    }   
		}else{
		       	$expat_count = $questionaire1 ->where(['evc_pat_id' => $evc_pat_id])->count();
		       	if($expat_count > 0 ){
		       	   //Exiting pateint available in patient portal db 
		       	   $questionaire_id_val = $questionaire1 ->where(['evc_pat_id' => $evc_pat_id])->select('id','pat_id')->first();
		       	   $questionaire_id   =  $questionaire_id_val->id;
		       	   $pat_id = $questionaire_id_val->pat_id;
		       	   $questionaire1= $questionaire1 -> find($questionaire_id);
		       	   $questionaire2= $questionaire2 -> find($questionaire_id);
		       	   $questionaire3= $questionaire3 -> find($questionaire_id);
		       	   $questionaire4= $questionaire4 -> find($questionaire_id);
		       	
		            if ($questionaire1=== null) {
		                $questionaire1 = new Ecpatquestionaire1();
		            }
		            if ($questionaire2=== null) {
		                $questionaire2 = new Ecpatquestionaire2();
		            }
		            if ($questionaire3=== null) {
		                $questionaire3= new Ecpatquestionaire3();
		            }
		            if ($questionaire4=== null) {
		                $questionaire4 = new Ecpatquestionaire4();
		            }
		            if ($questionaire5=== null) {
		                $questionaire5 = new Ecpatquestionaire5();
		            }
		       	}else{
		       	  //Exiting pateint Not available in patient portal db 	- Automatically insert record
		       	  
		       	}
		}      	
		
		$page1 = $this -> convertToObjectLevelOne($request -> page1);
		$questionaire1 = $this -> requestToModel($page1, $questionaire1);
		$page2 = $this -> convertToObjectLevelOne($request -> page2);
		$questionaire2 = $this -> requestToModel($page2, $questionaire2);
		$page3 = $this -> convertToObjectLevelOne($request -> page3);
		$questionaire3 = $this -> requestToModel($page3, $questionaire3);
		$page4 = $this -> convertToObjectLevelOne($request -> page4);
		$questionaire4 = $this -> requestToModel($page4, $questionaire4);
		
		
		$questionaire1->pat_id = $pat_id;
		$questionaire1->evc_pat_id = $evc_pat_id;
		$questionaire1->location_id = $location_id;
		$questionaire1->first_name = $first_name;
		$questionaire1->last_name = $last_name;
		$questionaire1->dob= $dob;
		$questionaire1->created_date = date("Y-m-d H:i:s");
		$questionaire1->online_qn_status = 0;
		$questionaire1 ->save();
		$questionaire2->pat_id = $pat_id;
		$questionaire2->evc_pat_id = $evc_pat_id;
		$questionaire2->questionaire_id= $questionaire1 ->id;
		$questionaire2 -> save();
		$questionaire3->pat_id = $pat_id;
		$questionaire3->evc_pat_id = $evc_pat_id;
		$questionaire3 ->questionaire_id= $questionaire1 ->id;
		$questionaire3 -> save();
		$questionaire4->pat_id = $pat_id;
		$questionaire4->evc_pat_id = $evc_pat_id;
		$questionaire4 ->questionaire_id= $questionaire1 ->id;
		$questionaire4 -> save();
		
		
		
		$page5_datas = array();
		$obj = new \stdClass();
		
		
		$namesArr = $this -> PAGE_5_ELEMENTS; // declared at top
		
		/*foreach($request -> page5 as $name=>$quesItem) {
			if(isset($questionaire_id)){
					$questionaire5 = $questionaire5 -> where('questionaire_id', $questionaire_id)->where('name', $namesArr[$name])->first();
					if(!$questionaire5) {
						$questionaire5  = new Ecpatquestionaire5();
					}	
					$quesItem= $this -> convertToObjectLevelOne($request -> page5[$name]);
					$questionaire5 = $this -> requestToModel($quesItem, $questionaire5);
					$questionaire5 ->questionaire_id = $questionaire1->id;
					$questionaire5 ->name= $namesArr[$name];
					$questionaire5 ->pat_id = $pat_id;
					$questionaire5 ->evc_pat_id = $evc_pat_id;
					$questionaire5 ->save();
			}
		}*/
		
		
		foreach($request -> page5 as $name=>$quesItem) {
			if(isset($questionaire_id)){
			
				$questionaire5_count = $questionaire5 -> where('questionaire_id', $questionaire_id)->where('name', $namesArr[$name])->select('id')->count();
			if($questionaire5_count  > 0){
				$questionaire5 = $questionaire5 -> where('questionaire_id', $questionaire_id)->where('name', $namesArr[$name])->select('id')->first();
			$id = $questionaire5 ->id;
				if(!$questionaire5) {
					$questionaire5  = new Ecpatquestionaire5();
				}else{
					$questionaire5= $questionaire5 -> find($id );
				}
			}else{
			      		$questionaire5  = new Ecpatquestionaire5();
			       }	
			}else{
				$questionaire5  = new Ecpatquestionaire5();
			}	
			
			$quesItem= $this -> convertToObjectLevelOne($request -> page5[$name]);
	        $questionaire5 = $this -> requestToModel($quesItem, $questionaire5);
			$questionaire5 ->questionaire_id = $questionaire1->id;
			$questionaire5 ->name= $namesArr[$name];
			$questionaire5 ->pat_id = $pat_id;
			$questionaire5 ->evc_pat_id = $evc_pat_id;
			$questionaire5 ->save();
		}
		
		
		//Notification section added - Questionnaire 
		
		$reqArr = array("location_id" => $location_id, "created_date" => $questionaire1->created_date,"first_name" => $questionaire1->first_name,"last_name" => $questionaire1->last_name,"pat_id" => $questionaire1->pat_id,"evc_pat_id" =>$questionaire1->evc_pat_id,"questionaire_id" => $questionaire1->id,"evc_questionaire_id" => $questionaire1->evc_qn_id,"questionaire_status" => $questionaire1->online_qn_status,"questionaire_updated_date" => $questionaire1->evc_updated_date);
		PatientController::SaveNotifications($reqArr,"NewQn");
		PatientController::getPxAptStatus($request, $clinicKey, true, $location_id);
		
		return $this->sendResponse($questionaire4 );
		
		
	}
		
	
   //update Questionnaire status 
     public function updateQnStatus(Request $request, $clinicKey) {
        // return $request;
		// die;
        $evc_pat_id= $request->evc_pat_id;
        $status= $request->status;
        $notes= $request->notes;
		$evc_updated_date= $request->evc_updated_date;
		$evc_updated_by= $request->evc_updated_by;
		$notification_id = $request->notification_id;
		
        $patquestionaire1= new Ecpatquestionaire1();
        $QnData = $patquestionaire1->where('evc_pat_id',$evc_pat_id)->select('id','pat_id')->first();
         $id = $QnData ->id;
		if($id!== null) {
            $patquestionaire1= $patquestionaire1::find($id);
            if($patquestionaire1== null) {
                $errors = array('Id: ' . $id . ' not exist');
                return $this->sendResponse([], 400, 'Failed', $errors);
            }
        }
		
        $patquestionaire1->id= $id;
		/*if($evc_qn_id)
        $patquestionaire1->evc_qn_id= $evc_qn_id;*/
        
		$patquestionaire1->online_qn_status= $status;
        $patquestionaire1->notes = $notes;
		$patquestionaire1->evc_updated_date = $evc_updated_date;
		$patquestionaire1->evc_updated_by = $evc_updated_by;
	 	$patquestionaire1->save();
		
		//Notification section added - Questionnaire 
		$reqArr = array("notification_id" =>  $notification_id, "location_id" =>  $patquestionaire1->location_id, "evc_pat_id" =>$evc_pat_id,"questionaire_id" => $patquestionaire1->id,"questionaire_status" => $patquestionaire1->online_qn_status,"questionaire_updated_date" => $patquestionaire1->evc_updated_date,"questionaire_updated_by" => $patquestionaire1->evc_updated_by);
		PatientController::SaveNotifications($reqArr,"UpdateQn");
		PatientController::getPxAptStatus($request, $clinicKey, true, $patquestionaire1->location_id);
        return $this->sendResponse($patquestionaire1); 
    } 


  public function getTreatingDoctors(Request $request) {
	 $resultAPI = $this -> callEvcAPI("GET", "ws/user/treating/doctors", 
                      json_encode(array("clinicKey" => "clinic1")));
         return $resultAPI;
		
    }
    public function getQuestionaireValueConf(Request $request) {
	 $resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/questionairevalueconf", 
                      json_encode(array("clinicKey" => "clinic1")));
         return $resultAPI;
		
    }
    
 
 
	public function getonlinequestionairevalues(Request $request) {
   	
   	$pat_id = $request->evc_pat_id;
    
		$questionaireall = [];
		$questionaireall1 = [];
		$ecquestionaire1 = new Ecpatquestionaire1();
		$ecquestionaire2 = new Ecpatquestionaire2();
		$ecquestionaire3 = new Ecpatquestionaire3();
		$ecquestionaire4 = new Ecpatquestionaire4();
		$ecquestionaire5 = new Ecpatquestionaire5();
			
		$questionaireall1['page1'] = $ecquestionaire1::orderBy('id', 'DESC')->where(['evc_pat_id' => $pat_id])->first();
		$questionaire_id = $questionaireall1['page1']->id;
		$questionaireall['page1'] = $ecquestionaire1::orderBy('id', 'DESC')->where(['evc_pat_id' => $pat_id ])->first();
		$questionaireall['page2'] = $ecquestionaire2::orderBy('id', 'DESC')->where(['questionaire_id' => $questionaire_id])->first();
		$questionaireall['page3'] = $ecquestionaire3::orderBy('id', 'DESC')->where(['questionaire_id' => $questionaire_id])->first();
		$questionaireall['page4'] = $ecquestionaire4::orderBy('id', 'DESC')->where(['questionaire_id' => $questionaire_id])->first();
		$namesArr = $this -> PAGE_5_ELEMENTS; // declared at top
		$questionaireall['page5'] = [];
		foreach($namesArr as $key=>$value) {
			$questionaireall['page5'][$key] = $ecquestionaire5::orderBy('id',  'ASC')->where(['questionaire_id' => $questionaire_id, 'name' => $value])->first();
		}
		return $this->sendResponse($questionaireall);		
    }
	
}