<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Helper;
use DateTime;
use DB;
use App\Http\Classes\DateUtil;
use App\Models\Ecpatmaster;
use App\Models\Ecofficelocation;
use App\Models\Ecuserotp;
use App\Models\Ecdoctoronlineaval;
use App\Models\Eccodes;
use App\Models\Ecregnumq;
use App\Models\Messagesetup;
use App\Models\Ecpatappointment;
use App\Models\Ecpatoccupation;
use App\Models\Ecpatcity;
use App\Models\Ecpatprovince;
use App\Models\Ecreferral;
use App\Models\Ecuser;
use App\Models\Ecpatquestionaire1;
use App\Models\Ecpatquestionaire2;
use App\Models\Ecpatquestionaire3;
use App\Models\Ecpatquestionaire4;
use App\Models\Ecpatquestionaire5;
use App\Models\PatientPortalNotification;
use App\Http\Classes\EmailAlerts;
use App\Http\Constants\UserLogConstants;
use App\Http\Classes\UserLog;
use App\Http\Requests\PatientRequest;
use App\Http\Requests\OtpRequest;
use Carbon\Carbon;
use stdClass;
use File;
use Response;
use Twilio\Rest\Client;
use Illuminate\Pagination\Paginator;
use App\Http\Controllers\FirebaseController;
use App\Http\Models\JSONResponse;
class PatientController extends FirebaseController {
	  
	  public function patientPortalLogin(Request $request) {
        $ecpatmaster = new Ecpatmaster();
		$contactNumber = $this -> getContactNum($request->contact_num);
		$responseData = $ecpatmaster
		->where('ecpatmaster.LAST_NAME','=',$request->last_name)
		->where('ecpatmaster.DOB','=',$request->dob)
		->where('ecpatmaster.EVC_PAT_ID','=',0)
		->where(function($query) use($contactNumber) {
			$query -> where("ecpatmaster.CONTACT_NUM", $contactNumber);
			$query -> orWhere("ecpatmaster.CELL", $contactNumber);
		})
		->where('ecpatmaster.EVC_PAT_ID','=',0)
		->select('LOCATION_ID as location_id','PAT_ID AS pat_id', 'FIRST_NAME AS first_name', 'LAST_NAME AS last_name', 'CONTACT_NUM AS contact_num', 'EMAIL_ID AS email_id', 'CELL AS cell','GENDER AS gender','CONTACT_NUM AS contact_num','DOB AS dob','EVC_PAT_ID AS evc_pat_id')
        ->first();
        
        if($responseData) {
			$userData = $responseData;
           	
            $userInfo = [
				'LOCATION_ID' => $userData['location_id'],
				'USERID' => $userData['pat_id'],
				'PAT_ID' => $userData['pat_id'],
				'FIRST_NAME' => $userData['first_name'],
				'LAST_NAME' => $userData['last_name'],
				'GENDER' => $userData['gender'],
				'CONTACT_NUM' => $userData['contact_num'],
				'DOB' => $userData['dob'],
				'EVC_PAT_ID' => '0',						
				'STATUS' => 'P',
				'USER_TYPE' => 'P',
				'PATIENT_TYPE' => 'New',
			];
			
			
	    }else {
		// sending formatted contact number here.
	   $userData= $this -> callEvcAPI("POST", "ws/patientportal/login", json_encode( array("last_name" => $request->last_name,"dob" => $request->dob,"contact_num"=>$contactNumber)));
	    $userData= json_decode($userData, true);
		$userData=$userData['data'];
	  $responseData = $userData; 
	  
	  if($userData){
			   $userInfo = [
					'LOCATION_ID' => $userData['location_id'],
					'USERID' => $userData['pat_id'],
					'PAT_ID' => '0',
					'FIRST_NAME' => $userData['first_name'],
					'LAST_NAME' => $userData['last_name'],	
					'GENDER' => $userData['gender'],
					'CONTACT_NUM' => $userData['contact_num'],
					'DOB' => $userData['dob'],
					'EVC_PAT_ID' => $userData['pat_id'],						
					'STATUS' => 'P',
					'USER_TYPE' => 'P',
					'PATIENT_TYPE' => 'Existing',
				];
			}else { 
				$responseData = [];
		    	return $this->sendResponse($responseData, 400,'' ,'Invalid Login details'); 
			}
	    }
	    if($userInfo  !=""){		
            $otpNumber = $this->getRandomNumber(4);
			 
            $officelocationdetails = $this->getOfficeLocation_details();
			
     		$resultAPI 			   = json_decode($officelocationdetails , true);
        	$officelocationdetails = $resultAPI['data'];
        	$officelocationdetails = $officelocationdetails [0];
		    $officeName            = $officelocationdetails ['officeName'];
            $address1	           = $officelocationdetails ['address1'];
            $city	       		   = $officelocationdetails ['city'];
			$officeEmail  		   = $officelocationdetails ['email'];
            $state    			   = $officelocationdetails ['state'];
	        $sms_number 		   = "+1".$officelocationdetails ['sms_number'];
			$calledid_number 	   = $officelocationdetails ['caller_id'];
			
			$userContactNum = preg_replace("/[^0-9+]/", "", $userData['contact_num']);
			$userCellNum = preg_replace("/[^0-9+]/", "", $userData['cell']);
			
			//Twillio call 
			if($userContactNum == $request->contact_num  && $calledid_number !='') {
				$toNumber = $userContactNum;
				if(strlen($toNumber) == 10) {
				 	if(in_array( $toNumber, array("9787249698", "9841790068", "9626394284","9787172580", "8012165370"))) {
						$toNumber = "+91".$toNumber;
					}else {
						$toNumber = "+1".$toNumber;
					}
				 	$twillio_call = $this -> callEvcAPI("POST", "ws/patientportal/sendTwillioCall",json_encode( array("to_number" => $toNumber,"otpNumber" => $otpNumber)));
				}
			}else if($userCellNum == $request->contact_num && $sms_number != "") {
				$toNumber = $userCellNum;
				if(in_array( $toNumber, array("9787249698", "9841790068", "9626394284","9787172580", "8012165370"))) {
					$toNumber = "+91".$toNumber;
				}else {
                	$toNumber = "+1".$toNumber;
				}

                if(strpos($_SERVER['HTTP_HOST'], ".local.api.") === FALSE) {
					//message sent from internal side
					$twillio_sms = $this -> callEvcAPI("POST", "ws/patientportal/sendTwillioSms",json_encode( array("to_number" => $toNumber,"otpNumber" => $otpNumber,"first_name"=>$userData['first_name'])));					  
                }
            }else{
			} 
			//Email Section 
		    $subject=" Patient portal otp Email";
            $name = $userData['first_name'];
		    $message = "Hi {$name} , Please use {$otpNumber} as your Patient portal security code to log in. Thank you . {$officeName}";
            if($userData['email_id'] != "") {
				 $emailid = $userData['email_id'];
				 $headers = "MIME-Version: 1.0" . "\r\n";
				 $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
				 $headers .= "From:  $officeName Patient Portal <$officeEmail>" . "\r\n";
				//for .ca domain ses mail 
				 $hostName = $_SERVER['HTTP_HOST'];
				 $hostArr = explode(".", $hostName);
				 if($hostArr[3]== "ca" || $hostArr[3]== "com" || $hostArr[3]== "xyz"){
				 	$twillio_call1 = $this -> callEvcAPI("POST", "ws/patientportal/sendemail",json_encode( array("emailid" => $emailid,"otpNumber" => $otpNumber,"name"=>$name)));
				 } else if(strpos($_SERVER['HTTP_HOST'], ".local.api.") === FALSE) {
				 	mail( $emailid,$subject,$message,$headers );
				 }
            }

			Ecuserotp::where('user_id', $userData['pat_id'])->delete();
            $ecuserotp = new Ecuserotp();
            $created_on = new DateTime();
            $ecuserotp->user_id = $userData['pat_id'];
            $ecuserotp->otp = $otpNumber;
            $ecuserotp->created_on = $created_on->format('Y-m-d H:i:s');
            $ecuserotp->save();

            $request->session()->put('user', $userInfo);
            $request->session()->save();

        }
        return $this->sendResponse($responseData);
    }
    
	//Create New Patient 
    public function createPatient(PatientRequest $request, $clinicKey) {
       return $responseData = $this->savePatient($request, $clinicKey);
    }
	
    private function savePatient($request, $clinicKey, $id=null) {
		
		$userId = '';//$request->session()->get('user')['USERID'];
		$todayDate = Carbon::now()->format('Y-m-d H:i:s');
		$userInfo = [];	
		$ecpatmaster = new Ecpatmaster();
		$msg = "";
		$errors ="";
		$userInfo = array();
		$check_old_rec = $ecpatmaster->where(function($query) use($request, $id, $msg) {
			$query-> where('LAST_NAME', $request->last_name); 
			$query-> where('DOB', $request->dob); 
			$query-> where('CONTACT_NUM',  $request->contact_num);
			if($request -> pat_id) {
				$query-> where('PAT_ID', '!=', $request->pat_id);
			}
		})->count();
		if($check_old_rec > 0)
		{
			$errors = "Patient information not saved.\nSince Patient Details (".$msg."Last Name, Contact No, DOB) Already Exists. Please try to login.";
			return $this->sendResponse([], 202, 'Failed', $errors);
		}
		else
       	{
			if(!$request -> pat_id) {
				$userData= $this -> callEvcAPI("POST", "ws/patientportal/patient/check_px_profile_exist", json_encode( array("first_name" => $request->first_name, "last_name" => $request->last_name,"dob" => $request->dob,"contact_num"=>$request->contact_num, "ohip" => "")));
				$userData= json_decode($userData, true);
				
				if($userData['data'] && $userData['data']['patient_exist'] == "1") {
					$errors = "Patient information not saved.\nSince Patient Details (".$msg."Last Name, Contact No, DOB) Already Exists. Please try to login.";
					return $this->sendResponse([], 201, 'Failed', $errors);
				}
			}
			if($errors == "")
			{
				$ecpatmaster = new Ecpatmaster();
				$ecpatmasterBeforeSave =  $ecpatmaster;
        		
				$reqArr = $this->getUpperCaseRequest($request);
				if($request -> pat_id) {
					$ecpatmaster = Ecpatmaster::find($request -> pat_id);
				}
				$ecpatmaster->fill($reqArr);
				$ecpatmaster -> REG_NUM =  Carbon::now()->format("Ym-dH-is");
				$ecpatmaster -> CREATED_DATE = $todayDate;
				// $ecpatmaster -> CREATEDBY = $userId;
				$ecpatmaster -> OHIP = str_replace('_','',$request->ohip);
				$ecpatmaster ->IS_SUBSCRIBE_EMAIL=0;
				$ecpatmaster -> LOCATION_ID = $request -> location_id;
				$ecpatmaster->save();
				//Notification section added 
				$reqArr = array("location_id" =>  $request->location_id, "created_date" => $ecpatmaster->CREATED_DATE,"first_name" => $ecpatmaster->FIRST_NAME,"last_name" => $ecpatmaster->LAST_NAME,"gender" => $ecpatmaster->GENDER,"dob" => $ecpatmaster->DOB,"pat_id" => $ecpatmaster->PAT_ID,"evc_pat_id" =>"0","px_status" => "0","ecrq_id" => NULL,"evc_ecrq_id" => NULL,"app_status" => NULL,"app_updated_date" => NULL,"questionaire_id" => NULL,"evc_questionaire_id" => NULL,"questionaire_status" => NULL,"questionaire_updated_date" => NULL);
				
				$userInfo = [
					'USERID' => $ecpatmaster -> PAT_ID,
					'PAT_ID' => $ecpatmaster -> PAT_ID,
					'LOCATION_ID' => $ecpatmaster -> LOCATION_ID,
					'FIRST_NAME' => $ecpatmaster -> FIRST_NAME,
					'LAST_NAME' => $ecpatmaster -> LAST_NAME,
					'GENDER' => $ecpatmaster -> GENDER,
					'CONTACT_NUM' => $ecpatmaster -> CONTACT_NUM,
					'DOB' => $ecpatmaster -> DOB,
					'EVC_PAT_ID' => '0',						
					'STATUS' => 'P',
					'USER_TYPE' => 'P',
					'PATIENT_TYPE' => 'New',
				];
				
				$request->session()->put('user', $userInfo);
				$request->session()->save();
				
				if($request -> pat_id) {
					$this->SaveNotifications($reqArr,"NewPatient");
					$this->getPxAptStatus($request, $clinicKey, true);
				}
			}
		}
        return $this->sendResponse($userInfo);
    }
	
	public static function updateLocationId(Request $request) {
		$userInfo = $request->session()->get('user');
		$userInfo['LOCATION_ID'] = $request -> location_id;
		$request->session()->put('user', $userInfo);
		$request->session()->save();
		return $userInfo;
	}
	//Get Insurance 
	public function getInsurance() {
	
	 $resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/insurance", 
                      json_encode(array("clinicKey" => "clinic1")));
     return $resultAPI;
            
    } 

 	//Get province 
	public function getProvince() {
		$resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/province",'');
		 return $resultAPI;
    } 
 	// GET patient city 
	public function getPatientCity() {
		$resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/patient/city",'');
		return $resultAPI;
   }
   //GET Patient Occupations
   public function getPatientOccupations() {
   		$resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/patient/occupations",'');
		return $resultAPI;
    }
	//GET Patient Referrals
	public function getPatientReferrals() {
		$resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/patient/referrals",'');
		return $resultAPI;
    }
    /* Returns Office location	details */
	public function getOfficeLocation_details() {
         $resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/officelocationdetails", 
                      json_encode(array("clinicKey" => "clinic1")));
          return $resultAPI;
    }  
	public function getOfficeLocation() {
        $resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/officelocation", 
                      json_encode(array("clinicKey" => "clinic1")));
        return $resultAPI;
    }  
	public function getClinicLocations() {
        $resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/clinic/locations", json_encode(array("clinicKey" => "clinic1")));
		$locationData= json_decode($resultAPI, true);
		if(session('user')){
			$locationData['message'] = session('user')['LOCATION_ID'];
		}else{
			$locationData['message'] = "";
		}
        return $locationData;
    }  
	
   //Get Online Patients
	public function getOnlinePatients(Request $request) {
		$ecpatmaster = new Ecpatmaster();
		$responseData = $ecpatmaster ::orderBy('PAT_ID', 'ASC')->where('online_status','0')->get();
		return $this->sendResponse($responseData);
		
	} 
	 //Validate Otp 
	 public function validateOtp(OtpRequest $request) {
		$otppassword = $request->otppassword;
		$userid = $request->userid;
		$ecuserotp = new Ecuserotp();
		$todayDateTime = Carbon::now()->format('Y-m-d H:i:s');
		$otpData = $ecuserotp->where(['otp' => $otppassword, 'user_id' => $userid])->whereRaw("FLOOR(TIMESTAMPDIFF(SECOND, created_on, '$todayDateTime'))  < 240")->get();
		if (count($otpData) === 1) {
		// update query
			$uid= $userid;
			//$query = "update ecusers set is_online='1' where userid='$uid'";	 
			//$is_onlineData = DB::select($query);
			Ecuserotp::where(['user_id' => $userid])->delete();
			return $this->sendResponse(session('user'), 200, 'Congrats! OTP matched');
		} 
		return $this->sendResponse([], 500, 'Please enter valid OTP');
	  }
	  	
	 
    //Get Online new patients 	 
    public function getOnlinenewPatients(Request $request) {
	 
		//Patient with Appointment 
		$ecpatmaster = new Ecpatmaster();
		
		$responseData = $ecpatmaster ::orderBy('PAT_ID', 'DESC')->where('EVC_PAT_ID','0')->where(function($query) use($request) {
			if (isset($request->status)) {
				$query -> where('ONLINE_STATUS',$request->status);
				
			}
		})->get();
		
		$datas = array();
		$sno = 1;
		foreach($responseData as $data){
		$questionaire1 = new Ecpatquestionaire1();
			$dataNew = NULL;
			$dataNew['sno'] = $sno++;
			$dataNew['patient_name'] = ucwords($data->FIRST_NAME." ".$data->LAST_NAME);
			$dataNew['type'] = " Patient-With-App";
			$dataNew['created_date'] = $data->CREATED_DATE;
			$dataNew['patient_data'] =$ecpatmaster->where('PAT_ID',$data->PAT_ID)->select('PAT_ID','FIRST_NAME','LAST_NAME','GENDER','DOB','CREATED_DATE','CONTACT_NUM','ONLINE_STATUS','EVC_PAT_ID','EVC_UPDATED_DATE','EVC_UPDATED_BY')->first();
			$dataNew['patient_data']->AGE= DateUtil::age($data->DOB);
			$ecregnumq= new Ecregnumq();
			$dataNew['app_data']=$ecregnumq->where('PAT_ID',$data->PAT_ID)->select('ECRQ_ID','FIRST_NAME','LAST_NAME','DOC_ID','STARTDATE','ENDDATE','ONLINE_APP_STATUS','CODE_ID','APPDESC','APPOINTMENTCODE','NOTES as NOTE','EVC_UPDATED_DATE','EVC_UPDATED_BY')->first();
			$dataNew['qn_data']=$questionaire1 ->where('PAT_ID',$data->PAT_ID)->select('id','first_name','last_name','created_date','evc_pat_id','online_qn_status','evc_qn_id','notes','evc_updated_date','evc_updated_by')->first();

			if($dataNew['patient_data'] && $dataNew['app_data']) {
				if($dataNew['app_data']->DOC_ID !=""){
					$dataNew['patient_data']->PREFERRED_DOC = $dataNew['app_data']->DOC_ID;
				}
			}
			$dataNew['qn_data']="";
			$datas[] = $dataNew;
		} 
		
		//Appointment 
		$ecregnumq= new Ecregnumq();
		$ecregresponseData = $ecregnumq::orderBy('CREATED_DATE', 'asc')
		->where('EVC_PAT_ID','!=','0')->where(function($query) use($request) {
			if (isset($request->status)) {
				$query -> where('ONLINE_APP_STATUS',$request->status);
			}
		})->select('ECRQ_ID','FIRST_NAME','LAST_NAME','PAT_ID', 'DOC_ID','STARTDATE','ENDDATE','NOTES','ONLINE_APP_STATUS','EVC_PAT_ID','DOB','CODE_ID','APPDESC','APPOINTMENTCODE','CREATED_DATE','NOTES as NOTE','EVC_UPDATED_DATE','EVC_UPDATED_BY')->get();
		foreach($ecregresponseData as $data){
			$dataNew = NULL;
			$dataNew['sno'] = $sno++;
			$dataNew['type'] = "App";
			$dataNew['patient_name'] = ucwords($data->FIRST_NAME." ".$data->LAST_NAME);
			$dataNew['created_date'] = $data->CREATED_DATE;
			$dataNew['patient_data']= $ecregnumq::orderBy('ecregnumq.PAT_ID', 'DESC')->where('ECRQ_ID','=',$data->ECRQ_ID)->leftJoin('ecpatmaster as pat', 'pat.PAT_ID', 'ecregnumq.PAT_ID')->select('ecregnumq.FIRST_NAME','ecregnumq.LAST_NAME','ecregnumq.PAT_ID','ecregnumq.GENDER','ecregnumq.DOB','ecregnumq.CONTACT_NUM','ecregnumq.EVC_PAT_ID','pat.ONLINE_STATUS','pat.EVC_UPDATED_DATE','pat.EVC_UPDATED_BY')->first();
			if($dataNew['patient_data']) {
				$dataNew['patient_data']->AGE= DateUtil::age($data->DOB);
				if($data->DOC_ID !=""){
					$dataNew['patient_data']->PREFERRED_DOC = $data->DOC_ID;
				}
			}
			$dataNew['app_data']= $data;
			$dataNew['qn_data']="";
			$datas [] = $dataNew;
		}
		
		
		//Qn with Exisiting Patient 
		
		$patquestionaire1= new Ecpatquestionaire1();
		$patquestionaire1responseData = $patquestionaire1
		->where('evc_pat_id','!=','0')->where(function($query) use($request) {
			if (isset($request->status)) {
				$query -> where('online_qn_status',$request->status);
			}
		})->select('id','pat_id','online_qn_status','first_name','last_name','created_date','evc_pat_id')->get();
		foreach($patquestionaire1responseData as $data){
			$dataNew = NULL;
			$dataNew['sno'] = $sno++;
			$dataNew['type'] = "App";
			$dataNew['patient_name'] = ucwords($data->first_name." ".$data->last_name);
			$dataNew['created_date'] = $data->created_date;
			//$dataNew['patient_data']= $data->pat_id;
			if($data->pat_id ==0){
				$dataNew['patient_data']= $patquestionaire1->where('evc_pat_id','=',$data->evc_pat_id)->select('first_name','last_name','evc_pat_id','online_qn_status')->first();
				$dataNew['patient_data']->ONLINE_STATUS=1;
				$dob = $request->session()->get('user')['DOB'];
				$dataNew['patient_data']->AGE= DateUtil::age($dob);
				}else{
				$dataNew['patient_data']= $ecpatmaster->where('PAT_ID','=',$data->pat_id)->select('ecpatmaster.FIRST_NAME','ecpatmaster.LAST_NAME','ecpatmaster.PAT_ID','ecpatmaster.GENDER','ecpatmaster.DOB','ecpatmaster.CONTACT_NUM','ecpatmaster.EVC_PAT_ID','ecpatmaster.ONLINE_STATUS','ecpatmaster.EVC_UPDATED_DATE','ecpatmaster.EVC_UPDATED_BY')->first();
				$dataNew['patient_data']->AGE= DateUtil::age($dataNew['patient_data']->DOB);
				}
			$dataNew['app_data']= "";
			if($data->pat_id ==0){
			$dataNew['qn_data']=$patquestionaire1->where('evc_pat_id',$data->evc_pat_id)->select('id','first_name','last_name','dob','created_date','evc_pat_id','online_qn_status','evc_qn_id','notes','evc_updated_date','evc_updated_by')->first();
			}else{
			$dataNew['qn_data']=$patquestionaire1->where('pat_id',$data->pat_id)->select('id','first_name','last_name','dob','created_date','evc_pat_id','online_qn_status','evc_qn_id','notes','evc_updated_date','evc_updated_by')->first();
			}
			$dataNew['qn_data']->AGE = DateUtil::age($dataNew['qn_data']->dob);
			$datas [] = $dataNew;
		}
		
		//Finish qn exisitng Patient 
		
		
		$paginate = $request -> page_size;
		$page = $request -> from;
		
		$datas = collect($datas);
		$result = new \Illuminate\Pagination\LengthAwarePaginator($this->fixForPage($datas->forPage($page, $paginate)), $datas->count(), $paginate, $page);
		return $this->sendResponse($result);
	} 
	
   //Get Online New patients by id	
   public function getOnlinenewPatientsbyid($clinickey,$id) {
		$ecpatmaster = new Ecpatmaster();
		$responseData = $ecpatmaster ::orderBy('PAT_ID', 'ASC')->where('PAT_ID',$id)->first();
		$ecregnumq= new Ecregnumq();
		if($responseData)  {
			$app_data = $ecregnumq::where('PAT_ID','=',$responseData->PAT_ID)->first();
			if($app_data) {
				$responseData -> PREFERRED_DOC = $app_data -> DOC_ID;
			}
		}
		return $this->sendResponse($responseData);
	} 
	
	
   //Update Patient status
   public function updatePxStatus(Request $request, $clinicKey) {
        $pat_id = $request->pat_id;
        $evc_pat_id= $request->evc_pat_id;
        $status= $request->status;
        $notes= $request->notes;
		$evc_updated_date= $request->evc_updated_date;
		$evc_updated_by= $request->evc_updated_by;
		$notification_id = $request->notification_id;
       
		$ecpatmaster = new Ecpatmaster();
		
        if($pat_id !== null) {
            $ecpatmaster = $ecpatmaster ::find($pat_id );
            if($ecpatmaster == null) {
                $errors = array('Id: ' . $id . ' not exist');
                return $this->sendResponse([], 400, 'Failed', $errors);
            }
        }
		
        $ecpatmaster ->pat_id = $pat_id;
        $ecpatmaster ->online_status= $status;
		if($evc_pat_id)
	        $ecpatmaster ->evc_pat_id= $evc_pat_id;
        $ecpatmaster ->notes = $notes;
		$ecpatmaster ->evc_updated_date = $evc_updated_date;
		$ecpatmaster ->evc_updated_by = $evc_updated_by;
	  
	    $ecpatmaster ->save();
	
	    $ecregnumq= new Ecregnumq();
	    $ecregnumq= $ecregnumq->where('pat_id', $pat_id)->where('EVC_PAT_ID', 0)->get();
	    foreach($ecregnumq as $data){
	       $ecrq_id = $data->ECRQ_ID;
	       $ecregnumq= new Ecregnumq();
	       $ecregnumq= $ecregnumq::find($ecrq_id);
	      if($evc_pat_id)
	       $ecregnumq->EVC_PAT_ID= $evc_pat_id;
	       $ecregnumq->save();
	   }
	   
	     //Questionnaire status 
	   $questionaire1 = new Ecpatquestionaire1();
	   $questionaire1 = $questionaire1 ->where('pat_id', $pat_id)->where('evc_pat_id', 0)->get();
	    foreach($questionaire1 as $data){
	       $id= $data->id;
	       $questionaire1 = new Ecpatquestionaire1();
	        $questionaire1 = $questionaire1 ::find($id);
	        if($evc_pat_id)
	       $questionaire1 ->evc_pat_id= $evc_pat_id;
	       $questionaire1 ->save();
	   }
	   
	   $reqArr = array("notification_id" =>  $notification_id, "location_id" =>  $ecpatmaster->LOCATION_ID, "pat_id" => $ecpatmaster->pat_id,"evc_pat_id" => $ecpatmaster ->evc_pat_id,"px_status" =>$ecpatmaster->online_status ,"px_updated_date" => $ecpatmaster->evc_updated_date,"px_updated_by" => $ecpatmaster->evc_updated_by);
	    //Notification section - Patient status Update
	   if($ecpatmaster->online_status=="2"){
	   		$reqArr["app_status"] = $ecpatmaster->online_status;
			$reqArr["questionaire_status"] = $ecpatmaster->online_status;
	   }	 
	   $this->SaveNotifications($reqArr,"UpdatePx");
	   $this->getPxAptStatus($request, $clinicKey, true, $ecpatmaster->LOCATION_ID);
        return $this->sendResponse($ecpatmaster ); 
   } 
   	
	public function getClinicLogo(Request $request){
		
	    $aws_path= $this -> callEvcAPI("GET", "ws/patientportal/getClinicLogo/{$request->location_id}", 
                      json_encode(array("clinicKey" => "clinic1")));
        $resultAPI =     json_decode($aws_path);
        $t = file_get_contents($resultAPI ->aws_path);
		if($t !== FALSE) {
			$file = $t;
		}
		$img_type = $this -> getMimeType($resultAPI ->path);
		$response = Response::make($file, 200);
		$response->header("Content-Type", $resultAPI ->img_type);
	    return $response;
	
	}
	
	public function getPatientPortalBg(Request $request){
		
	    $aws_path= $this -> callEvcAPI("GET", "ws/patientportal/getPatientPortalBg/{$request->location_id}", 
                      json_encode(array("clinicKey" => "clinic1")));
        $resultAPI =     json_decode($aws_path);
        $t = file_get_contents($resultAPI ->aws_path);
		if($t !== FALSE) {
			$file = $t;
		}
		$img_type = $this -> getMimeType($resultAPI ->path);
		$response = Response::make($file, 200);
		$response->header("Content-Type", $resultAPI ->img_type);
	    return $response;
	
	}
	
	//online notification save function 
	
	public static  function SaveNotifications($request,$type) {
		
		// $userInfo = session('user');
		
		// // 1. Decide exising or new patient
		// $px_cond = "";
		// if($userInfo['EVC_PAT_ID'] == '0') {
		// 	$px_cond = "pat_id='". $userInfo['PAT_ID'] . "'";
		// }else {
		// 	$px_cond = "evc_pat_id='". $userInfo['EVC_PAT_ID'] . "'";
		// }

		// 1. Decide exising or new patient
		$px_cond = "";
		if($request['evc_pat_id'] == NULL || $request['evc_pat_id'] == '0') {
			$px_cond = "pat_id='". $request['pat_id'] . "'";
		}else {
			$px_cond = "evc_pat_id='". $request['evc_pat_id'] . "'";
		}
		
		// 2. Check for today notifications.
		$todayDate = Carbon::now()->format('Y-m-d');
		$todayCheck = " date_format(created_date, '%Y-%m-%d')='".$todayDate."'";
		
		// // 3. Check in the particular location.
		// $location_id = $userInfo['LOCATION_ID'];
		// $request['location_id'] = $location_id;

		if(isset($request['notification_id']) && $request['notification_id'] != '') {
			$patientportalnotification = new PatientPortalNotification();
			$t = $patientportalnotification ->  where('id', $request['notification_id'] ) -> where('location_id', $request['location_id'])->first();	
		}else{
			$patientportalnotification = new PatientPortalNotification();
			$t = $patientportalnotification -> whereRaw($todayCheck) -> whereRaw($px_cond) -> where('location_id', $request['location_id'])->first();	
		}
		
		$page1 = (new self) -> convertToObjectLevelOne($request);
		
		if($t) {
			$patientportalnotification = $t;
		}
		
		$patientportalnotification =  (new self) ->  requestToModel($page1, $patientportalnotification);
		
		if($request['evc_pat_id'] == NULL || $request['evc_pat_id'] == '0') {
		    $patientportalnotification->px_status='0';
		}else {
			$patientportalnotification->px_status='1';
		}
		
		$patientportalnotification->save();
		return  (new self) -> sendResponse($patientportalnotification); 
    } 
	
	//Get Online new patients from patient portal notifications section	 
    public function getOnlinenewPatientsNotifications(Request $request) {
		$patientportalnotification= new PatientPortalNotification();
		$responseData = $patientportalnotification->leftJoin('ecregnumq', 'ecregnumq.ECRQ_ID', 'patient_portal_notifications.ecrq_id')
			->where('patient_portal_notifications.location_id', $request->location_id)
		    ->where(function($query) use($request) {
				if (isset($request->status)) {
					if($request->status =="1"){
						$query->where('patient_portal_notifications.px_status',$request->status)
							->orWhere('patient_portal_notifications.app_status',$request->status)
							->orWhere('patient_portal_notifications.questionaire_status',$request->status);
					}else if($request->status =="2"){
						$query->where('patient_portal_notifications.px_status',$request->status)
							->orWhere('patient_portal_notifications.app_status',$request->status)
							->orWhere('patient_portal_notifications.questionaire_status',$request->status);
					}else if($request->status =="-1"){
						$query->where('patient_portal_notifications.is_deleted','1')
						->where(function($subquery) use($request) {
							$subquery->where('patient_portal_notifications.px_status','0')
								->orWhere('patient_portal_notifications.app_status','0')
								->orWhere('patient_portal_notifications.questionaire_status','0');
						});
					}else{	
						$query->where('patient_portal_notifications.is_deleted','0')
						->where(function($subquery) use($request) {
							$subquery->where('patient_portal_notifications.px_status','0')
								->orWhere('patient_portal_notifications.app_status','0')
								->orWhere('patient_portal_notifications.questionaire_status','0');
						});
					}		   
				}
			})->orderBy('patient_portal_notifications.id', 'DESC')->select('patient_portal_notifications.*','ecregnumq.ECRQ_ID','ecregnumq.CONTACT_NUM','ecregnumq.STARTDATE','ecregnumq.ENDDATE','ecregnumq.NOTES','ecregnumq.DOC_ID','ecregnumq.ONLINE_APP_STATUS','ecregnumq.CODE_ID','ecregnumq.APPDESC','ecregnumq.APPOINTMENTCODE')
		->paginate($request -> page_size, ['*'], 'page', $this -> getPageNo($request -> from, $request -> page_size));
	
		return $this->sendResponse($responseData);
	} 

	//delete Pxnotificaiton status 
     public function deletePxNotifications(Request $request, $clinicKey) {
        $id= $request->notification_id;
		$patientportalnotification= new PatientPortalNotification();
		if($id!== null) {
			$patientportalnotification= $patientportalnotification::find($id);
			if($patientportalnotification== null) {
				$errors = array('Id: ' . $id . ' not exist');
				return $this->sendResponse([], 400, 'Failed', $errors);
			}
		
		// if($patientportalnotification->px_status==0){
		//     $patientportalnotification->px_status=2;    
		// }
		// if($patientportalnotification->app_status==0){
		//     $patientportalnotification->app_status=2;    
		// }
		// if($patientportalnotification->questionaire_status==0){
		//     $patientportalnotification->questionaire_status=2;    
		// }
			$patientportalnotification->is_deleted=1;
			$patientportalnotification->deleted_by=$request->evc_updated_by;
			$patientportalnotification->save();
			
			$this->getPxAptStatus($request, $clinicKey, true, $patientportalnotification->location_id);
			return $this->sendResponse($patientportalnotification); 	
		}else{
			$errors = array('Id does not exist');
			return $this->sendResponse([], 400, 'Failed', $errors);
		}
    } 
	
	//unsubscribe Link 
	public function getunsubscribe_by_link(Request $request,$clinicKey,$p,$e){
  
  		$p = base64_decode($p);
  		$e = base64_decode($e);
	/*	$response = $this -> callEvcAPI("POST", "ws/app_rem_link/confirmAppByLink",  $p);
		$resultAPI = json_decode($response , true);
        $officeName= $resultAPI['officeName'];
        $message= $resultAPI['message'];*/
        $officeName= "evisioncare";
        $message= "Test message by Javid ";
        return view('unsubscribe', ['officeName' => $officeName,'message' => $message,'emailid' => $e,'patid' => $p]);
    }
    
    
	public function getunsubscribeto_by_link(Request $request,$clinicKey){
       
  	 	$response = $this -> callEvcAPI("POST", "ws/patientportal/unsubscribe",  json_encode(array("patid" => $request->patid, "emailid" => $request -> emailid)));
	    $resultAPI = json_decode($response , true);
	    $officeName= $resultAPI['officeName'];
        $message= $resultAPI['message'];
        $titlemessage =$resultAPI['titlemessage']; 
        return view('unsubscribe-success', ['officeName' => $officeName,'message' => $message,'titlemessage' => $titlemessage,'emailid' => $e,'patid' => $p]);
    }
	
	public function getOnlinePaymentDetails(Request $request,$clinicKey) {
		   //return $request->transaction_no;
		   
         $resultAPI = $this -> callEvcAPI("POST", "ws/patientportal/onlinepaymentdetails", 
                      json_encode(array("clinicKey" => "clinic1","transaction_no" =>$request->transaction_no)));
          return $resultAPI;
		  
    } 
	
	public function confirmOnlinePayment(Request $request,$clinicKey) {
		$params = $request -> all();
	    $params['transaction_no'] = $request -> transaction_no;
	    $params['status'] = $request -> status;
	    $params['clinicKey'] = $clinicKey;
	    $resultAPI = $this -> callEvcAPI("POST", "ws/patientportal/confirmonlinepayement", json_encode($params));
        return $resultAPI;  
    } 
	
	public function submitOnlinePayment(Request $request,$clinicKey) {
		$headers = array('Content-Type: application/json', 'tilled-account: '. $request-> tilled_config["account_id"] , 'tilled-api-key: '. $request-> tilled_config["api_key"]);
		$tilled_base_url = "https://api.tilled.com/";
		$data = json_encode($request -> payment_method);
		$result = $this -> callAPI('POST', $tilled_base_url.'v1/payment-methods', $data, $headers);
		$result = json_decode($result, true);
		if($this -> status_code == 201) {
			$payment_intent = $request -> payment_intent;
			$payment_intent['confirm'] = true;
			$payment_intent['payment_method_id'] =  $result['id'];
			$data = json_encode($payment_intent);
			//return [$data ];
			$result = $this -> callAPI('POST', $tilled_base_url.'v1/payment-intents', $data, $headers);
			$result = json_decode($result, true);
			
			/*$data = json_encode($payment_intent);
			//return [$data ];
			$result = $this -> callAPI('POST', $tilled_base_url.'v1/payment-intents/'.$payment_intent_id.'/confirm', $data, $headers);
			$result = json_decode($result, true);
			
			return $this->sendResponse($result);*/
			
			if(isset($result['last_payment_error']) && $result['last_payment_error']) {
				return $this->sendResponse(["message" => $result['last_payment_error']['message']], 400);
			}
			return $this->sendResponse($result);
		}else {
			return $this->sendResponse(['message' => $result['message']], 400);
		}
		
	}

	public function updateNotificationCount(Request $request, $clinicKey) {
		$response = $this->getPxAptStatus($request, $clinicKey, true, $request->location_id);
		return $response;
	}

	//getPxAptStatus - New
	public static function getPxAptStatus(Request $request, $clinicKey, $notify = false, $location_id = null) {
		$userInfo = session('user');
		if($location_id == null && $userInfo!= null){
			$location_id = $userInfo['LOCATION_ID'];
		}
		if (isset($location_id)) {
			$patientportalnotification= new PatientPortalNotification();
			//New patient count 
			// $newpatcount = (clone $patientportalnotification)->where('px_status','0')->get();
			// $newpatcount = $newpatcount->count();
			//Exisiting patient with appointments or questionnaires
			$patientportalnotification= new PatientPortalNotification();
			$newpatcount1 = $patientportalnotification->where(function($query){
					$query->where('px_status','0')
					->orwhere('app_status',0)
					->orWhere('questionaire_status',0);
			
			})->where('is_deleted','0')->where('location_id',$location_id)->count();

			$patientportalnotification= new PatientPortalNotification();
			$deletenotificationcount = $patientportalnotification->where(function($query){
					$query->where('px_status','0')
					->orwhere('app_status',0)
					->orWhere('questionaire_status',0);
			
			})->where('location_id',$location_id)->where('is_deleted', '1')->count();
			// $newpatcount =$newpatcount1;
			
			//Accepted count
			$patientportalnotification= new PatientPortalNotification();
			$acceptedpatcount = $patientportalnotification->where('px_status','1')->where(function($query){
					$query->where('app_status','1')
					->orWhere('questionaire_status','1');
			
			})->where('location_id',$location_id)->count();
			
			//Rejected count
			$patientportalnotification= new PatientPortalNotification();
			$rejectedpatcount = $patientportalnotification->where(function($query){
					//->where('px_status','2')
					$query->orwhere('px_status','2')
					->orwhere('app_status','2')
					->orWhere('questionaire_status','2');
			
			})->where('location_id',$location_id)->count();
			
			//overall count 
			
			$patientportalnotification= new PatientPortalNotification();
			$overallcount = $patientportalnotification->where('location_id',$location_id)->count();

			//$overallcount = $newpatcount + $acceptedpatcount + $rejectedpatcount;
			
			$datas = array();
			$dataNew = NULL;
			
			// $dataNew['newpatcount']      = $newpatcount;
			// $dataNew['acceptedpatcount'] = $acceptedpatcount;
			// $dataNew['rejectedpatcount'] = $rejectedpatcount;
			// $dataNew['newaptcount']      = $newpatcount;
			// $dataNew['acceptaptcount']   = $acceptedpatcount;
			// $dataNew['rejectaptcount']   = $rejectedpatcount;
			$dataNew['newoverallcount']   = $newpatcount1;
			$dataNew['deletenotificationcount']   = $deletenotificationcount;
			$dataNew['acceptedoverallcount']   = $acceptedpatcount;
			$dataNew['rejectedoverallcount']   = $rejectedpatcount;
			$dataNew['overallcount']   = $overallcount;
			
			if($notify) {
				$todayDate = Carbon::now()->format('Y-m-d H:i:s');
				$dataNew['updateddate'] = $todayDate;

				(new self) -> notify($clinicKey, $dataNew, false, $location_id);
			}
			$datas[] = $dataNew;
			return  (new self) -> sendResponse($dataNew);
		}else{
			return  (new self) -> sendResponse([]);
		}
	} 
	
	public function exisingPatientPortalLogin(Request $request) {
		 $resultAPI = $this -> callEvcAPI("POST", "ws/patientportal/exising-px-login", 
                      json_encode(array("clinicKey" => "clinic1","pat_uid" =>$request->pat_uid, "dob" =>$request->dob)));
         $responseData= json_decode($resultAPI, true);
		 $userData=$responseData['data'];

	     if($userData && $responseData['status_code'] == 200){
			   $userInfo = [
					'LOCATION_ID' => $userData['location_id'],
					'USERID' => $userData['pat_id'],
					'PAT_ID' => '0',
					'FIRST_NAME' => $userData['first_name'],
					'LAST_NAME' => $userData['last_name'],	
					'GENDER' => $userData['gender'],
					'CONTACT_NUM' => $userData['contact_num'],
					'DOB' => $userData['dob'],
					'EVC_PAT_ID' => $userData['pat_id'],						
					'STATUS' => 'P',
					'USER_TYPE' => 'P',
					'PATIENT_TYPE' => 'Existing',
				];
				$request->session()->put('user', $userInfo);
	            $request->session()->save();
		}
		return $resultAPI;
	}
	
	public function verifyPatientPortalDirectLink(Request $request) {
		 $resultAPI = $this -> callEvcAPI("POST", "ws/patientportal/verify-existing-px-link", 
                      json_encode(array("clinicKey" => "clinic1","pat_uid" =>$request->pat_uid)));
          return $resultAPI;
	}
}