<?php

namespace App\Http\Controllers;
use App\Http\Models\JSONResponse;
use App\Models\Ecmailconfiguration;
use App\Models\Ecclinicsetup;
use App\Http\Clients\ErrorHandler;
use App\Models\Ecmailoutbox;
use App\Models\Ecefaxsmtpsetting;
use App\Http\Classes\TwillioApi;
use Mail;
use Parser;
use DB;
use File;
use Swift_Mailer;
use Swift_MailTransport;
use Swift_Message;
use Swift_Attachment;
//require '../vendor/autoload.php';
use Twilio\Rest\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use App\Http\Classes\AWSS3;
use View;
use Excel;

class CommonController extends Controller {
	var $status_code;
	public function getContactNum($num) {
		$num = preg_replace("/[^0-9]/", "", $num);
		if(strlen($num) == 7) {
			$num = "(000) ".substr($num, 0, 3) . "-". substr($num, 3, 4);
		}else if(strlen($num) == 10) {
			$num = "(". substr($num, 0, 3) . ") ". substr($num, 3, 3) . "-". substr($num, 6, 4);
		}
		return $num;
	}
    public function checkForValidation($payload, $rules) {
		$validator = new ErrorHandler($payload, $rules); //It will throw the exception as response
		return $validator;
	}
	
	public function sendResponse ($data, $statusCode=200, $message='Success', $errors=[]) {
		$updatedData = !is_array($data) ? $data->toArray() : $data;
		$updatedData = $this->updateNullValueWithEmptyValue($updatedData);
		$jsonResponse = new JSONResponse();
		$jsonResponse->setStatusCode($statusCode);
		$jsonResponse->setMessage($message);
		$jsonResponse->setData($updatedData);
		$jsonResponse->setErrors($errors);
		return $jsonResponse->output();
	}
	
	public function requestToModel($req, $model) {
		if(class_basename($req) == "Request") {
			$model -> fill($req -> all());
		}else{
			if (isset($model -> fillable))
			foreach($model -> fillable as $k) {
				if(isset($req -> {$k}) || property_exists($req, $k))
					$model -> {$k} = $req -> {$k};
			} 
		}
		return $model;
	}
	
	public function requestArrToModel($req, $model) {
		if (isset($model -> fillable))
		foreach($model -> fillable as $k) {
			if(isset($req[$k]) || (array_key_exists($k,$req) && $req[$k] == ''))
				$model -> {$k} = $req[$k];
		}
		return $model;
	}
	
	public function output($responseData) {
		return ($responseData instanceof JsonResponse) ? $responseData : $this->sendResponse($responseData);
	}
	
	public function getRandomNumber($digits=4) {
		return rand(1234, 9999);
	}
/*
	public function sendEmail($emailData) {
		Mail::send($emailData['templatePath'], $emailData, function ($m) use ($emailData) {
       
            $m->from('admin@myevisioncare.com', 'clinic1.myevcportal.com');
            $m->to($emailData['toEmail'])->subject($emailData['subject']);
        });
	}
*/
    public function sendEmail($emailData, $headers = NULL) {
		$clinicSetupData = DB::table('ecofficelocation')->first();

		$clinicData = DB::table('ecmailconfiguration')->first();
		if(!is_array($emailData)) {
			$emailData = json_decode(json_encode($emailData), true);
		}
						
		//Spam Email check 
		
		
		$spam_mail = DB::table('ecspamemaillist')->where(['email' => $emailData['toEmail']])->first();
		$spam_count = count($spam_mail);
						
	    $emailData['fromEmail']= $clinicData -> email;
		$emailData['officeName'] = $clinicSetupData -> officeName;
		$emailData['office_address1'] = $clinicSetupData -> address1;
		$emailData['office_city'] = $clinicSetupData -> city;
		$emailData['office_state'] = $clinicSetupData -> state;
		$emailData['office_phone'] = $clinicSetupData -> phone;
		$emailData['office_email'] = $clinicSetupData -> email;
		
		if($emailData['templatePath'] != '' && $spam_count ==0) {
			$toid = $emailData['toEmail'];		
			 if($toid) {
				
				//saving outoging mail details 
				$cur_date = date("Y-m-d H:i:s");
				$fromid = $emailData['fromEmail'];
				$toid = $emailData['toEmail'];
				$subject = $emailData['subject'];
				$message = $emailData['subject'];
				
				if(is_array($toid)) {
					$toid = implode(",", $toid);
				}
				  $ecmailoutbox = new Ecmailoutbox();
				  if(session('user'))
					  $ecmailoutbox->userid = session('user')['USERID'];
				  $ecmailoutbox->fromid = $emailData['fromEmail'];
				  $ecmailoutbox->toid = $toid;
				  $ecmailoutbox->subject = $emailData['subject'];
				  $ecmailoutbox->date_created = Carbon::now()->format("Y-m-d H:i:s");
				  $ecmailoutbox->date_sent = Carbon::now()->format("Y-m-d H:i:s");
				  $ecmailoutbox->status = "1";
				  $ecmailoutbox->save();
				  
				  $mail_content = View::make($emailData['templatePath'], $emailData)->render();
				  $mail_path = 'mail_out/' . Carbon::now()->format('Y') . "/" . Carbon::now()->format('m') . "/" . Carbon::now()->format('d') . "/{$ecmailoutbox->id}.inc";
				  AWSS3::upload($mail_path, $mail_content);
				  
				  $ecmailoutbox->message = $mail_path;
			   	  $ecmailoutbox -> save();

				// we need this condition, sometimes header will come.
				if(!$headers)
				  $headers = array("evc_mail_id" => $ecmailoutbox->id,  "clinic_host_name" => $_SERVER['HTTP_HOST']);
		   }
				   
			if(!isset($emailData['email_tracker'])) {
				$emailData['email_tracker'] = "http://{$_SERVER['HTTP_HOST']}/ws/outbox/open/{$ecmailoutbox->id}?rnd=".rand(1, 123456);
			}
			Mail::send($emailData['templatePath'], $emailData, function ($m) use ($emailData, $headers) {
				$m->from($emailData['fromEmail'], $emailData['officeName']);
				$m->to($emailData['toEmail'])->subject($emailData['subject']);
				if(isset($emailData['attach_data'])){
					$m->attachData($emailData['attach_data']->output(),$emailData['attach_name'], ['mime' => $emailData['mime']]);
				}	
			
				$swiftMessage = $m->getSwiftMessage();
				 
                if($headers) {
                  $swiftMessageHeaders = $swiftMessage->getHeaders();
                  foreach($headers as $k=>$v) {
                    $swiftMessageHeaders->addTextHeader($k, $v);
                  }
                }
       	 	});
		}
	}

   public function getSms() {
		$clinicSetupData = DB::table('ecofficelocation')->first();
		$smsData['sms_number'] = $clinicSetupData -> sms_number;
		return $smsData;
	}
	
	
	public function convertObjectToArray($object) {
		return json_decode(json_encode($object), true);
	}
	
	public function fixForPage($datas) {
		$temp = [];
		foreach($datas as $d) {
			$temp[] = $d;
		}
		return $temp;
	}

	public function simpleXmlLoadString($xmlstring) {
		$xml = simplexml_load_string($xmlstring, "SimpleXMLElement", LIBXML_NOCDATA);
		$json = json_encode($xml);
		$array = json_decode($json,TRUE);
		return $array;
	}

	public function parseXmlToArray($xmlstring) {
		//return $this->parseJsonToXml(' { "message": { "to": "Jack Smith", "from": "Jane Doe", "subject": "Hello World", "body": "Hello, whats going on..." } }');
		$parsed = Parser::xml($xmlstring);
		return $parsed;
	}

	public function parseJsonToXml($jsonString) {
		$parsed = Parser::json($jsonString);
		return $parsed;
	}

	public function _extractPagingInfo($requet, $query, $mode) {
		//return if request doesnt want any pagination
		if($requet->apply_paging && $requet->apply_paging === false) {
			return [];
		}

		$pagingDetails = [
			'page' => 1,
			'limit' => 100
		];
		if ($requet->apply_paging && $requet->apply_paging === true) {
			$pagingDetails['page'] = $requet->page || 1;
			$pagingDetails['limit'] = $requet->limit || 100;
		}

		if ($mode === 'NATIVE_SQL') {
			$pagingDetails['query'] = $query . ' LIMIT ';
		} else if ($mode === 'MODEL_CLASS') {

		}

		return $pagingDetails;
	}

	public static function replaceNullValueWithEmptyString(&$value) {
		$value = ($value === null || $value === "NULL" || $value === "null") ? "" : $value;
	}

	public function updateNullValueWithEmptyValue($array) {
		array_walk_recursive($array, "self::replaceNullValueWithEmptyString");
		return $array;
	}

	  public function superUnique($array) {
		$result = array_map("unserialize", array_unique(array_map("serialize", $array)));

		foreach ($result as $key => $value)
		{
			if ( is_array($value) )
			{
				$result[$key] = super_unique($value);
			}
		}

		return $result;
    }

	public function convertToObject($array) {
		$object = new \stdClass();
		foreach ($array as $key => $value) {
			if (is_array($value)) {
				$value = $this->convertToObject($value);
			}
			$object->$key = $value;
		}
		return $object;
	}
	
	public function convertToObjectLevelOne($array) {
		$object = new \stdClass();
		foreach ($array as $key => $value) {
			if (is_array($value)) {
				//$value = $this->convertToObjectLevelOne($value);
				$object->$key = $value;
			}else {
				$object->$key = $value;
			}
		}
		return $object;
	}
	
	public function getPaginatedResult($query,$from,$size){
		$totalcount = 0;
		$arr = explode("FROM", $query );
		$statement = "";
		if(count($arr)>1){
			$statement = $arr[1];
		}
        $query = "SELECT COUNT(*) as totalcount FROM ".$statement;
		$totalRes = DB::select($query);
		$totalRes = $this->convertObjectToArray($totalRes);
		if(isset($totalRes) && count($totalRes) > 0){
			$totalcount = $totalRes[0]['totalcount'];
		}
		$query = $arr[0].", ".$totalcount." as totalcount FROM ".$statement." limit ".$from.",".$size;
		$Result = DB::select($query);
		
		return $Result;
	}
	
	function getPageNo($from, $pageSize) {
		$page = 1;
		if($from <= 0) {
			$page = 1;
		}else {
			$page = ceil(($from / $pageSize) + 1);
		}
		return $page;
	}
	
	public function sendEmailtest($emailData, $callbackFunc=null) {		
		try {			
			Mail::send($emailData['templatePath'], $emailData, function ($m) use ($emailData) {				
				//$m->getHeaders()->addTextHeader('X-SES-CONFIGURATION-SET', 'Email-Click');
				$m->from('admin@myevisioncare.com', 'Myevcportal.com');
				$m->to($emailData['toEmail'])->subject($emailData['subject']);
				$headers = $m->getHeaders();		
				$messageId = null;				
				foreach ($headers->getAll() as $header) {
					if (method_exists($header, 'getId')) {
						$messageId = $header->getId();
					}
				}								
				$emailData['messageId'] = $messageId;
				$callbackFunc($emailData);
				//$this->sendEmailCallback($emailData);
			});			
		} catch(\Exception $error){
			return ['error'=>$error->getMessage()];
		}
		
	}
	
	public function sendEmailCallback($emailData) {
		print_r($emailData); die;
	}
	
	public function SendCall($to_number,$path){
	
		return TwillioApi::AutoCall($to_number, $path);
		
	}
	
	public function sendSms($to_number,$message){
	
		return TwillioApi::Sms($to_number, $message);
	
	}
	
	
	public function getClinicPath() {
		$clinicPath = $_SERVER['HTTP_HOST'];
		$clinicPath = explode('.', $clinicPath);
		return $clinicPath[0];
	}

	public function getHostName($request){
		$hostName = $request->getHost();
		$hostName = str_replace("www.", "", $hostName);
		$hostName = str_replace("api.", "", $hostName);
		return $hostName;
	}

	public function getFullHostName($request){
		$hostName = $request->getHost();
		$hostName = str_replace("api.", "", $hostName);
		if(!str_contains($hostName,'www')){
			$hostName = 'www.'.$hostName;
		}
		return $hostName;
	}
	
	public function getMimeType($fileName) {
		$ext = File::extension($fileName);
		$ext = strtolower($ext);
		if($ext == "jpg" || $ext == "jpeg") {
			return "image/jpg";
		}else if($ext == "png") {
			return "image/jpg";
		}else if($ext == "pdf") {
			return "application/pdf";
		}else if($ext == "gif") {
			return "image/gif";
		}else {
			return "application/octet-stream";
		}
	}

	public function getUpperCaseRequest($request){
		$reqArr = $request->all();
		foreach(array_keys($reqArr) as $k) {
			$reqKey = strtoupper($k);
			$reqArr[$reqKey] = $reqArr[$k];
			unset($reqArr[$k]);
		}
		return $reqArr;
	}
	
	 public function sendSMTPEmail($emailData, $headers = NULL) {
	
	 	$ecefaxsmtpdata = DB::table('ecefaxsmtpsettings')->first();
	    $host= $ecefaxsmtpdata -> host;
		$port= $ecefaxsmtpdata -> port;
		$ssl= $ecefaxsmtpdata -> ssl;
		$name = $ecefaxsmtpdata -> name;
		$username = $ecefaxsmtpdata -> email_id;
		$password = $ecefaxsmtpdata -> password;
		
	    $backup = Mail::getSwiftMailer();
	    $transport = (new \Swift_SmtpTransport($host,$port,$ssl))
	  				->setUsername($username)
	  				->setPassword($password);
					
		// Create the Mailer using your created Transport
		$mailer = new Swift_Mailer($transport);
		$mailer->getTransport()->setStreamOptions(
            [
                "ssl" => [
                    "allow_self_signed" => true,
                    "verify_peer"       => false,
                    "verify_peer_name"  => false,
                ],
            ]
        );

		// Create a message
		$message = (new \Swift_Message($emailData['subject']))
		  ->setFrom([ $username => $name])
		  ->setTo([$emailData['toEmail'] => ''])
		  ->setBody($emailData['content']);
		 if($emailData['attachments']) {
			foreach($emailData['attachments'] as $file)  {
				$message->attach(Swift_Attachment::newInstance($file['file'], $file['name'],$file['type']));
			}
		}
	
		if ($result = $mailer->send($message)){
			$responseData = ['status' => 'sent'];
		  return $this->sendResponse($responseData, 200, 'sent successfully');
		}else{
				$responseData = [];
		    return $this->sendResponse($responseData, 400, 'Failed'); 
		}	

		//return $result = $mailer->send($message);
		 //printf("Sent %d messages\n", $result);

   }	

	public function exportToExcel($filename, $sheetname, $data){
		return Excel::create($filename, function($excel) use($data, $sheetname) {
			$excel->sheet($sheetname, function($sheet) use($data) {
		
				$sheet->fromArray($data);
		
			});
		
		})->export('xlsx');

	}
	
	//Javid khan modified code 
	function callEvcAPI($method,$url,$data){
	   $ecclinicsetup = new Ecclinicsetup();
	   $ecclinicsetupdetails = $ecclinicsetup::orderby('id','ASC')->get()->first();
       $clinicurl = $ecclinicsetupdetails['url'];
       $url = $clinicurl."".$url; 
	  
	    if($this -> validatePatientPortalUrl($url)) {
			return $this->callAPI($method, $url, $data);
		}else {
			return json_encode(array('Mismatch with clinic key in patient portal url. Please check.'));
		}

	}
	//Call External APIS 
	public function callAPI($method, $url, $data, $headers=NULL){
	   $curl = curl_init();
	   switch ($method){
		  case "POST":
			 curl_setopt($curl, CURLOPT_POST, 1);
			 if ($data)
				curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
			 break;
		  case "PUT":
			 curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
			 if ($data)
				curl_setopt($curl, CURLOPT_POSTFIELDS, $data);			 					
			 break;
		  case "GET":
			 curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");
			 if ($data)
				curl_setopt($curl, CURLOPT_POSTFIELDS, $data);			 					
			 break; 
			 
		  default:
			 if ($data)
				$url = sprintf("%s?%s", $url, http_build_query($data));
	   }
	
	   // OPTIONS:
	   curl_setopt($curl, CURLOPT_URL, $url);
	   
	   if($headers) {
		   curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
	   }else {
		   curl_setopt($curl, CURLOPT_HTTPHEADER, array(
			  'Content-Type: application/json',
			  'Accept: application/json'
		   ));
	   }
	   
	   curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	   curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	
	   // EXECUTE:
	   $result = curl_exec($curl);
	   $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
	   $this -> status_code =  $httpcode;
	   if(!$result){die("Connection Failure");}
	   curl_close($curl);
	   return $result;
	}
	
	//Patient portal 
	function getPatAppUrl($url) {
		$clinicSetupData = DB::table('ecclinicsetup')->first();
		$clinicSetupData -> patient_portal = str_replace("http://", "", $clinicSetupData -> url);
		$clinicSetupData -> patient_portal = str_replace("https://", "", $clinicSetupData -> url);
		$clinicSetupData -> patient_portal = str_replace("/", "", $clinicSetupData -> url);
		$url = "http://".$clinicSetupData -> patient_portal. "/". $url;
		return $url;
	}
	//validate Patinet portal function 
	public function validatePatientPortalUrl($patientPortalUrl) {
		$hostName = $_SERVER['HTTP_HOST'];
		$hostName = str_replace("http://", "", $hostName);
		$hostName = str_replace("https://", "", $hostName);
		$hostArr = explode(".", $hostName);

		$patientPortalUrl = str_replace("http://", "", $patientPortalUrl);
		$patientPortalUrl = str_replace("https://", "", $patientPortalUrl);
		$ppHostArr = explode(".", $patientPortalUrl);

		if(count((array)$hostArr) > 0 && count((array)$ppHostArr) > 0 ) {
			if($hostArr[0] == $ppHostArr[0] && ($ppHostArr[1] == "api" || $ppHostArr[1] == "local")) {
				return true;
			}
		}
		return false;
	}



}