<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Helper;
use DateTime;
use DB;
use App\Http\Classes\DateUtil;
use App\Models\Ecpatmaster;
use App\Models\Ecofficelocation;
use App\Models\Ecuserotp;
use App\Models\Ecdoctoronlineaval;
use App\Models\Eccodes;
use App\Models\Ecregnumq;
use App\Models\Messagesetup;
use App\Models\Ecpatoccupation;
use App\Models\Ecpatcity;
use App\Models\Ecpatprovince;
use App\Models\Ecreferral;
use App\Models\Ecuser;
use App\Models\Ecpatquestionaire1;
use App\Models\Ecpatquestionaire2;
use App\Models\Ecpatquestionaire3;
use App\Models\Ecpatquestionaire4;
use App\Models\Ecpatquestionaire5;
use App\Models\PatientPortalNotification;
use App\Http\Classes\EmailAlerts;
use App\Http\Constants\UserLogConstants;
use App\Http\Classes\UserLog;
use App\Http\Requests\PatientRequest;
use App\Http\Requests\OtpRequest;
use Carbon\Carbon;
use stdClass;
use File;
use Response;
use Twilio\Rest\Client;
use Illuminate\Pagination\Paginator;
use App\Http\Controllers\FirebaseController;
use App\Http\Models\JSONResponse;
class AppointmentController extends FirebaseController {

	//Get Patient doctors 
	public function getPxDoctor(Request $request) {
	 $resultAPI = $this -> callEvcAPI("GET", "ws/patientportal/doctors/{$request->location_id}", 
                      json_encode(array("clinicKey" => "clinic1")));
     return $resultAPI;
            
    } 
	
	//Get Appointment Codes
	public function getAppoinmentCodes(Request $request) {
	 $dob = $request->session()->get('user')['DOB'];
	 $resultAPI = $this -> callEvcAPI("POST", "ws/patientportal/appoinment/codes?doctorId={$request->doctorId}&patId={$request->patId}&dob={$dob}&location_id={$request->location_id}", json_encode(array("clinicKey" => "clinic1")));
     return $resultAPI;
		
    }
	//Booking Availabily Checking 
	 public function getBookAvailable(Request $request) {
	 	$pending_appointments = [];
		/*
	 	$ecpatappointment = new Ecregnumq();
		$pending_appointments = $ecpatappointment -> whereRaw("DATEDIFF(NOW(), CREATED_DATE) <= 7")->select(DB::raw("DATE_FORMAT(STARTDATE, '%Y-%m-%d') AS DATE"), "STARTDATE", "ENDDATE")->where('LOCATION_ID', $request->location_id)->where('DOC_ID', $request->doc_id)->where('ONLINE_APP_STATUS', '0')->orderBy('STARTDATE')->get();
		if($pending_appointments) {
			$pending_appointments = $pending_appointments -> toArray();
		}*/
		$resultAPI = $this -> callEvcAPI("POST", "ws/patientportal/bookavailable", json_encode( array("location_id" => $request->location_id,"codeno" => $request->codeno,"code" => $request->code,"doc_id" => $request->doc_id,"startDate"=>$request->startDate,"endDate"=>$request->endDate, "pending_appointments" => $pending_appointments)));
		 return $resultAPI;
    }
	
	//Get Book appointment 
	public function getBookAppointment(Request $request) {
	    $now = Carbon::now();
        $ecpatappointment = new Ecregnumq(); 
        $ecpatappointment = $ecpatappointment::orderby('startdate', 'ASC') 
        ->where('startdate' , '>=', $now)->get();
        return $this->sendResponse($ecpatappointment); 
    } 
	
   //Book an appointment 
   public function bookAppointment(Request $request, $clinicKey) {
   		$userInfo = PatientController::updateLocationId($request);
		
        $pat_id = $request->session()->get('user')['PAT_ID'];
        $first_name = $request->first_name;
        $last_name = $request->last_name;
        $appdesc = $request->appdesc;
        $doc_id = $request->doc_id;
        $startdate = $request->startdate;
        $enddate = $request->enddate;
        $starttime = $request->starttime;
        $endtime = $request->endtime;
		$patient_type=$userInfo['PATIENT_TYPE'];
		$gender=$userInfo['GENDER'];
		$contact_num=$userInfo['CONTACT_NUM'];
		$dob=$userInfo['DOB'];
		$evc_pat_id=$userInfo['EVC_PAT_ID'];
        $appointmentcode = $request->appointmentcode;
        $notes = $request->notes;
		$location_id = $request->location_id;
		$created_date = date("Y-m-d H:i:s");
		if($pat_id && !$evc_pat_id) {
			$t = Ecpatmaster::where('PAT_ID', $pat_id)->first();
			if($t) {
				$evc_pat_id = $t -> EVC_PAT_ID;
			}
		}
		//Availability checking 
		if($evc_pat_id =="0"){
			$ecregnumq = new Ecregnumq();
			$ecregnumq_count = $ecregnumq->where([['PAT_ID' , '=', $pat_id],['ONLINE_APP_STATUS' , '=', 0]])->count();
		}else{
			$ecregnumq = new Ecregnumq();
			$ecregnumq_count = $ecregnumq->where([['EVC_PAT_ID' , '=', $evc_pat_id],['ONLINE_APP_STATUS' , '=', 0]])->count();
		}
		
		if($ecregnumq_count > 0) {
		    $responseData = [];
		    $message= "Appointment information Already Exists.Contact Clinic";
		    return $this->sendResponse($ecregnumq , 400, $message, $message);
		}
		
		
        $ecregnumq = new Ecregnumq();
		
        $ecregnumq->pat_id = $pat_id;
        $ecregnumq->first_name = $first_name;
        $ecregnumq->last_name = $last_name;
        $ecregnumq->appdesc = $appdesc;
        $ecregnumq->doc_id = $doc_id;
        $ecregnumq->startdate = $startdate;
        $ecregnumq->enddate = $enddate;
        $ecregnumq->starttime = $starttime;
        $ecregnumq->endtime = $endtime;
        $ecregnumq->code_id = $appointmentcode;
        $ecregnumq->notes = $notes;
		$ecregnumq->patient_type = $patient_type;
		$ecregnumq->gender= $gender;
		$ecregnumq->contact_num= $contact_num;
		$ecregnumq->dob= $dob;
		$ecregnumq->EVC_PAT_ID= $evc_pat_id;
		$ecregnumq->created_date= $created_date;
		$ecregnumq->location_id = $location_id;
		$ecregnumq->save();
		//Notification section added - calendar Appointment 
		
		$reqArr = array("location_id" => $location_id, "created_date" => $ecregnumq->created_date,"first_name" => $ecregnumq->first_name,"last_name" => $ecregnumq->last_name,"gender" => $ecregnumq->gender,"dob" => $ecregnumq->dob,"pat_id" => $pat_id ,"evc_pat_id" =>$evc_pat_id,"ecrq_id" => $ecregnumq->ECRQ_ID,"evc_ecrq_id" => $ecregnumq->EVC_ECRQ_ID,"app_status" =>"0" ,"app_updated_date" => $ecregnumq->EVC_UPDATED_DATE);
		
		if($evc_pat_id !="0"){
			$reqArr["px_status"] = "1";
		}
		
		PatientController::SaveNotifications($reqArr,"NewApp");
		
		PatientController::getPxAptStatus($request, $clinicKey, true, $location_id);
		
		$resultAPI = $this -> callEvcAPI("POST", "ws/patientportal/sendEmailNotifications",json_encode(array("location_id" => $location_id, "first_name" => $first_name ,"last_name" => $last_name ,"appdesc" => $appdesc,"startdate" => $startdate,"enddate" => $enddate ,"starttime" => $starttime,"endtime" => $endtime,"code_id" => $appointmentcode,"notes" => $notes ,"patient_type" => $patient_type,"gender" => $gender,"contact_num" => $contact_num,"dob" => $dob,"created_date" => $created_date)));
		
        return $this->sendResponse($ecregnumq, 200, 'Appointment Booked Successfully!');
		
    } 
 	 	
	 //Get Online Appointments	
     public function getOnlineAppointments($clinickey,$id){
        $ecregnumq= new Ecregnumq(); 
        $appData = $ecregnumq::orderby('startdate', 'ASC')->where('PAT_ID',$id)->select('ecrq_id','pat_id')->get();
        $patient_data = [];  
        foreach($appData as $patient_data) {
        	$patient_data->pat_id =   $app_data->pat_id;
            $patient_data->details =   $app_data->pat_id;
        }  
        return $this->sendResponse($appData); 
       }
     //Get Online Patient Appointment   
	 public function getOnlinePatientAppointment(){
        $ecregnumq= new Ecregnumq();
        $queryObj = $ecregnumq::orderby('ECRQ_ID', 'DESC')->where('online_app_status',0);
        $patientData = $queryObj->select('ecregnumq.first_name','ecregnumq.ECRQ_ID','ecregnumq.pat_id')->get();
	      foreach($patientData as $data){
	        $patientData ['patient_data'] = NULL;
		    $patientData ['patient_data']->patient_id= $data->pat_id;
	      }		
         return $this->sendResponse($patientData ); 
     }
	
	//Get Online New Appointments by id
	public function getOnlinenewAppointmentsbyid($clinickey,$id) {
		$ecregnumq= new Ecregnumq();
		$responseData = $ecregnumq ::orderBy('ECRQ_ID', 'ASC')->where('ECRQ_ID',$id)->first();
		return $this->sendResponse($responseData);
	} 
	
   //update Appointment status 
   public function updateAptStatus(Request $request, $clinicKey) {
        $ecrq_id= $request->ecrq_id;
        $evc_ecrq_id= $request->evc_ecrq_id;
        $status= $request->status;
        $notes= $request->notes;
		$evc_updated_date= $request->evc_updated_date;
		$evc_updated_by= $request->evc_updated_by;
		$notification_id = $request->notification_id;

		$ecregnumq= new Ecregnumq();
        
		if($ecrq_id!== null) {
            $ecregnumq= $ecregnumq::find($ecrq_id);
            if($ecregnumq== null) {
                $errors = array('Id: ' . $id . ' not exist');
                return $this->sendResponse([], 400, 'Failed', $errors);
            }
        }
		
        $ecregnumq->ecrq_id= $ecrq_id;
		if($evc_ecrq_id)
        $ecregnumq->evc_ecrq_id= $evc_ecrq_id;
        $ecregnumq->online_app_status= $status;
        $ecregnumq->notes = $notes;
		$ecregnumq->evc_updated_date = $evc_updated_date;
		$ecregnumq->evc_updated_by = $evc_updated_by;
	    $ecregnumq->save();
	    //Notification section - Appoitnment status Update
		$reqArr = array("notification_id" =>  $notification_id, "location_id" =>  $ecregnumq->location_id,"pat_id" => $ecregnumq->PAT_ID, "evc_pat_id" => $ecregnumq->EVC_PAT_ID , "ecrq_id" => $ecregnumq->ecrq_id,"evc_ecrq_id" => $ecregnumq->evc_ecrq_id,"app_status" =>$ecregnumq->online_app_status ,"app_updated_date" => $ecregnumq->evc_updated_date,"app_updated_by" => $ecregnumq->evc_updated_by );
		PatientController::SaveNotifications($reqArr,"UpdateApp");
		PatientController::getPxAptStatus($request, $clinicKey, true, $ecregnumq->location_id);
        return $this->sendResponse($ecregnumq); 
    } 
	
    //Appointment confirmation Link 
	public function getconfirm_appointment_by_link(Request $request,$clinicKey,$p){
  		$p = base64_decode($p);
		$response = $this -> callEvcAPI("POST", "ws/app_rem_link/confirmAppByLink",  $p);
		$resultAPI = json_decode($response , true);
        $officeName= $resultAPI['officeName'];
        $message= $resultAPI['message'];
        return view('apptconfirmation', ['officeName' => $officeName,'message' => $message,]);
    }
	//Get active appointments
	public function getactiveappointment(Request $request) {
		$pat_id     = $request->pat_id;
		$evc_pat_id = $request->evc_pat_id;
	    $ecregnumq= new Ecregnumq();
		if($evc_pat_id =="") {	
       	   $ecregnumq = $ecregnumq::orderby('ECRQ_ID', 'DESC') ->where('PAT_ID' , '=', $pat_id)->where('ONLINE_APP_STATUS' , '=', 0)->first();
		}else{
		  $ecregnumq = $ecregnumq::orderby('ECRQ_ID', 'DESC') ->where('EVC_PAT_ID' , '=', $evc_pat_id)->where('ONLINE_APP_STATUS' , '=', 0)->first();	
		}
        return $this->sendResponse($ecregnumq); 
    } 
	
	
	
}