<?php 
namespace App\Http\Clients;

use GuzzleHttp\Client;
use App\Http\Clients\HttpConstants;

class HttpClient {
	private $httpClient;
	private $apiBaseUrl;
	
	public function  __construct() {
		$this->httpClient = new Client();
		$this->apiBaseUrl = HttpConstants::$API_BASE_URL;
	}
	
	public function post($url, $data) {
		return $this->httpClient->post($this->buildApiUrl($url), $data);
	}
	
	public function postJSON($url, $data) {
		return $this->httpClient->post($this->buildApiUrl($url), ['json' => $data]);
	}
	
	private function buildApiUrl($url) {
		return $this->apiBaseUrl . $url;
	}
}