<?php 
namespace App\Http\Clients;

use App\Http\Models\JSONResponse;
use Validator;

class ErrorHandler {
	
	private $_validator;	
	public function  __construct($inputs, $validation_rules) {
		$this->_validator = Validator::make($inputs, $validation_rules);		
	}
	
	public function getValidationErrors() {
		if ($this->hasValidationError()) {
			return $this->_validator->errors();            
        }		
		return [];
	}
	
	public function hasValidationError() {
		if ($this->_validator->fails()) {
			return true;
		}
		
		return false;
	}
}