<?php 
namespace App\Http\Clients;
require_once('../vendor/econea/nusoap/src/nusoap.php');
use nusoap_client;
class DeviceClient {
	
	private $wsdl="http://www.evcconfig3.com/webservicetest/DeviceService.php?wsdl";
	private $client;
	
	public function  __construct() {
		$this->client = new nusoap_client($this -> wsdl, true);
	}
	
	public function call($serviceName, $params)
	{

		$err = $this->client->getError();
		if ($err) {
			return 'Constructor error:' . $err .'\n'.htmlspecialchars($client->getDebug(), ENT_QUOTES);
		}
		$result = $this->client->call($serviceName, $params);
		if ($this->client->fault) {
			return 'Fault (Expect - The request contains an invalid SOAP body) \n'.$result;
		} else {
			$err = $this->client->getError();
			if ($err) {
				return 'Error:'. $err;
			} else {
				return $result;
			}
		}		
	}

}