<?php
namespace App\Http\Classes;
use Illuminate\Http\Request;
use App\Http\Controllers\CommonController;
use App\Http\Models\JSONResponse;
use App\Http\Clients\ErrorHandler;
$twilioDir = '../vendor/twilio/sdk/Services/Twilio.php';
require_once($twilioDir);
require '../vendor/autoload.php';
use Twilio\Rest\Client;
use Carbon\Carbon;
use DB;

class TwillioApi {

	public static function AutoCall($to_number,$path){
	
		$to_number = preg_replace("/[^0-9+]/", "", $to_number);
		if(strlen($to_number) == 10) {
			$to_number = "+1".$to_number;
		}
		try{
			$client = new Client($_ENV['TWILIO_ACCOUNT_SID'], $_ENV['TWILIO_AUTH_TOKEN']);
			//$twilio_number = $_ENV['TWILIO_CALLNUMBER'];
			
			$twapi = new TwillioApi();
			$sms_data = 	$twapi->getSms();
    		$twilio_number = "+1".$sms_data['caller_id'];
			
			$resCall = 	 $client->account->calls->create(  
				$to_number,
				$twilio_number,
				array(
					"url" => $path,
					'Method' => 'POST',  
					'FallbackMethod' => 'GET',  
					'StatusCallbackMethod' => 'GET',  
					'machineDetection'=> 'Enable', 
					'IfMachine' => 'Continue',  
					'Record' => 'false'
					)
			);
			return $resCall->status;
		}catch(\Exception $error){
			return ['error'=>$error->getMessage()];
		}
	}
	
	public static function Sms($to_number,$message){
		$to_number = preg_replace("/[^0-9+]/", "", $to_number);
		if(strlen($to_number) == 10) {
			$to_number = "+1".$to_number;
		}
		try{
			$client = new Client($_ENV['TWILIO_ACCOUNT_SID'], $_ENV['TWILIO_AUTH_TOKEN']);
			//$twilio_number = $_ENV['TWILLIO_SMSNUMBER'];
			
			  	$twapi = new TwillioApi();
			    $sms_data = 	$twapi->getSms();
				$sms_number = "+1".$sms_data['sms_number'];
				$res = 	$client->messages->create(
									$to_number,
								array(
									'from' => $sms_number,
									'body' =>  $message
								)
			);
			return $res->status;
		}catch(\Exception $error){
			return ['error'=>$error->getMessage()];
		}
	}
	
	public function getSms() {
		$clinicSetupData = DB::table('ecofficelocation')->first();
		$smsData['sms_number'] = $clinicSetupData -> sms_number;
		$smsData['caller_id'] = $clinicSetupData -> caller_id;
		return $smsData;
	}
	
	

}

?>