<?php
namespace App\Http\Classes;
use App\Models\Ecpatientbilling;
use App\Models\Ecpatcasemaster;
use App\Models\Ecmulticodemapping;
use App\Models\Eccodes;
use Carbon\Carbon;
use DB;
use App\Http\Classes\DateUtil;

class PatientBilling
{


	public function addDefaultBilling($caseId){
		$ecpatcasemaster = new Ecpatcasemaster();
		$patCodeData = $ecpatcasemaster
		->leftJoin('ecregnumq', 'ecregnumq.ECRQ_ID', '=', 'ecpatcasemaster.ECRQ_ID')
		->leftJoin('ecpatmaster', 'ecpatmaster.PAT_ID', '=', 'ecpatcasemaster.PAT_ID')
		->leftJoin('eccodes','eccodes.codeno', '=', 'ecregnumq.CODE_ID')
		->where('ecpatcasemaster.CASE_ID', '=',$caseId)
		->select('ecregnumq.ECRQ_ID','ecregnumq.PAT_ID','ecregnumq.REF_DOC_ID','eccodes.codeno','eccodes.codeType','eccodes.description','eccodes.Cost','eccodes.BillingCodes'
		,'ecregnumq.DOC_ID','ecregnumq.ADDITIONAL_CODES','ecpatmaster.FIRST_NAME','ecpatmaster.LAST_NAME', 'ecpatcasemaster.CASE_ID')
		->first();
		if($patCodeData -> codeno != "" && $patCodeData -> codeType == "Single"){
			$this -> addToBillings($patCodeData, array($patCodeData));
		}else if($patCodeData -> codeno != "" && $patCodeData -> codeType == "Multi"){
			$multicodemappings = new Ecmulticodemapping();
			$code_ids_to_add = $multicodemappings -> select('multicodeid as codeno') -> where('codeno', $patCodeData -> codeno) -> get();
			$ids_to_add = array_map(function($item){ return $item['codeno']; }, $code_ids_to_add->toArray());
			
			$codes = new Eccodes();
			$codes = $codes -> whereIn('eccodes.codeno', $ids_to_add)
						->select('eccodes.codeno','eccodes.codeType','eccodes.description','eccodes.Cost','eccodes.BillingCodes')
						->get();
			$this -> addToBillings($patCodeData, $codes);
		}
		
		if($patCodeData -> ADDITIONAL_CODES) {
			$codes = new Eccodes();
			$codes = $codes -> whereIn('eccodes.codeno', explode(",", $patCodeData -> ADDITIONAL_CODES))
						->select('eccodes.codeno','eccodes.codeType','eccodes.description','eccodes.Cost','eccodes.BillingCodes')
						->get();
			$this -> addToBillings($patCodeData, $codes);
		}
	}
	
	function addToBillings($patCodeData, $codes = array()) {
		foreach($codes as $code) {
			$today = Carbon::now();
			$ecpatbill = new Ecpatientbilling();
			$ecpatbill->case_id = $patCodeData -> CASE_ID;
			$ecpatbill->pat_id = $patCodeData -> PAT_ID;
			$ecpatbill->ecrq_id = $patCodeData -> ECRQ_ID;
			$ecpatbill->dtcreated = $today->toDateTimeString();
			/* Fields from code table */
			$ecpatbill->codeno = $code -> codeno;
			$ecpatbill->code_description = $code -> description;
			$ecpatbill->amount = $code -> Cost;
			$ecpatbill->billing_code = $code -> BillingCodes;
			/* ---------------------- */
			$ecpatbill->billing_date = $today->toDateTimeString();
			$ecpatbill->type = 'AUTO';
			$ecpatbill->docId = $patCodeData -> DOC_ID;
			$ecpatbill->ref_doc_id = $patCodeData -> REF_DOC_ID;
			$ecpatbill->pat_firstname = $patCodeData -> FIRST_NAME;
			$ecpatbill->pat_lastname = $patCodeData -> LAST_NAME;
			$ecpatbill->save();
		}
	}
	
	public function getPatientBillingByCaseId($caseId){
		$ecpatbill = new Ecpatientbilling();
		$responseData = $ecpatbill
		->leftJoin('eccodes', 'eccodes.codeno', '=', 'ecpatientbilling.codeno')
		->leftJoin('ecusers', 'ecusers.USERID', '=', 'ecpatientbilling.docId')
		->where('ecpatientbilling.case_id', '=',$caseId)
		->orderBy('ecpatientbilling.id', 'desc')
		->select('ecpatientbilling.*','eccodes.code','ecusers.FIRST_NAME','ecusers.LAST_NAME', 'ecusers.USER_TYPE')
		->get();
		return $responseData;
	}

	public function getPatientBillingByPatId($patId){
		$ecpatbill = new Ecpatientbilling();
		$responseData = $ecpatbill
		->leftJoin('eccodes', 'eccodes.codeno', '=', 'ecpatientbilling.codeno')
		->leftJoin('ecusers', 'ecusers.USERID', '=', 'ecpatientbilling.docId')
		->where('ecpatientbilling.pat_id', '=',$patId)
		->whereIn('ecpatientbilling.ohip_status',['Q','W','FP','PP','R','RP','RQ','D','WP'])
		->orderBy('ecpatientbilling.id', 'desc')
		->select('ecpatientbilling.*','eccodes.code','ecusers.FIRST_NAME','ecusers.LAST_NAME')
		->get();
		return $responseData;
	}


}
?>