<?php
namespace App\Http\Classes;
use Illuminate\Http\Request;
use App\Http\Controllers\CommonController;
use App\Models\Ecofficelocation;
use App\Models\Ecemailtemplate;
use App\Models\Eccalendararappointment;
use App\Models\Ecpatmaster;
use App\Models\Ecpatinvoice;
use App\Models\Ecpatcasemaster;


use Carbon\Carbon;
use DB;

class EmailAlerts extends CommonController
{
	//adjust frame inventory count
	public function sendAdjustFrameInventoryEmail($barCode,$miscInventoryAdjustHistory,$userInfo){
	
	    $inventoryData = DB::table('ecframeinventory')->leftJoin('ecframesupply', 'ecframesupply.framesupplyid', 'ecframeinventory.manufactureid')->leftJoin('ecframeline', 'ecframeline.id', 'ecframeinventory.frameline')
		 ->select('ecframeinventory.*','ecframesupply.manufacturename','ecframeline.frameline') 		
		 ->where('inventoryid', $barCode)->first();
		 
		$manufacture = $inventoryData->manufacturename;
		$frameline		= $inventoryData->frameline;
		$modelno		= $inventoryData->modelno;
		 
        $updated_by = $userInfo['FIRST_NAME']." ".$userInfo['LAST_NAME'] ;
        $ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
        

  	    $userData = DB::table('ecusers')->where([['user_type', 'A'],['allow_email','1'],['status','A']] )->get();
		foreach($userData as $datas){
	        
	        $toEmail = $datas->EMAIL;
		    $toEmail = explode(',', $toEmail);
	      	//$toEmail = "javithkhan@gmail.com";
			
			$printedtxt = "<p>FrameLine :  {$frameline}</p><p> modelno :  {$modelno}</p>";
			
			$emailData = [
							'templatePath' => 'emails.inventory-count-alert',
							'barcode'	=>  $miscInventoryAdjustHistory->barcode,
							'actual_count'	=> $miscInventoryAdjustHistory->actual_count,
							'modified_count'	=> $miscInventoryAdjustHistory->modified_count,
							'note'	=> $miscInventoryAdjustHistory->note,
							'manufacture'	=> $manufacture,
							'printedtxt' => $printedtxt,
							'type' => 'Frame',
							'updated_by'	=> $updated_by,
							'updated_date'	=>  $miscInventoryAdjustHistory->adjust_date,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'toEmail' => $toEmail,
							'subject' => 'Adjust Frame Inventory:Alert'
	        ];

	
		
			$this->sendEmail($emailData);
			
		}	

	}
	
	//Send Adjust frame inventory price
	public function sendAdjustFramePriceEmail($barCode,$miscPriceAdjustHistory,$userInfo){
	
		 $inventoryData = DB::table('ecframeinventory')->leftJoin('ecframesupply', 'ecframesupply.framesupplyid', 'ecframeinventory.manufactureid')->leftJoin('ecframeline', 'ecframeline.id', 'ecframeinventory.frameline')
		 ->select('ecframeinventory.*','ecframesupply.manufacturename','ecframeline.frameline') 		
		 ->where('inventoryid', $barCode)->first();
		 
		$manufacture = $inventoryData->manufacturename;
		$frameline		= $inventoryData->frameline;
		$modelno		= $inventoryData->modelno;
		$color			= $inventoryData->color;
		 
        $updated_by = $userInfo['FIRST_NAME']." ".$userInfo['LAST_NAME'] ;
        $ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
        
		$printedtxt = "<p>FrameLine :  {$frameline}</p><p> modelno :  {$modelno}</p><p>Color #: {$color}</P>";
			

  	    $userData = DB::table('ecusers')->where([['user_type', 'A'],['allow_email','1'],['status','A']] )->get();
		foreach($userData as $datas){
	        
	       $toEmail = $datas->EMAIL;
		    $toEmail = explode(',', $toEmail);
	        //$toEmail = "javithkhan@gmail.com";
	       	$emailData = [
							'templatePath' => 'emails.inventory-price-alert',
							'barcode'	=>  $miscPriceAdjustHistory->barcode,
							'old_retail_price'	=> $miscPriceAdjustHistory->rtpricefrom,
							'new_retail_price'	=> $miscPriceAdjustHistory->rtpriceto,
							'printedtxt'	=> $printedtxt ,
							'manufacture'	=> $manufacture,
							'printedtxt'	=> $printedtxt,
							'type'			=> 'Frame',
							'note'			=> $miscPriceAdjustHistory->note,
							'updated_by'	=> $updated_by,
							'updated_date'	=> $miscPriceAdjustHistory->adjustdate,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'toEmail' => $toEmail,
							'subject' => 'Adjust Frame Price:Alert'
	        ];

	
		
			$this->sendEmail($emailData);
			
		}	
	}
	
	//adjust contact lens inventory count
	public function sendAdjustContactLensInventoryCountEmail($barCode,$miscInventoryAdjustHistory,$userInfo){
	
	    $inventoryData = DB::table('eccontactlensinventory')
		 ->select('eccontactlensinventory.*') 		
		 ->where('inventoryid', $barCode)->first();
		 
		$manufacture = $inventoryData->manufacture;
		$lens		= $inventoryData->lens;
		 
        $updated_by = $userInfo['FIRST_NAME']." ".$userInfo['LAST_NAME'] ;
        $ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
        

  	    $userData = DB::table('ecusers')->where([['user_type', 'A'],['allow_email','1'],['status','A']] )->get();
		foreach($userData as $datas){
	        
	        $toEmail = $datas->EMAIL;
		    $toEmail = explode(',', $toEmail);
	        //$toEmail = "javithkhan@gmail.com";
			
			$printedtxt = "<p>Lens Design :  {$lens}</p>";
			
	       	$emailData = [
							'templatePath' => 'emails.inventory-count-alert',
							'barcode'	=>  $miscInventoryAdjustHistory->barcode,
							'actual_count'	=> $miscInventoryAdjustHistory->actual_count,
							'modified_count'	=> $miscInventoryAdjustHistory->modified_count,
							'note'	=> $miscInventoryAdjustHistory->note,
							'manufacture'	=> $manufacture,
							'printedtxt' => $printedtxt,
							'type' => 'ContactLens',
							'updated_by'	=> $updated_by,
							'updated_date'	=>  $miscInventoryAdjustHistory->adjust_date,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'toEmail' => $toEmail,
							'subject' => 'Adjust ContactLens Inventory:Alert'
	        ];

	
		
			$this->sendEmail($emailData);
			
		}	

	}
	
	//Send Adjust Contact lens inventory price
	public function sendAdjustContactLensPriceEmail($barCode,$miscPriceAdjustHistory,$userInfo){
	
	    $inventoryData = DB::table('eccontactlensinventory')
		 ->select('eccontactlensinventory.*') 		
		 ->where('inventoryid', $barCode)->first();
		 
		$manufacture = $inventoryData->manufacture;
		$lens		= $inventoryData->lens;
	
	 
		 
        $updated_by = $userInfo['FIRST_NAME']." ".$userInfo['LAST_NAME'] ;
        $ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
        
		$printedtxt = "<p>Lens Design :  {$lens}</p>";
		
  	    $userData = DB::table('ecusers')->where([['user_type', 'A'],['allow_email','1'],['status','A']] )->get();
		foreach($userData as $datas){
	        
	        $toEmail = $datas->EMAIL;
		    $toEmail = explode(',', $toEmail);
	        //$toEmail = "javithkhan@gmail.com";
	       	$emailData = [
							'templatePath' => 'emails.inventory-price-alert',
							'barcode'	=>  $miscPriceAdjustHistory->barcode,
							'old_retail_price'	=> $miscPriceAdjustHistory->rtpricefrom,
							'new_retail_price'	=> $miscPriceAdjustHistory->rtpriceto,
							'manufacture'	=> $manufacture,
							'printedtxt'	=> $printedtxt,
							'updated_by'	=> $updated_by,
							'updated_date'	=>  $miscPriceAdjustHistory->adjustdate,
							'note'			=> $miscPriceAdjustHistory->note,
							'type'			=> 'ContactLens',
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'toEmail' => $toEmail,
							'subject' => 'Adjust ContactLens Price:Alert'
	        ];
		
			$this->sendEmail($emailData);
			
		}	
	}
	
	//adjust Misc inventory count
	public function sendAdjustMiscInventoryEmail($barCode,$miscInventoryAdjustHistory,$userInfo){
	
	    $inventoryData = DB::table('ecmiscsininventory')
			->leftJoin('ecmiscsupply', 'ecmiscsupply.miscsupplyid', '=', 'ecmiscsininventory.manufacture')
			->leftJoin('ecmisccategory', 'ecmisccategory.id', '=', 'ecmiscsininventory.category')
			->leftJoin('ecmiscitems', 'ecmiscitems.id', '=', 'ecmiscsininventory.item')
			->select('ecmiscsininventory.*','ecmiscsupply.manufacturename','ecmisccategory.category','ecmiscitems.item') 		
		 	->where('ecmiscsininventory.id', $barCode)->first();
		 
		$manufacture 	= $inventoryData->manufacturename;
		$category		= $inventoryData->category;
		$item			= $inventoryData->item;
		 
        $updated_by = $userInfo['FIRST_NAME']." ".$userInfo['LAST_NAME'] ;
        $ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
        

  	    $userData = DB::table('ecusers')->where([['user_type', 'A'],['allow_email','1'],['status','A']] )->get();
		foreach($userData as $datas){
	        
	        $toEmail = $datas->EMAIL;
		    $toEmail = explode(',', $toEmail);
	      
	      	//$toEmail = "javithkhan@gmail.com";
			
			$printedtxt = "<p>Category :  {$category}</p><p> Item :  {$item}</p>";
			
			$emailData = [
							'templatePath' => 'emails.inventory-count-alert',
							'barcode'	=>  $miscInventoryAdjustHistory->barcode,
							'actual_count'	=> $miscInventoryAdjustHistory->actual_count,
							'modified_count'	=> $miscInventoryAdjustHistory->modified_count,
							'note'	=> $miscInventoryAdjustHistory->note,
							'manufacture'	=> $manufacture,
							'printedtxt' => $printedtxt,
							'type' => 'Misc',
							'updated_by'	=> $updated_by,
							'updated_date'	=>  $miscInventoryAdjustHistory->adjust_date,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'toEmail' => $toEmail,
							'subject' => 'Adjust Misc Inventory:Alert'
	        ];

	
		
			$this->sendEmail($emailData);
			
		}	

	}
	
	//Send Adjust Misc inventory price
	public function sendAdjustMiscPriceEmail($barCode,$miscPriceAdjustHistory,$userInfo){
	
		  $inventoryData = DB::table('ecmiscsininventory')
			->leftJoin('ecmiscsupply', 'ecmiscsupply.miscsupplyid', '=', 'ecmiscsininventory.manufacture')
			->leftJoin('ecmisccategory', 'ecmisccategory.id', '=', 'ecmiscsininventory.category')
			->leftJoin('ecmiscitems', 'ecmiscitems.id', '=', 'ecmiscsininventory.item')
			->select('ecmiscsininventory.*','ecmiscsupply.manufacturename','ecmisccategory.category','ecmiscitems.item') 		
		 	->where('ecmiscsininventory.id', $barCode)->first();
		 
		$manufacture 	= $inventoryData->manufacturename;
		$category		= $inventoryData->category;
		$item			= $inventoryData->item;
		 
		 
        $updated_by = $userInfo['FIRST_NAME']." ".$userInfo['LAST_NAME'] ;
        $ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
        
		$printedtxt = "<p>Category :  {$category}</p><p> Item :  {$item}</p>";
			

  	    $userData = DB::table('ecusers')->where([['user_type', 'A'],['allow_email','1'],['status','A']] )->get();
		foreach($userData as $datas){
	       //$toEmail = "javithkhan@gmail.com,smart4selva@gmail.com,karthickmce@gmail.com"; 
	       $toEmail = $datas->EMAIL;
		   $toEmail = explode(',', $toEmail);
	        $emailData = [
							'templatePath' => 'emails.inventory-price-alert',
							'barcode'	=>  $miscPriceAdjustHistory->barcode,
							'old_retail_price'	=> $miscPriceAdjustHistory->rtpricefrom,
							'new_retail_price'	=> $miscPriceAdjustHistory->rtpriceto,
							'printedtxt'	=> $printedtxt ,
							'manufacture'	=> $manufacture,
							'printedtxt'	=> $printedtxt,
							'type'			=> 'Misc',
							'note'			=> $miscPriceAdjustHistory->note,
							'updated_by'	=> $updated_by,
							'updated_date'	=> $miscPriceAdjustHistory->adjustdate,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'toEmail' => $toEmail,
							'subject' => 'Adjust Misc Price:Alert'
	        ];

	
		
			$this->sendEmail($emailData);
			
		}	
	}
	
	//send Invoice Discount Email notification to admin 
	public function sendInvoiceDiscountEmail($invoiceno,$request,$userInfo){
	
		 
        $updated_by = $userInfo['FIRST_NAME']." ".$userInfo['LAST_NAME'] ;
		$updated_date = date("Y-m-d H:i:s");
        $ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
        $pat_id 	= $request->pat_id;
		
		$patData = DB::table('ecpatmaster')->where('PAT_ID', $pat_id)->first();
		$patient_name = $patData->FIRST_NAME."".$patData->LAST_NAME;
		
		$userData = DB::table('ecusers')->where([['user_type', 'A'],['allow_email','1'],['status','A']] )->get();
		foreach($userData as $datas){
	        
	        $toEmail = $datas->EMAIL;
		    $toEmail = explode(',', $toEmail);
	      	//$toEmail = "javithkhan@gmail.com";
			
			
			$emailData = [
							'templatePath' => 'emails.invoice-discount-alert',
							'invoice'	=>  $invoiceno,
							'discount_amount'	=> $request->discount_total,
							'patient_name'	=> $patient_name,
							'note'	=> $request->note,
							'updated_by'	=> $updated_by,
							'updated_date'	=>  $updated_date,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'toEmail' => $toEmail,
							'subject' => 'Discount Price:Alert'
	        ];

	
		
			$this->sendEmail($emailData);
			
		}	

	}
	
	//send New Appointment Email to user
		
	 public function sendNewAppointmentEmail($ECRQ_ID,$emailTemplateName){
		
		
		$templateData = Ecemailtemplate::where([['template_name', $emailTemplateName],['status','1']])->first();
		$template	   = $templateData->template;
		$subject 	   = $templateData->subject; 	
		$template_path = $templateData->templatePath;
		$message2		= $templateData->message; 
		$bg_color 		= $templateData->bg_color; 
		$image 		    = $templateData->image; 
	    $google_calendar_val = $templateData->google_calendar;
		$patient_portal_val	= 	$templateData->patient_portal;
		$map_direction_val	= 	$templateData->map_direction;
		$email_header_color = $templateData->email_header_color;
		
		
		$ecofclocation = new Ecofficelocation();
		$clinicDetail  		   = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo            = $clinicDetail['logo'];
		$officeName            = $clinicDetail['officeName'];
		$address1	           = $clinicDetail['address1'];
		$city	       		   = $clinicDetail['city'];
		$state    			   = $clinicDetail['state'];
		$patient_portal_link   =  $clinicDetail['patient_portal'];
		$direction_link		   = $clinicDetail['direction_link'];	
	    
	
		//Fetching patient appointment details from ecrq_id
		
		 $APP_DATA 	= Eccalendararappointment::where('ECRQ_ID', $ECRQ_ID)->first();	
		 $pat_id 	= $APP_DATA['PAT_ID'];
		 $doc_id	= $APP_DATA['DOC_ID'];
		 $arrival	= $APP_DATA['Arrival'];
		 $startdate_val = $APP_DATA['STARTDATE'];
		 $enddate_val = $APP_DATA['ENDDATE'];
		 
		 
		 $date = date('M jS ', strtotime($startdate_val));
		 $time = date('g:i A ', strtotime($startdate_val));
		 
		 
		 $appStartDate =  Carbon::createFromFormat('Y-m-d H:i:s', $startdate_val);
		 $arrivalTime  = $appStartDate -> format('g:i A');
		 if($arrival != null && $arrival != "" && $arrival != "0m") {
			$appStartDate -> subMinutes($arrival);
			$arrival	 = $appStartDate -> format('g:i A');
		 }
							
							
    	 $startdate_time = $APP_DATA['STARTTIME'];
    	 $first_name    = $APP_DATA['FIRST_NAME'];
		 $last_name		= $APP_DATA['LAST_NAME'];
		
		 $dr_first_name =  DB::table('ecusers')->where('USERID',$doc_id)->value('FIRST_NAME');
		 $dr_last_name  =  DB::table('ecusers')->where('USERID',$doc_id)->value('LAST_NAME');
		 
		 $PAT_DATA 	= Ecpatmaster::where('PAT_ID', $pat_id)->first();	
		 	 
		 $title   	    =  $PAT_DATA['TITLE']; 
	     $dob   	    =  $PAT_DATA['DOB']; 
	     $dob           =  date('M jS y', strtotime($dob));
	     $email_id 	    =  $PAT_DATA['EMAIL_ID']; 
		

		//Replace Section for all values 	
    	 $message2 = str_replace('[APP_DATE]', $date , $message2);
    	 $message2 = str_replace('[APP_TIME]', $time , $message2);
		 $message2 = str_replace('[FIRST_NAME]', $first_name , $message2);
		 $message2 = str_replace('[LAST_NAME]', $last_name , $message2);
		 $message2 = str_replace('[DOB]', $dob , $message2);
		 $message2 = str_replace('[APP_ARRIVAL]', $arrival , $message2);
		 $message2 = str_replace('[DR_FIRST_NAME]', $dr_first_name , $message2);
		 $message2 = str_replace('[DR_LAST_NAME]', $dr_last_name , $message2);
		 $message2 = str_replace('[CLINIC_NAME]', $officeName , $message2);
		 $message2 = str_replace('[TITLE]', $title , $message2);
		 $message2 = str_replace('[PATIENT_NAME]', $first_name , $message2);
	     
    	 $email_tracker = "";
		 
		 
		 //Google calander Details 
		 
		 $google_calander_details = "Hi [FIRST_NAME] [LAST_NAME], Your eyeexam appointment on [APP_DATE]@[APP_TIME] with [DR_FIRST_NAME] [DR_LAST_NAME]";	
		 $google_calander_details = str_replace("[FIRST_NAME]", $first_name, $google_calander_details);
		 $google_calander_details = str_replace("[LAST_NAME]", $last_name, $google_calander_details);
		 $google_calander_details = str_replace("[APP_DATE]",$date, $google_calander_details);
		 $google_calander_details = str_replace("[APP_TIME]",$time, $google_calander_details);
		 $google_calander_details = str_replace("[DR_FIRST_NAME]", $dr_first_name,$google_calander_details);
		 $google_calander_details = str_replace("[DR_LAST_NAME]", $dr_last_name,$google_calander_details);
			
		$google_calendar = "https://calendar.google.com/calendar/render?action=TEMPLATE&text=Eye Exam@{$officeName}&dates=". date('Ymd\THis\Z', strtotime($startdate_val)) ."/". date('Ymd\THis\Z', strtotime($enddate_val))."&details=$google_calander_details&location={$officeName},{$address1},{$city},{$state}";
							
		
			$patient_portal_direction_google_cal_btn = '<div style="text-align:center;">';
							 if($google_calendar && $google_calendar_val == "1") {
								$patient_portal_direction_google_cal_btn .= '<a href="'.$google_calendar.'"><button type="button" style="max-width:200px;min-width:200px;height:50px;color:#00bfff;border:1px solid #00bfff;background-color:#ffffff;font-size:14px; margin: 8px;">Add to Calendar</button></a>';
							 }
							 if($patient_portal_link != "" && $patient_portal_val == "1") {
								$patient_portal_direction_google_cal_btn .= '<a href="'.$patient_portal_link.'"><button type="button" style="max-width:200px;min-width:200px;height:50px;color:#00bfff;border:1px solid #00bfff;background-color:#ffffff;font-size:14px; margin: 8px;">Patient Portal</button></a>';
							 }
							 if($direction_link != "" && $map_direction_val == "1") {
								$patient_portal_direction_google_cal_btn .= '<a href="'.$direction_link.'"><button type="button" style="max-width:200px;min-width:200px;height:50px;color:#00bfff;border:1px solid #00bfff;background-color:#ffffff;font-size:14px; margin: 8px;">Map Directions</button></a>';
							 }
						 $patient_portal_direction_google_cal_btn .= '</div>';
				
		 $message2 = str_replace('[PATIENT_PORTAL/DIRECTIONS/GOOGLE_CALENDAR]', $patient_portal_direction_google_cal_btn , $message2);
		 $message2 = str_replace('[CONFIRM_LINK]', '' , $message2);
	     $message2 = $message2;
    	 
		 							 
		 $unsubscribe_link      = $clinicDetail['patient_portal']."/unsubscribe.php?p=".base64_encode($pat_id);					
							
         
		 //$toEmail = "javithkhan@gmail.com";
		 $toEmail = explode(',', $email_id);
			
		$emailData = [
							'templatePath' => $template_path,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'message2' =>  $message2,
							'toEmail' => $toEmail,
							'bg_color' =>  $bg_color,
							'email_header_color' =>  $email_header_color,
							'image' =>  $image,
							'email_tracker' =>  $email_tracker,
							 'unsubscribe_link' =>$unsubscribe_link, 
							'subject' => $subject
	        ];
			$this->sendEmail($emailData);	
		}
		
		//send Update Appointment Email to user
		public function sendUpdateAppointmentEmail($ECRQ_ID,$emailTemplateName){
		
		$templateData   = Ecemailtemplate::where([['template_name', $emailTemplateName],['status','1']])->first();
		$template	    = $templateData->template;
		$subject 	    = $templateData->subject; 	
		$template_path  = $templateData->templatePath;
		$message2		= $templateData->message; 
		$bg_color 		= $templateData->bg_color; 
		$image 		    = $templateData->image; 
	    $google_calendar_val = $templateData->google_calendar;
		$patient_portal_val	= 	$templateData->patient_portal;
		$map_direction_val	= 	$templateData->map_direction;
		$email_header_color = $templateData->email_header_color;
		
		
		$ecofclocation = new Ecofficelocation();
		$clinicDetail  		   = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo            = $clinicDetail['logo'];
		$officeName            = $clinicDetail['officeName'];
		$address1	           = $clinicDetail['address1'];
		$city	       		   = $clinicDetail['city'];
		$state    			   = $clinicDetail['state'];
		$patient_portal_link   =  $clinicDetail['patient_portal'];
		$direction_link		   = $clinicDetail['direction_link'];	
			
		//Fetching patient appointment details from ecrq_id
		
		 $APP_DATA 	= Eccalendararappointment::where('ECRQ_ID', $ECRQ_ID)->first();	
		 $pat_id 	= $APP_DATA['PAT_ID'];
		 $doc_id	= $APP_DATA['DOC_ID'];
		 $arrival	= $APP_DATA['Arrival'];
		 $startdate_val = $APP_DATA['STARTDATE'];
		 $enddate_val = $APP_DATA['ENDDATE'];
		 
		 
		 $date = date('M jS ', strtotime($startdate_val));
		 $time = date('g:i A ', strtotime($startdate_val));
		 
		 $appStartDate =  Carbon::createFromFormat('Y-m-d H:i:s', $startdate_val);
		 $arrivalTime  = $appStartDate -> format('g:i A');
		 if($arrival != null && $arrival != "" && $arrival != "0m") {
			$appStartDate -> subMinutes($arrival);
			$arrival	 = $appStartDate -> format('g:i A');
		 }
							
							
    	 $startdate_time = $APP_DATA['STARTTIME'];
    	 $first_name    = $APP_DATA['FIRST_NAME'];
		 $last_name		= $APP_DATA['LAST_NAME'];
		
		 $dr_first_name =  DB::table('ecusers')->where('USERID',$doc_id)->value('FIRST_NAME');
		 $dr_last_name  =  DB::table('ecusers')->where('USERID',$doc_id)->value('LAST_NAME');
		 
		 $PAT_DATA 	= Ecpatmaster::where('PAT_ID', $pat_id)->first();	
		 	 
		 $title   	    =  $PAT_DATA['TITLE']; 
	     $dob   	    =  $PAT_DATA['DOB']; 
	     $dob           =  date('M jS y', strtotime($dob));
	     $email_id 	    =  $PAT_DATA['EMAIL_ID']; 
							
    	//Replace Section for all values 	
    	 $message2 = str_replace('[APP_DATE]', $date , $message2);
    	 $message2 = str_replace('[APP_TIME]', $time , $message2);
		 $message2 = str_replace('[FIRST_NAME]', $first_name , $message2);
		 $message2 = str_replace('[LAST_NAME]', $last_name , $message2);
		 $message2 = str_replace('[DOB]', $dob , $message2);
		 $message2 = str_replace('[APP_ARRIVAL]', $arrival , $message2);
		 $message2 = str_replace('[DR_FIRST_NAME]', $dr_first_name , $message2);
		 $message2 = str_replace('[DR_LAST_NAME]', $dr_last_name , $message2);
		 $message2 = str_replace('[CLINIC_NAME]', $officeName , $message2);
		 $message2 = str_replace('[TITLE]', $title , $message2);
		 $message2 = str_replace('[PATIENT_NAME]', $first_name , $message2);
	     $email_tracker = "";
        
		 //Google calander Details 
		 
		 $google_calander_details = "Hi [FIRST_NAME] [LAST_NAME], Your eyeexam appointment on [APP_DATE]@[APP_TIME] with [DR_FIRST_NAME] [DR_LAST_NAME]";	
		 $google_calander_details = str_replace("[FIRST_NAME]", $first_name, $google_calander_details);
		 $google_calander_details = str_replace("[LAST_NAME]", $last_name, $google_calander_details);
		 $google_calander_details = str_replace("[APP_DATE]",$date, $google_calander_details);
		 $google_calander_details = str_replace("[APP_TIME]",$time, $google_calander_details);
		 $google_calander_details = str_replace("[DR_FIRST_NAME]", $dr_first_name,$google_calander_details);
		 $google_calander_details = str_replace("[DR_LAST_NAME]", $dr_last_name,$google_calander_details);
			
		$google_calendar = "https://calendar.google.com/calendar/render?action=TEMPLATE&text=Eye Exam@{$officeName}&dates=". date('Ymd\THis\Z', strtotime($startdate_val)) ."/". date('Ymd\THis\Z', strtotime($enddate_val))."&details=$google_calander_details&location={$officeName},{$address1},{$city},{$state}";
							
		
			$patient_portal_direction_google_cal_btn = '<div style="text-align:center;">';
							 if($google_calendar && $google_calendar_val == "1") {
								$patient_portal_direction_google_cal_btn .= '<a href="'.$google_calendar.'"><button type="button" style="max-width:200px;min-width:200px;height:50px;color:#00bfff;border:1px solid #00bfff;background-color:#ffffff;font-size:14px; margin: 8px;">Add to Calendar</button></a>';
							 }
							 if($patient_portal_link != "" && $patient_portal_val == "1") {
								$patient_portal_direction_google_cal_btn .= '<a href="'.$patient_portal_link.'"><button type="button" style="max-width:200px;min-width:200px;height:50px;color:#00bfff;border:1px solid #00bfff;background-color:#ffffff;font-size:14px; margin: 8px;">Patient Portal</button></a>';
							 }
							 if($direction_link != "" && $map_direction_val == "1") {
								$patient_portal_direction_google_cal_btn .= '<a href="'.$direction_link.'"><button type="button" style="max-width:200px;min-width:200px;height:50px;color:#00bfff;border:1px solid #00bfff;background-color:#ffffff;font-size:14px; margin: 8px;">Map Directions</button></a>';
							 }
						 $patient_portal_direction_google_cal_btn .= '</div>';
				
		 $message2 = str_replace('[PATIENT_PORTAL/DIRECTIONS/GOOGLE_CALENDAR]', $patient_portal_direction_google_cal_btn , $message2);
		 $message2 = str_replace('[CONFIRM_LINK]', '' , $message2);
	     $message2 = $message2;
    	
		 $unsubscribe_link      = $clinicDetail['patient_portal']."/unsubscribe.php?p=".base64_encode($pat_id);	
		//$toEmail = "javithkhan@gmail.com";
		$toEmail = explode(',', $email_id);
			
		$emailData = [
							'templatePath' => $template_path,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'message2' =>  $message2,
							'toEmail' => $toEmail,
							'bg_color' =>  $bg_color,
							'email_header_color' =>  $email_header_color,
							'image' =>  $image,
							'email_tracker' =>  $email_tracker,
							'unsubscribe_link' =>$unsubscribe_link,  
							'subject' => $subject
	        ];
			$this->sendEmail($emailData);	
		}	
		
	//send Invoice Email with attached document to user 
	public function sendInvoiceEmail($invoiceno,$pdf,$emailTemplateName){
	
		$templateData = Ecemailtemplate::where([['template_name', $emailTemplateName],['status','1']])->first();
		$template	   = $templateData->template;
		$subject 	   = $templateData->subject; 	
		$template_path = $templateData->templatePath;
		$message2		= $templateData->message; 
		$bg_color 		= $templateData->bg_color; 
		$image 		= $templateData->image; 
	
			
		$email_header_color = $templateData->email_header_color;
		$ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
		
		$INVOICE_DATA 	= Ecpatinvoice::where('id', $invoiceno)->first();	
		
	    $pat_id 		= $INVOICE_DATA['pat_id'];
	   	$doc_id 		= $INVOICE_DATA['doc_id'];
		$order_no  		= $INVOICE_DATA['order_no'];
		$order_status 	= $INVOICE_DATA['status'];
		$order_date 	= $INVOICE_DATA['careated_date'];
		
		$patData = DB::table('ecpatmaster')->where('PAT_ID', $pat_id)->first();
		$patient_name = $patData->FIRST_NAME."".$patData->LAST_NAME;
		
		$PAT_DATA 	= Ecpatmaster::where('PAT_ID', $pat_id)->first();	
		$title   	    =  $PAT_DATA['TITLE']; 
	    $dob   	    	=  $PAT_DATA['DOB']; 
	    $dob            =  date('M jS y', strtotime($dob));
	    $email_id 	    =  $PAT_DATA['EMAIL_ID']; 
		$first_name     =  $PAT_DATA['FIRST_NAME'];
		$last_name		=  $PAT_DATA['LAST_NAME'];
		
		$dr_first_name =  DB::table('ecusers')->where('USERID',$doc_id)->value('FIRST_NAME');
		$dr_last_name  =  DB::table('ecusers')->where('USERID',$doc_id)->value('LAST_NAME');
		 
		//Replace Section for all values 	
    	 $message2 = str_replace('[FIRST_NAME]', $first_name , $message2);
		 $message2 = str_replace('[LAST_NAME]', $last_name , $message2);
		 $message2 = str_replace('[DOB]', $dob , $message2);
		 $message2 = str_replace('[DR_FIRST_NAME]', $dr_first_name , $message2);
		 $message2 = str_replace('[DR_LAST_NAME]', $dr_last_name , $message2);
		 $message2 = str_replace('[CLINIC_NAME]', $officeName , $message2);
		 $message2 = str_replace('[TITLE]', $title , $message2);
		 $message2 = str_replace('[PATIENT_NAME]', $first_name , $message2);
		 $message2 = str_replace('[ORDER_DATE]', $order_date , $message2);
		 $message2 = str_replace('[ORDER_NUM]', $order_no , $message2);
		 $message2 = str_replace('[ORDER_STATUS]', $order_status , $message2);
		 
	     $message2 = $message2;
    	 $email_tracker = "";
         $unsubscribe_link      = $clinicDetail['patient_portal']."/unsubscribe.php?p=".base64_encode($pat_id);	
		 //$toEmail = "javithkhan@gmail.com";
		 $toEmail = explode(',', $email_id);
	
		$data = [];
        $data['pdf'] = $pdf;
   		$emailData = [
							'templatePath' => $template_path,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'message2' =>  $message2,
							'toEmail' => $toEmail,
							'bg_color' =>  $bg_color,
							'email_header_color' =>  $email_header_color,
							'image' =>  $image,
							'email_tracker' =>  $email_tracker,
							'subject' => $subject,
							'attach_data' => $data['pdf'],
							'unsubscribe_link' =>$unsubscribe_link,  
							'attach_name' => 'invoice.pdf',
							'mime' => 'application/pdf'				
	        ];
			
		//	$this->sendEmail_attachment($emailData,"",$data['pdf']);	
			$this->sendEmail($emailData);
		}
		
	//send Rx Glasses Prescription Email with attached document to user
	
	public function sendRxGlassesPrescriptionEmail($case_id,$pdf,$emailTemplateName){
	
		$templateData = Ecemailtemplate::where([['template_name', $emailTemplateName],['status','1']])->first();
		$template	   = $templateData->template;
		$subject 	   = $templateData->subject; 	
		$template_path = $templateData->templatePath;
		$message2		= $templateData->message; 
		$bg_color 		= $templateData->bg_color; 
		$image 			= $templateData->image; 
	
			
		$email_header_color = $templateData->email_header_color;
		$ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
		
		
		    
        $ecpatcasemaster = new Ecpatcasemaster();
        $ecpatcasemaster = $ecpatcasemaster::where(['case_id' => $case_id])->get()-> first();
        
    	$pat_id 		= $ecpatcasemaster['PAT_ID'];
	   	$doc_id 		= $ecpatcasemaster['DIAGNOS_DOC'];
		
		
		$patData = DB::table('ecpatmaster')->where('PAT_ID', $pat_id)->first();
		$patient_name = $patData->FIRST_NAME."".$patData->LAST_NAME;
		
		$PAT_DATA 	= Ecpatmaster::where('PAT_ID', $pat_id)->first();	
		$title   	    =  $PAT_DATA['TITLE']; 
	    $dob   	    	=  $PAT_DATA['DOB']; 
	    $dob            =  date('M jS y', strtotime($dob));
	    $email_id 	    =  $PAT_DATA['EMAIL_ID']; 
		$first_name     =  $PAT_DATA['FIRST_NAME'];
		$last_name		=  $PAT_DATA['LAST_NAME'];
		
		$dr_first_name =  DB::table('ecusers')->where('USERID',$doc_id)->value('FIRST_NAME');
		$dr_last_name  =  DB::table('ecusers')->where('USERID',$doc_id)->value('LAST_NAME');
		 
		//Replace Section for all values 	
    	 $message2 = str_replace('[FIRST_NAME]', $first_name , $message2);
		 $message2 = str_replace('[LAST_NAME]', $last_name , $message2);
		 $message2 = str_replace('[DOB]', $dob , $message2);
		 $message2 = str_replace('[DR_FIRST_NAME]', $dr_first_name , $message2);
		 $message2 = str_replace('[DR_LAST_NAME]', $dr_last_name , $message2);
		 $message2 = str_replace('[CLINIC_NAME]', $officeName , $message2);
		 $message2 = str_replace('[TITLE]', $title , $message2);
		 $message2 = str_replace('[PATIENT_NAME]', $first_name , $message2);
		 
	     $message2 = $message2;
    	 $email_tracker = "";
         $unsubscribe_link      = $clinicDetail['patient_portal']."/unsubscribe.php?p=".base64_encode($pat_id);
		 //$toEmail = "javithkhan@gmail.com";
		 $toEmail = explode(',', $email_id);
	
		$data = [];
        $data['pdf'] = $pdf;
   		$emailData = [
							'templatePath' => $template_path,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'message2' =>  $message2,
							'toEmail' => $toEmail,
							'bg_color' =>  $bg_color,
							'email_header_color' =>  $email_header_color,
							'image' =>  $image,
							'email_tracker' =>  $email_tracker,
							'subject' => $subject,
							'attach_data' => $data['pdf'],
							'attach_name' => 'prescription.pdf',
							'mime' => 'application/pdf',
							'unsubscribe_link' =>$unsubscribe_link  				
	        ];
			
		//	$this->sendEmail_attachment($emailData,"",$data['pdf']);	
			$this->sendEmail($emailData);
		}	
		
   	//send Rx Contact Lens Prescription Email with attached document to user
	
	public function sendRxclPrescriptionEmail($case_id,$pdf,$emailTemplateName){
	
		$templateData = Ecemailtemplate::where([['template_name', $emailTemplateName],['status','1']])->first();
		$template	   = $templateData->template;
		$subject 	   = $templateData->subject; 	
		$template_path = $templateData->templatePath;
		$message2		= $templateData->message; 
		$bg_color 		= $templateData->bg_color; 
		$image 			= $templateData->image; 
	
			
		$email_header_color = $templateData->email_header_color;
		$ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
		
		
		    
        $ecpatcasemaster = new Ecpatcasemaster();
        $ecpatcasemaster = $ecpatcasemaster::where(['case_id' => $case_id])->get()-> first();
        
    	$pat_id 		= $ecpatcasemaster['PAT_ID'];
	   	$doc_id 		= $ecpatcasemaster['DIAGNOS_DOC'];
		
		
		$patData = DB::table('ecpatmaster')->where('PAT_ID', $pat_id)->first();
		$patient_name = $patData->FIRST_NAME."".$patData->LAST_NAME;
		
		$PAT_DATA 	= Ecpatmaster::where('PAT_ID', $pat_id)->first();	
		$title   	    =  $PAT_DATA['TITLE']; 
	    $dob   	    	=  $PAT_DATA['DOB']; 
	    $dob            =  date('M jS y', strtotime($dob));
	    $email_id 	    =  $PAT_DATA['EMAIL_ID']; 
		$first_name     =  $PAT_DATA['FIRST_NAME'];
		$last_name		=  $PAT_DATA['LAST_NAME'];
		
		$dr_first_name =  DB::table('ecusers')->where('USERID',$doc_id)->value('FIRST_NAME');
		$dr_last_name  =  DB::table('ecusers')->where('USERID',$doc_id)->value('LAST_NAME');
		 
		//Replace Section for all values 	
    	 $message2 = str_replace('[FIRST_NAME]', $first_name , $message2);
		 $message2 = str_replace('[LAST_NAME]', $last_name , $message2);
		 $message2 = str_replace('[DOB]', $dob , $message2);
		 $message2 = str_replace('[DR_FIRST_NAME]', $dr_first_name , $message2);
		 $message2 = str_replace('[DR_LAST_NAME]', $dr_last_name , $message2);
		 $message2 = str_replace('[CLINIC_NAME]', $officeName , $message2);
		 $message2 = str_replace('[TITLE]', $title , $message2);
		 $message2 = str_replace('[PATIENT_NAME]', $first_name , $message2);
		 
	     $message2 = $message2;
    	 $email_tracker = "";
         $unsubscribe_link      = $clinicDetail['patient_portal']."/unsubscribe.php?p=".base64_encode($pat_id);
		 //$toEmail = "javithkhan@gmail.com";
		 $toEmail = explode(',', $email_id);
	
		$data = [];
        $data['pdf'] = $pdf;
   		$emailData = [
							'templatePath' => $template_path,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'message2' =>  $message2,
							'toEmail' => $toEmail,
							'bg_color' =>  $bg_color,
							'email_header_color' =>  $email_header_color,
							'image' =>  $image,
							'email_tracker' =>  $email_tracker,
							'subject' => $subject,
							'attach_data' => $data['pdf'],
							'attach_name' => 'prescription.pdf',
							'mime' => 'application/pdf',
							'unsubscribe_link' =>$unsubscribe_link 				
	        ];
			
		//	$this->sendEmail_attachment($emailData,"",$data['pdf']);	
			$this->sendEmail($emailData);
		}
		
	//send sendMedicationEmail Email with attached document to user
	
	public function sendMedicationEmail($case_id,$pdf,$emailTemplateName){
	
		$templateData = Ecemailtemplate::where([['template_name', $emailTemplateName],['status','1']])->first();
		$template	   = $templateData->template;
		$subject 	   = $templateData->subject; 	
		$template_path = $templateData->templatePath;
		$message2		= $templateData->message; 
		$bg_color 		= $templateData->bg_color; 
		$image 			= $templateData->image; 
	
			
		$email_header_color = $templateData->email_header_color;
		$ecofclocation = new Ecofficelocation();
		$clinicDetail = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo = $clinicDetail['logo'];
		$officeName = $clinicDetail['officeName'];
		
		
		    
        $ecpatcasemaster = new Ecpatcasemaster();
        $ecpatcasemaster = $ecpatcasemaster::where(['case_id' => $case_id])->get()-> first();
        
    	$pat_id 		= $ecpatcasemaster['PAT_ID'];
	   	$doc_id 		= $ecpatcasemaster['DIAGNOS_DOC'];
		
		
		$patData = DB::table('ecpatmaster')->where('PAT_ID', $pat_id)->first();
		$patient_name = $patData->FIRST_NAME."".$patData->LAST_NAME;
		
		$PAT_DATA 	= Ecpatmaster::where('PAT_ID', $pat_id)->first();	
		$title   	    =  $PAT_DATA['TITLE']; 
	    $dob   	    	=  $PAT_DATA['DOB']; 
	    $dob            =  date('M jS y', strtotime($dob));
	    $email_id 	    =  $PAT_DATA['EMAIL_ID']; 
		$first_name     =  $PAT_DATA['FIRST_NAME'];
		$last_name		=  $PAT_DATA['LAST_NAME'];
		
		$dr_first_name =  DB::table('ecusers')->where('USERID',$doc_id)->value('FIRST_NAME');
		$dr_last_name  =  DB::table('ecusers')->where('USERID',$doc_id)->value('LAST_NAME');
		 
		//Replace Section for all values 	
    	 $message2 = str_replace('[FIRST_NAME]', $first_name , $message2);
		 $message2 = str_replace('[LAST_NAME]', $last_name , $message2);
		 $message2 = str_replace('[DOB]', $dob , $message2);
		 $message2 = str_replace('[DR_FIRST_NAME]', $dr_first_name , $message2);
		 $message2 = str_replace('[DR_LAST_NAME]', $dr_last_name , $message2);
		 $message2 = str_replace('[CLINIC_NAME]', $officeName , $message2);
		 $message2 = str_replace('[TITLE]', $title , $message2);
		 $message2 = str_replace('[PATIENT_NAME]', $first_name , $message2);
		 
	     $message2 = $message2;
    	 $email_tracker = "";
         $unsubscribe_link      = $clinicDetail['patient_portal']."/unsubscribe.php?p=".base64_encode($pat_id);
		  
		 //$toEmail = "javithkhan@gmail.com";
		 $toEmail = explode(',', $email_id);
	
		$data = [];
        $data['pdf'] = $pdf;
   		$emailData = [
							'templatePath' => $template_path,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'message2' =>  $message2,
							'toEmail' => $toEmail,
							'bg_color' =>  $bg_color,
							'email_header_color' =>  $email_header_color,
							'image' =>  $image,
							'email_tracker' =>  $email_tracker,
							'subject' => $subject,
							'attach_data' => $data['pdf'],
							'attach_name' => 'medication.pdf',
							'mime' => 'application/pdf',
							'unsubscribe_link' =>$unsubscribe_link 					
	        ];
			
		//	$this->sendEmail_attachment($emailData,"",$data['pdf']);	
			$this->sendEmail($emailData);
		}
		
		
	//send New Email Consent to user
		
	 public function sendEmailConsent($pat_id,$emailTemplateName){
		
		$templateData = Ecemailtemplate::where([['template_name', $emailTemplateName],['status','1']])->first();
		$template	   = $templateData->template;
		$subject 	   = $templateData->subject; 	
		$template_path = $templateData->templatePath;
		$message2		= $templateData->message; 
		$bg_color 		= $templateData->bg_color; 
		$image 		    = $templateData->image; 
	    $google_calendar_val = $templateData->google_calendar;
		$patient_portal_val	= 	$templateData->patient_portal;
		$map_direction_val	= 	$templateData->map_direction;
		$email_header_color = $templateData->email_header_color;
		
		
		$ecofclocation = new Ecofficelocation();
		$clinicDetail  		   = $ecofclocation::orderby('id','ASC')->get()->first();
		$officelogo            = $clinicDetail['logo'];
		$officeName            = $clinicDetail['officeName'];
		$address1	           = $clinicDetail['address1'];
		$city	       		   = $clinicDetail['city'];
		$state    			   = $clinicDetail['state'];
		$patient_portal_link   =  $clinicDetail['patient_portal'];
		$direction_link		   = $clinicDetail['direction_link'];	
	
		//Fetching patient appointment details from ecrq_id
		
		 
		 $PAT_DATA 	= Ecpatmaster::where('PAT_ID', $pat_id)->first();	
		 	 
		 $title   	    =  $PAT_DATA['TITLE']; 
	     $dob   	    =  $PAT_DATA['DOB']; 
	     $dob           =  date('M jS y', strtotime($dob));
	     $email_id 	    =  $PAT_DATA['EMAIL_ID']; 
		 $first_name    =  $PAT_DATA['FIRST_NAME']; 
		 $last_name     =  $PAT_DATA['LAST_NAME']; 

		//Replace Section for all values 	
    	 $message2 = str_replace('[APP_DATE]', '' , $message2);
    	 $message2 = str_replace('[APP_TIME]', '' , $message2);
		 $message2 = str_replace('[FIRST_NAME]', $first_name , $message2);
		 $message2 = str_replace('[LAST_NAME]', $last_name , $message2);
		 $message2 = str_replace('[DOB]', $dob , $message2);
		 $message2 = str_replace('[APP_ARRIVAL]', '' , $message2);
		 $message2 = str_replace('[DR_FIRST_NAME]', '' , $message2);
		 $message2 = str_replace('[DR_LAST_NAME]', '' , $message2);
		 $message2 = str_replace('[CLINIC_NAME]', $officeName , $message2);
		 $message2 = str_replace('[TITLE]', $title , $message2);
		 $message2 = str_replace('[PATIENT_NAME]', $first_name , $message2);
	     
    	 $email_tracker = "";
		 $message2 = str_replace('[PATIENT_PORTAL/DIRECTIONS/GOOGLE_CALENDAR]','' , $message2);
		 $message2 = str_replace('[CONFIRM_LINK]', '' , $message2);
	     $message2 = $message2;
		  $unsubscribe_link      = $clinicDetail['patient_portal']."/unsubscribe.php?p=".base64_encode($pat_id);
		 
    	 
		 //$toEmail = "javithkhan@gmail.com";
		 $toEmail = explode(',', $email_id);
			
		$emailData = [
							'templatePath' => $template_path,
							'officelogo' => $officelogo,
							'officeName' =>	$officeName, 	
							'message2' =>  $message2,
							'toEmail' => $toEmail,
							'bg_color' =>  $bg_color,
							'email_header_color' =>  $email_header_color,
							'image' =>  $image,
							'email_tracker' =>  $email_tracker,
							'unsubscribe_link' =>$unsubscribe_link, 			  
							'subject' => $subject
	        ];
			$this->sendEmail($emailData);	
		}
		
	
										
}
?>