<?php
namespace App\Http\ASCIIBC;
use App\Http\ASCIIBC\OHIPStatusHistory;
use App\Models\ecpatientbilling;
use Carbon\Carbon;
use DB;

class MROASCIIFileDBHelper
{

	public function getDoctorDetailsByProvider($provider)
	{
		$query = "SELECT * FROM ecusers where ohipRegNum = '".$provider."'";
		
		$providerNumber ="";					
		
		$res = DB::select($query);
		
		$doctorDetails = "<doctor>";
		if($row = json_decode(json_encode((array) $res), true)[0])
		{
			$doctorDetails .= "<name>".stripslashes($row['FIRST_NAME'])." ".stripslashes($row['LAST_NAME'])."</name>";
			$doctorDetails .= "<id>".$row['USERID']."</id>";
		}
		$doctorDetails .= "</doctor>";		
		return $doctorDetails;
		
	}
	public function getPatientDetailsByCard($healthcardNumber)
	{
		$query = "SELECT PAT_ID,FIRST_NAME,LAST_NAME FROM ecpatmaster where OHIP = '".$healthcardNumber."'";
		
		$providerNumber ="";					
		
		$res = DB::select($query);
		
		$doctorDetails = "<patient>";
		if($row = json_decode(json_encode((array) $res), true))
		{
			$doctorDetails .= "<name>".stripslashes($row[0]['FIRST_NAME'])." ".stripslashes($row[0]['LAST_NAME'])."</name>";
			$doctorDetails .= "<id>".$row[0]['PAT_ID']."</id>";
		}
		$doctorDetails .= "</patient>";		
		return $doctorDetails;

	}	
	
	public function getRemittanceAdviceReason($code){
		$splitArr = str_split($code,2);
		for($i=0;$i<count($splitArr);$i++)
		{
			$splitArr[$i] = "'".$splitArr[$i]."'";
		}
		$query = "SELECT * FROM ecremittanceadvicecodes WHERE code IN(".implode(",",$splitArr).");";
		
		$res = DB::select($query);
		$reason = "<reason>";
		foreach(json_decode(json_encode((array) $res), true) as $row)
		{
			$reason .= $row['explanation'].". ";
		}
		$reason .= "</reason>";		
		return $reason;
		
	}
	
	public function checkProviderClaim($dcn)
	{
		$query = "SELECT USERID FROM ecusers WHERE dcNumber='".$dcn."'";
		
		
		$res = DB::select($query);
		
		if(count($res) > 0){
			return true;
		}else{
			return false;
		}
		
	}
	
	public function getClaimDetails($claimNumber)
	{
		$query = "SELECT ECPB.id,CONCAT(ECPM.FIRST_NAME,' ',ECPM.LAST_NAME) AS patname,
					ECPM.OHIP,ECPB.amount,co.code,CONCAT(ECU.FIRST_NAME,' ',ECU.LAST_NAME) AS docname,
					ECPB.billing_date  
					FROM ecpatientbilling ECPB 
					LEFT OUTER JOIN ecpatmaster ECPM ON ECPM.PAT_ID = ECPB.pat_id
					LEFT OUTER JOIN eccodes co ON co.codeno = ECPB.codeno
					LEFT OUTER JOIN ecusers ECU ON ECU.USERID = ECPB.docId
					WHERE ECPB.claimnumber = '".$claimNumber."';";
		
		$res = DB::select($query);
		
		$details = "";
		if($row = json_decode(json_encode((array) $res), true)[0])
		{
			$details .= "<patname>".$row['patname']."</patname>";
			$details .= "<OHIP>".$row['OHIP']."</OHIP>";
			$details .= "<submitedAmount>".$row['amount']."</submitedAmount>";
			$details .= "<code>".$row['code']."</code>";
			$details .= "<docname>".$row['docname']."</docname>";
			$details .= "<serviceDate>".$row['billing_date']."</serviceDate>";
			
		}
		return $details;
	}
	

	
	public function addFileUploadHistroy($fileName,$userId)
	{
		$now = Carbon::now();
		$todayTime = $now->format('Y-m-d H:i:s');
		$query = "INSERT INTO ecmrofilehistory(`fileName`,`uploadedby`,`uploadeddate`)
		VALUES('".$fileName."','".$userId."','".$todayTime."')";
		
		DB::select($query);		
			
	}
	
	public function checkMROFileExist($fileName)
	{
		$now = Carbon::now();
		$year = $now->format('Y');
		$query = "SELECT * FROM ecmrofilehistory WHERE fileName = '".$fileName."'  AND DATE_FORMAT(uploadeddate,'%Y')=".$year;
		$res = DB::select($query);	
		if(count($res) > 0){
			return "exist";
		}else{
			return "not exist";
		}
		
	}
	
	public function deleteMROFile($fileId)
	{
		$query = "DELETE FROM ecmrofilehistory WHERE `id`='".$fileId."';";
		
		$res = DB::select($query);	
		
		if($res > 0)
		{
			return "<message>Deleted Successfully</message>";
		}else{
			return "<message>Delete Failed</message>";
		}
		
	}
	
	public function proceedMROChanges($claimNumber,$submitedAmount,$amountPaid,$status,$explanatoryCode)
	{
		$queryAlreadyPaid = "SELECT id FROM ecpatientbilling WHERE claimnumber = '".$claimNumber."' AND ohip_status IN('FP','PP','RP','WP');";
		
		if($status != "R"){
			$query = "UPDATE ecpatientbilling SET 
			`amountsubmitted` = '".$submitedAmount."',
			`amountpaid` = '".$amountPaid."',
			`ohip_status` = '".$status."'
			WHERE claimnumber = '".$claimNumber."'";
		}else{
			$query = "UPDATE ecpatientbilling SET
			`amountsubmitted` = '".$submitedAmount."',
			`amountpaid` = '".$amountPaid."',
			`ohip_status` = '".$status."',
			`explanatoryCode` = '".$explanatoryCode."'
			WHERE claimnumber = '".$claimNumber."'";
		}
		
		$res = DB::select($queryAlreadyPaid);	
		if(count($res) == 0){		// we have to lock the record updation if the record is already paid
			DB::select($query);
			///// add ohip status history
			$ohipStatusHistory = new OHIPStatusHistory();
			$ohipStatusHistory->addOhipHistory($claimNumber,$status);
			////////////			
		}

	}

	
}