<?php
namespace App\Http\ASCIIBC;

use App\Http\ASCIIBC\MROASCIIFileDBHelper;

class MROASCIIFileCompiler
{
	var $errorCollection="";
	var $mroCollection="";
	
	public function getMRORecord($fileContent)
	{
		$startCharPos = 0;
		$endCharPos = 0;
		
		$mroCollection = "<MRO>";

		$mroCollection .= "<claims>";

		while(1){
			$isProviderClaim = false;
			$claimHeaderRecord = "";
			if(strlen($fileContent) >= $startCharPos){
				// For message record
				if(substr($fileContent,$startCharPos,3) == "M01"){
					$claimItem = substr($fileContent,$startCharPos,376);
					$startCharPos += 378;
					if($this->checkProviderClaim($claimItem)){
						$isProviderClaim = true;
						$claimHeaderRecord .= $this->getMessageRecord($claimItem);
					}
				}
				////Claim Refusal Record
				else if(substr($fileContent,$startCharPos,3) == "C12")
				{
					$claimItem = substr($fileContent,$startCharPos,70);
					$startCharPos += 72;
					if($this->checkProviderClaim($claimItem)){
						$isProviderClaim = true;
						$claimHeaderRecord .= "<claimItem>";
						$claimHeaderRecord .= $this->getClaimRefusalRecord($claimItem);
						$claimHeaderRecord .= "</claimItem>";
					}
				}
				//// paid as billed S01
				else if(substr($fileContent,$startCharPos,3) == "S01")
				{
					$claimItem = substr($fileContent,$startCharPos,166);
					$startCharPos += 168;
					if($this->checkProviderClaim($claimItem)){
						$isProviderClaim = true;
						$claimHeaderRecord .= "<claimItem>";
						$claimHeaderRecord .= $this->getClaimS01($claimItem);
						$claimHeaderRecord .= "</claimItem>";
					}
				}
				////  S00,S02,S03
				else if(substr($fileContent,$startCharPos,3) == "S00" || substr($fileContent,$startCharPos,3) == "S02" 
				|| substr($fileContent,$startCharPos,3) == "S03")
				{
					$claimItem = substr($fileContent,$startCharPos,268);
					$startCharPos += 270;
					if($this->checkProviderClaim($claimItem)){
						$isProviderClaim = true;
						$claimHeaderRecord .= "<claimItem>";
						$claimHeaderRecord .= $this->getClaimS000203($claimItem);
						$claimHeaderRecord .= "</claimItem>";
					}
				}
				//// payment in hold S04
				else if(substr($fileContent,$startCharPos,3) == "S04")
				{
					$claimItem = substr($fileContent,$startCharPos,166);
					$startCharPos += 168;
					if($this->checkProviderClaim($claimItem)){
						$isProviderClaim = true;
						$claimHeaderRecord .= "<claimItem>";
						$claimHeaderRecord .= $this->getClaimS04($claimItem);
						$claimHeaderRecord .= "</claimItem>";
					}
				}
				// summary records and broadcast message
				else if(substr($fileContent,$startCharPos,3) == "S21" || substr($fileContent,$startCharPos,3) == "S22" 
				|| substr($fileContent,$startCharPos,3) == "S23" || substr($fileContent,$startCharPos,3) == "S24" 
				|| substr($fileContent,$startCharPos,3) == "S25"){
					$startCharPos += 168;
				}
				
				else{
					break;
				}
			}else{
				break;
			}
					
			if($isProviderClaim == true){
				$mroCollection .= $claimHeaderRecord;		
			}
			
			if($startCharPos > strlen($fileContent)){
				break;
			}
		
		}
		
		$mroCollection .= "</claims>";
		
		
		
		
		$mroCollection .= "</MRO>";	
		
		return $mroCollection;
	}
	
	
	public function getClaimRefusalRecord($claimItem)
	{
		$claimItemXML  = "<claimNumber>".substr($claimItem,8,7)."</claimNumber>";														
		$claimItemXML .= "<payeeNumber>".substr($claimItem,15,5)."</payeeNumber>";														
		$claimItemXML .= "<practitionerNumber>".substr($claimItem,20,5)."</practitionerNumber>";														
		$claimItemXML .= "<amountPaid>0</amountPaid>";														
		$claimItemXML .= "<explanatoryCode>".trim(substr($claimItem,25,14))."</explanatoryCode>";	
		$claimItemXML .= "<claimDetails>".$this->getClaimDetails(substr($claimItem,8,7))."</claimDetails>";	

		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$reasonXml = $mroAsciiFileDBHelper -> getRemittanceAdviceReason(trim(substr($claimItem,25,14)));
		$claimItemXML.= $reasonXml;
		
		return $claimItemXML;
	}
	
	public function getClaimS01($claimItem)
	{
		$claimItemXML  = "<claimNumber>".substr($claimItem,8,7)."</claimNumber>";														
		$claimItemXML .= "<paymentDate>".substr($claimItem,15,8)."</paymentDate>";														
		$claimItemXML .= "<payeeNumber>".substr($claimItem,24,5)."</payeeNumber>";														
		$claimItemXML .= "<practitionerNumber>".substr($claimItem,35,5)."</practitionerNumber>";														
		$claimItemXML .= "<adjustmentCode>".substr($claimItem,40,2).substr($claimItem,49,2)
		.substr($claimItem,58,2).substr($claimItem,67,2).substr($claimItem,76,2)
		.substr($claimItem,85,2).substr($claimItem,94,2)."</adjustmentCode>";														
		$claimItemXML .= "<adjustAmount>".substr($claimItem,42,7).substr($claimItem,51,7)
		.substr($claimItem,60,7).substr($claimItem,69,7).substr($claimItem,78,7)
		.substr($claimItem,87,7).substr($claimItem,96,7)."</adjustAmount>";														
		$claimItemXML .= "<amountPaid>".substr($claimItem,110,5).'.'.substr($claimItem,115,2)."</amountPaid>";														
		$claimItemXML .= "<explanatoryCode></explanatoryCode>";	
		$claimItemXML .= "<claimDetails>".$this->getClaimDetails(substr($claimItem,8,7))."</claimDetails>";	

		return $claimItemXML;
	}
	public function getClaimS000203($claimItem)
	{
		$claimItemXML  = "<claimNumber>".substr($claimItem,8,7)."</claimNumber>";														
		$claimItemXML .= "<paymentDate>".substr($claimItem,15,8)."</paymentDate>";														
		$claimItemXML .= "<payeeNumber>".substr($claimItem,24,5)."</payeeNumber>";														
		$claimItemXML .= "<practitionerNumber>".substr($claimItem,35,5)."</practitionerNumber>";														
		$claimItemXML .= "<amountPaid>".substr($claimItem,117,5).".".substr($claimItem,122,2)."</amountPaid>";														
		$claimItemXML .= "<explanatoryCode>".trim(substr($claimItem,131,14))."</explanatoryCode>";	
		$claimItemXML .= "<adjustmentCode>".substr($claimItem,145,2).substr($claimItem,154,2)
		.substr($claimItem,163,2).substr($claimItem,172,2).substr($claimItem,181,2)
		.substr($claimItem,190,2).substr($claimItem,199,2)."</adjustmentCode>";														
		$claimItemXML .= "<adjustAmount>".substr($claimItem,147,7).substr($claimItem,156,7)
		.substr($claimItem,165,7).substr($claimItem,174,7).substr($claimItem,183,7)
		.substr($claimItem,192,7).substr($claimItem,201,7)."</adjustAmount>";														
		
		$claimItemXML .= "<claimDetails>".$this->getClaimDetails(substr($claimItem,8,7))."</claimDetails>";	

		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$reasonXml = $mroAsciiFileDBHelper -> getRemittanceAdviceReason(trim(substr($claimItem,131,14)));
		$claimItemXML.= $reasonXml;
		
		return $claimItemXML;
	}
	
	public function getClaimS04($claimItem)
	{
		$claimItemXML  = "<claimNumber>".substr($claimItem,8,7)."</claimNumber>";														
		$claimItemXML .= "<paymentDate>".substr($claimItem,15,8)."</paymentDate>";														
		$claimItemXML .= "<payeeNumber>".substr($claimItem,24,5)."</payeeNumber>";														
		$claimItemXML .= "<practitionerNumber>".substr($claimItem,35,5)."</practitionerNumber>";														
		$claimItemXML .= "<amountPaid>0</amountPaid>";														
		$claimItemXML .= "<explanatoryCode>".trim(substr($claimItem,55,14))."</explanatoryCode>";	
		$claimItemXML .= "<claimDetails>".$this->getClaimDetails(substr($claimItem,8,7))."</claimDetails>";	

		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$reasonXml = $mroAsciiFileDBHelper -> getRemittanceAdviceReason(trim(substr($claimItem,55,14)));
		$claimItemXML.= $reasonXml;
		
		return $claimItemXML;
	}
	
	
	public function getClaimDetails($claimNumber)
	{
		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$claimXML = $mroAsciiFileDBHelper -> getClaimDetails($claimNumber);
		return $claimXML;
		
	}
	
	
	
	public function getMessageRecord($messageRecord)
	{
		$messageXML = "<message>";
		$messageXML .= "<messageText>".trim(substr($messageRecord,12,350))."</messageText>";
		$messageXML .= "</message>";
		return $messageXML;
		
	}
	
	public function checkProviderClaim($claimItem)
	{
		$dcn = substr($claimItem,3,5);
		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$isOwnRecord = $mroAsciiFileDBHelper -> checkProviderClaim($dcn);
		return $isOwnRecord;
				
	}
	

	
}
?>