<?php
namespace App\Http\ASCIIBC;

use App\Http\ASCIIBC\BatchHeaderVO;
use App\Http\ASCIIBC\ClaimHeaderVO;
use Carbon\Carbon;
use DB;

class ASCIIFileDBHelper
{


	public function getHealthcareProvider($doctorId)
	{

		$query = "SELECT ohipRegNum as providerNumber FROM ecusers where USERID = ".$doctorId;
		
		$providerNumber ="";					
		
		$res = DB::select($query);
		if($row = json_decode(json_encode((array) $res), true))
		{
			$providerNumber = $row[0]['providerNumber'];
		}
		
		return $providerNumber;
		
	}
	public function getBatchHeaderRecord($doctorId)
	{
		$batchHeaderVO = new BatchHeaderVO();
		$query = "SELECT dcNumber FROM ecusers where USERID = ".$doctorId;
		$res = DB::select($query);
		
		if($row=json_decode(json_encode((array) $res), true)[0])
		{
			$batchHeaderVO ->dataCentreNumber = strtoupper($row['dcNumber']);
		}
		$batchHeaderVO ->DCNseqNumber = $this->getFirstClaimNumber();
		
		return $batchHeaderVO;
		
	}
	
	public function getFirstClaimNumber()
	{
		$firstClaimNumber = 0;
		$query = "SELECT lastclaimnumber FROM eclastclaim";
		$res = DB::select($query);
		
		if($row=json_decode(json_encode((array) $res), true)[0])
		{
			$firstClaimNumber = $row['lastclaimnumber'];
		}
		$firstClaimNumber = $this -> getNextClaimNumber($firstClaimNumber);
		return $firstClaimNumber;
	}
	
	public function getNextClaimNumber($start){
		$start = (int)$start;
		$start++;
		$startStr = str_pad($start,7,"0",STR_PAD_LEFT);
		return $startStr;
	}
	
	public function getCoreClaimNumber($claimNumber)
	{
		$claimNumber = substr($claimNumber,0,7);
		return (int)$claimNumber;
	}
	
	public function getItemRecords($recordIds)
	{
	
	    $query = "SELECT ECPB.id,CONCAT(ECPM.FIRST_NAME,' ',ECPM.LAST_NAME) as patname,ECU.dcNumber,ECU.payeeNumber, 
						ECU.ohipRegNum, ECPM.OHIP, ECPM.IS_NEW_BORN_BABY, ECPM.DEPENDANT_ID,
						ECPM.FIRST_NAME,ECPM.LAST_NAME,ECPM.GENDER,ECPM.ADDRESS1,ECPM.ADDRESS2,ECPM.POSTAL_CODE,
						ECPB.billing_code,ECPB.amount,ECPB.submission_code,
						DATE_FORMAT(ECPB.billing_date,'%Y%m%d') as serviceDate,ECPB.diagnosis_code,
						ECPB.ref_doc_id,ECPB.referred_to, ECAB.ab_ohipbilling_number,
						ECABRT.ab_ohipbilling_number as refto_billing_number,
						DATE_FORMAT(ECPM.DOB,'%Y%m%d') as pdob,ECPB.remarks,ECPB.is_mva,ECPB.oincode,ECPB.oinregnum,
						DATE_FORMAT(ECPB.wsbcdoi,'%Y%m%d') as wsbcdoi,ECPB.wsbcaoi,ECPB.wsbcap,
						ECPB.wsbcnoi,ECPB.wsbcclaimnumber,ECPB.debitseqnumber,
						DATE_FORMAT(ECPB.debitrecdate,'%Y%m%d') as debitrecdate,ECPB.icbcclaimnumber,ECPB.isotherins
						FROM ecpatientbilling ECPB 
						LEFT OUTER JOIN ecpatmaster ECPM ON ECPB.pat_id = ECPM.PAT_ID
						LEFT OUTER JOIN ecusers ECU ON ECU.USERID = ECPB.docId
						LEFT OUTER JOIN ecaddressbook ECAB ON ECAB.ab_id = ECPB.ref_doc_id
						LEFT OUTER JOIN ecaddressbook ECABRT ON ECABRT.ab_id = ECPB.referred_to
						WHERE ECPB.id IN(".$recordIds.")";
		
		$res = DB::select($query);
		
		$itemRecords = array();
		
		$claimNumber = $this->getFirstClaimNumber();
		
		foreach(json_decode(json_encode((array) $res), true) as $row )
		{
			$claimNumber = $this->getNextClaimNumber($claimNumber);
			$itemRecord = new ItemRecordVO();
			$itemRecord -> OHIPItemId = $row['id'];
			$itemRecord -> patientName = $row['patname'];
			$itemRecord -> dataCentreNumber = strtoupper($row['dcNumber']);
			$itemRecord -> DCNseqNumber = $claimNumber;
			$itemRecord -> payeeNumber = $row['payeeNumber'];
			$itemRecord -> practitionerNumber = $row['ohipRegNum'];
			$itemRecord -> MSPPHNNumber = $row['OHIP'];
			$itemRecord -> nameVerfiy = $this->getNameVerify($row['FIRST_NAME'],$row['LAST_NAME']);
			if($row['IS_NEW_BORN_BABY']==1 && $row['OHIP'] == ""){
				$itemRecord -> MSPPHNNumber = getDependentMSPPHN($row['DEPENDANT_ID']);
				$itemRecord -> dependentNumber = "66";
			}
			$itemRecord -> billedFeeItem = $row['billing_code'];
			$itemRecord -> billedAmount = str_replace('.','',$row['amount']);
			$itemRecord -> serviceDate = $row['serviceDate'];
			if($row['submission_code'] != ""){
				$itemRecord -> submissionCode = $row['submission_code'];
			}
			// For Debit submission ////
			if($itemRecord -> submissionCode == 'E'){
				$itemRecord->originalMSPFileNumber = $itemRecord -> dataCentreNumber;
				if($row['debitseqnumber'] != ""){
					$itemRecord->originalMSPFileNumber .= $row['debitseqnumber'];
				}
				if($row['debitrecdate'] != ""){
					$itemRecord->originalMSPFileNumber .= "00000000";//$row['debitrecdate'];  // as per document it can be zero
				}
			}
			//////////////
			
			/// For ICBC submission ///
			if($itemRecord -> submissionCode == 'I'){
				if($row['icbcclaimnumber'] != ""){
					$itemRecord -> ICBCClaimNumber = $row['icbcclaimnumber']; /// as per p34 teleplan spec
				}
			}
			/////////////
			$itemRecord -> diagnosticCode1 = str_replace('.','',$row['diagnosis_code']);
			if($row['ref_doc_id'] != 0 && $row['ref_doc_id'] != ""){
				$itemRecord -> refPract1CD = 'B';
				$itemRecord -> refPract1Number = $row['ab_ohipbilling_number'];
			}
			if($row['referred_to'] != 0 && $row['referred_to'] != ""){
				$itemRecord -> refPract2CD = 'T';
				$itemRecord -> refPract2Number = $row['refto_billing_number'];
			}

			$itemRecord -> birthDate = $row['pdob'];
			
			if($row['remarks'] != ""){
				$remarks = preg_replace("/[\\n\\r]+/", "", $row['remarks']);;
				if(strlen($remarks) <= 20){
					$itemRecord -> claimShortComment = str_pad($remarks,20,' ');
				}
				else{
					$claimNumber = $this->getNextClaimNumber($claimNumber);
					$itemRecord -> correspondenceCode = "N";
					$itemRecord -> noteDataLine = $remarks;
					$itemRecord -> noteDCNseqNumber = $claimNumber;
				}
			}
			
			$itemRecord -> MVAClaimCode = $row['is_mva'];
			
			///////// For other insurer like Opted out/WSBC/ICBC ///////////////
			
			if($row['isotherins'] == 1){
				$itemRecord -> MSPPHNNumber = "0000000000";
				$itemRecord -> nameVerfiy = "0000";
				$itemRecord -> OINInsurerCode = $row['oincode'];
				if($row['oinregnum'] != ""){
					$itemRecord -> OINRegNumber = $row['oinregnum'];
				}else{
					if($row['IS_NEW_BORN_BABY']==1 && $row['OHIP'] == ""){
						$itemRecord -> OINRegNumber = getDependentMSPPHN($row['DEPENDANT_ID']);
					}else{
						$itemRecord -> OINRegNumber = $row['OHIP'];
					}
					if($row['IS_NEW_BORN_BABY']==1){
						$itemRecord -> OINRegNumber .="66"; 
					}else{
						$itemRecord -> OINRegNumber .="00"; 
					}
				}
				$itemRecord -> OINBirthDate = $row['pdob'];
				$itemRecord -> OINFirstName = $row['FIRST_NAME'];
				$itemRecord -> OINSurname = $row['LAST_NAME'];
				$itemRecord -> OINSex = substr($row['GENDER'],0,1);
				if($row['ADDRESS1'] != "" && $row['ADDRESS2'] != ""){
					$itemRecord -> OINAddress1 = $row['ADDRESS1'].' '.$row['ADDRESS2'];
				}else{
					$itemRecord -> OINAddress1 = $row['ADDRESS1'].$row['ADDRESS2'];
				}
				$itemRecord -> OINPostalCode = str_replace(" ","",$row['POSTAL_CODE']);
				// for WSBC 
				if($row['oincode'] == 'WC'){
					$itemRecord -> OINAddress1 = $row['wsbcdoi'];
					$itemRecord -> OINAddress2 = $row['wsbcaoi'].$row['wsbcap'];
					$itemRecord -> OINAddress3 = $row['wsbcnoi'];
					$itemRecord -> OINAddress4 = $row['wsbcclaimnumber'];
				}
				// for ICBC
				if($row['oincode'] == 'IN'){
					$itemRecord -> MVAClaimCode = 'Y';/// as per p34 teleplan spec
				}
			}
			
			$itemRecords[] = $itemRecord;
			
		}	
		
		return $itemRecords;	
	
	}
	
	public function getDependentMSPPHN($patId)
	{
		$query = "SELECT OHIP FROM ecpatmaster WHERE PAT_ID = ".$patId;
		$res = DB::select($query);
		
		if($row=json_decode(json_encode((array) $res), true)[0]){
			return $row['OHIP'];
		}
		return "";

	}
	
	public function getNameVerify($firstName,$lastName)
	{
		$initial = substr($firstName,0,1);
		$lastTwo = substr($lastName,0,2);
		return $initial.' '.$lastTwo;
	}
	
	public function getFileSequenceNumber($month)
	{
		$query = "SELECT * FROM ecuniqueohipsequence ECUS";
		$res = DB::select($query);
		
		if(count($res) == 0){
			$query = "INSERT INTO ecuniqueohipsequence(`id`,`sequencenumber`,`updatedmonth`)VALUES(1,1,".$month.")";
			DB::select($query);
		}else{
			$query = "SELECT `sequencenumber` FROM ecuniqueohipsequence ECUS WHERE id = 1";
			$res = DB::select($query);
			$row = json_decode(json_encode((array) $res), true);
			if($row[0]['sequencenumber'] >= 999){
				$update = "UPDATE ecuniqueohipsequence SET `sequencenumber` = 1,`updatedmonth` = ".$month." WHERE id = 1";
				DB::select($update);
			}else{
				$update = "UPDATE ecuniqueohipsequence SET `sequencenumber` = `sequencenumber`+1 WHERE id = 1";
				DB::select($update);
			}
		}
		$query = "SELECT sequencenumber FROM ecuniqueohipsequence ECUS WHERE id = 1";
		$res = DB::select($query);
		$row = json_decode(json_encode((array) $res), true);
		return $row[0]['sequencenumber'];
	
	}
	
	/////////////////////////////// To save MRI file history ///////////////////////////
	public function saveMRIHistory($fileName,$userId,$doctorId,$currentDate){
	
		$query = "INSERT INTO `ecmrifilehistory`
					(
					`fileName`,
					`downloadedBy`,
					`doctorId`,
					`downloadedDate`)
					VALUES
					(
					'".$fileName."',
					'".$userId."',
					'".$doctorId."',
					'".$currentDate."')";
					
		DB::select($query);
	}


}
?>