<?php
namespace App\Http\ASCIIBC;

use App\Models\Ecpatientbilling;
use Carbon\Carbon;
use DB;

class ASCIIFileCompiler
{
	
	
	var $errorCollection="";
	
	//////////////////////////////////    To get Ascii file name //////////////////////////////////////
	public function getAsciiFileName($healthcareProvider,$sequenceNumber)
	{
		//Format
		//HA123456.001
		$processCycle = $this -> getCurrentProcessingCycle();
		$healthcareProviderNumber = $this ->getHealthcareProviderNo($healthcareProvider);
		$sequenceNumber = $this ->getSequenceNo($sequenceNumber);
		$fileName = "H".$processCycle.$healthcareProviderNumber."_".$sequenceNumber;
		return $fileName;
	}
	
	public function getCurrentMonth()
	{
		return Carbon::now()->month;
	}
	
	public function getCurrentProcessingCycle()
	{
		$asciiStart = 65; // ascii for 'A'
		$month = $this->getCurrentMonth()-1;
		return chr($asciiStart+$month);
	}
	
	public function getHealthcareProviderNo($healthcareProvider)
	{
		if($healthcareProvider != "" && strlen($healthcareProvider) == 5){
			return $healthcareProvider;
		}
		$this->errorCollection .= $this->getErrorTag("FileName Error","HealthcareProvider mismatch",$healthcareProvider,"5digits needed");
		
		return "00000"; // for undifined providers
	}
	
	public function getSequenceNo($sequenceNumber)
	{
		// each file has different file names if we submit more than one ascii files by the same time
		if($sequenceNumber == ""){
			$this->errorCollection .= $this->getErrorTag("FileName Error","Sequence Number is Empty",$sequenceNumber,"Atleast 1 digit needed");
		}
		return str_pad($sequenceNumber,3,'0',STR_PAD_LEFT);

	}
	
	
	/////////////////////////////////////////////////////////////////////////////////
	
	
	/////////////////////  To get Batch Header Record   ////////////////////////////
	
	public function getBatchHeaderRecord($batchHeaderVo)
	{
		
		$headerRecord = "VS1";  // First 3 letters
		
		$dataCentreNumber = $batchHeaderVo -> dataCentreNumber;
		
		if($dataCentreNumber == "" || strlen($dataCentreNumber) != 5){
			$this->errorCollection .= $this->getErrorTag("Vendor Submission Identification Record Error","Data Centre Number not valid",$dataCentreNumber,"5 digits needed");
		}
		$dataCentreNumber = str_pad($dataCentreNumber,5," ");
		$headerRecord .= $dataCentreNumber;

		$DCNseqNumber = $batchHeaderVo -> DCNseqNumber;
		
		if($DCNseqNumber == "" || strlen($DCNseqNumber) != 7){
			$this->errorCollection .= $this->getErrorTag("Vendor Submission Identification Record Error","Data Centre seq Number not valid",$DCNseqNumber,"7 digits needed");
		}
		$headerRecord .= $DCNseqNumber;
		
		
		$docDataCentreNumber = $batchHeaderVo -> docDataCentreNumber;
		
		if($docDataCentreNumber == "" || strlen($docDataCentreNumber) != 5){
			$this->errorCollection .= $this->getErrorTag("Vendor Submission Identification Record Error","Doctor Data Centre Number not valid",$docDataCentreNumber,"5 digits needed");
		}
		$docDataCentreNumber = str_pad($docDataCentreNumber,5," ");
		$headerRecord .= $docDataCentreNumber;
		
		
		$softwareName = strtoupper($batchHeaderVo -> softwareName);
		if($softwareName == ""){
			$this->errorCollection .= $this->getErrorTag("Vendor Submission Identification Record Error","software Name not valid",$softwareName,"Need Software Name");
		}
		$softwareName = str_pad($softwareName,25," ");
		$headerRecord .= $softwareName;
		
		
		$softwareVersion = strtoupper($batchHeaderVo -> softwareVersion);
		if($softwareVersion == ""){
			$this->errorCollection .= $this->getErrorTag("Vendor Submission Identification Record Error","software Version not valid",$softwareVersion,"Need softwareVersion");
		}
		$softwareVersion = str_pad($softwareVersion,10," ");
		$headerRecord .= $softwareVersion;
		
		
		$softwareInstallDate = $batchHeaderVo -> softwareInstallDate;
		if($softwareInstallDate == "" || strlen($softwareInstallDate) != 8){
			$this->errorCollection .= $this->getErrorTag("Vendor Submission Identification Record Error","software InstallDate not valid",$softwareInstallDate,"Need software InstallDate");
		}
		$headerRecord .= $softwareInstallDate;
		
		
		$vendorCompanyName = strtoupper($batchHeaderVo -> vendorCompanyName);
		if($vendorCompanyName == ""){
			$this->errorCollection .= $this->getErrorTag("Vendor Submission Identification Record Error","vendor CompanyName not valid",$vendorCompanyName,"Need vendor Company Name");
		}
		$vendorCompanyName = str_pad($vendorCompanyName,40," ");
		$headerRecord .= $vendorCompanyName;
		
		
		$vendorContact = $batchHeaderVo -> vendorContact;
		if($vendorContact == ""){
			$this->errorCollection .= $this->getErrorTag("Vendor Submission Identification Record Error","vendor Contact not valid",$vendorContact,"Need vendor Contact");
		}
		$vendorContact = str_pad($vendorContact,15," ");
		$headerRecord .= $vendorContact;
		
		
		if(strlen($batchHeaderVo ->vendorContactName) != 25){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","vendor Contact Name not valid",$batchHeaderVo ->vendorContactName,"Need Contact Name or 25 spaces needed");
		}
	    $headerRecord .= $batchHeaderVo ->vendorContactName;
		

		if(strlen($batchHeaderVo ->filler) != 57){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","Spaces not valid for filler",$batchHeaderVo ->filler,"57 spaces needed");
		}
	    $headerRecord .= $batchHeaderVo ->filler;
		
		return $headerRecord;
		
	}
	
	//////////////////////////////////////////////////////////////////////////////////
	
	
	
	
	
	////////////////////////////// To get item record //////////////////////////////////
	
	public function getItemRecord($itemRecordVO)
	{
	
			$itemRecord = "C02";
			
			$dataCentreNumber = $itemRecordVO -> dataCentreNumber;
			if(strlen($dataCentreNumber) != 5){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Data Centre Number is invalid",
				$dataCentreNumber,"5 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $dataCentreNumber;
			
			$DCNseqNumber = $itemRecordVO -> DCNseqNumber;
			if(strlen($DCNseqNumber) != 7){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Data Centre Seq Number is invalid",
				$DCNseqNumber,"7 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $DCNseqNumber;
			
			$payeeNumber = $itemRecordVO -> payeeNumber;
			if(strlen($payeeNumber) != 5){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","payee Number is invalid",
				$payeeNumber,"5 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $payeeNumber;
			
			$practitionerNumber = $itemRecordVO -> practitionerNumber;
			if(strlen($practitionerNumber) != 5){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","practitioner Number is invalid",
				$practitionerNumber,"5 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $practitionerNumber;	
			
			$MSPPHNNumber = str_replace('-','',$itemRecordVO -> MSPPHNNumber);
			if(strlen($MSPPHNNumber) != 10){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","MSP PHN Number is invalid",
				$MSPPHNNumber,"Only 10 digits",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $MSPPHNNumber;	
			
			$nameVerfiy = strtoupper($itemRecordVO -> nameVerfiy);
			if(strlen($nameVerfiy) != 4 || $nameVerfiy == "    " || $nameVerfiy == ""){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Patient Name is invalid",
				$nameVerfiy,"First and Last Name needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $nameVerfiy;	
			
			
			$dependentNumber = $itemRecordVO -> dependentNumber;
			if(strlen($dependentNumber) != 2){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Dependent Number is invalid",
				$dependentNumber,"First and Last Name needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $dependentNumber;						
			
			$billedSRVUnits = $itemRecordVO -> billedSRVUnits;
			if(strlen($billedSRVUnits) != 3){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Billed SRV Units is invalid",
				$billedSRVUnits,"3 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $billedSRVUnits;	
			
			
			$serviceClariCode = $itemRecordVO -> serviceClariCode;
			if(strlen($serviceClariCode) != 2){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","SCC is invalid",
				$serviceClariCode,"2 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $serviceClariCode;
			
			$MSPServiceAnatomiArea = $itemRecordVO -> MSPServiceAnatomiArea;
			if(strlen($MSPServiceAnatomiArea) != 2){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","MSP Service Anatomical Area is invalid",
				$MSPServiceAnatomiArea,"2 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $MSPServiceAnatomiArea;
			

			$afterHourServiceInd = $itemRecordVO -> afterHourServiceInd;
			if(strlen($afterHourServiceInd) != 1){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","After Hour Service Indicator is invalid",
				$afterHourServiceInd,"1 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $afterHourServiceInd;
			

			$newProgInd = $itemRecordVO -> newProgInd;
			if(strlen($newProgInd) != 2){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","New Program Indicator is invalid",
				$newProgInd,"2 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $newProgInd;
			

			$billedFeeItem = str_pad($itemRecordVO -> billedFeeItem,5,"0",STR_PAD_LEFT);
			if(strlen($billedFeeItem) != 5 || $billedFeeItem == '00000'){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Billed Fee Item is invalid",
				$billedFeeItem,"5 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $billedFeeItem;
			
			$billedAmount = str_pad($itemRecordVO -> billedAmount,7,"0",STR_PAD_LEFT);
			if(strlen($billedAmount) != 7){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Billed Amount is invalid",
				$billedAmount,"7 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $billedAmount;																											

					
			$paymentMode = $itemRecordVO -> paymentMode;
			$itemRecord .= $paymentMode;
			
			
			$serviceDate = $itemRecordVO -> serviceDate;
			if(strlen($serviceDate) != 8){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Service is invalid",
				$serviceDate,"8 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $serviceDate;
			
			
			$serviceToDay = $itemRecordVO -> serviceToDay;
			$itemRecord .= $serviceToDay;
			
			
			$submissionCode = strtoupper($itemRecordVO -> submissionCode);
			if(strlen($submissionCode) != 1){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Submission code is invalid",
				$submissionCode,"1 digit needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $submissionCode;

						
			$extendedSubCode = $itemRecordVO -> extendedSubCode;
			$itemRecord .= $extendedSubCode;
			
			
			$diagnosticCode1 = str_pad($itemRecordVO -> diagnosticCode1,5,' ');
			$diagnosticCode1 = strtoupper($diagnosticCode1);
			if(strlen($diagnosticCode1) != 5){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Diagnostic Code is invalid",
				$diagnosticCode1,"5 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $diagnosticCode1;

			$diagnosticCode2 = $itemRecordVO -> diagnosticCode2;
			$itemRecord .= $diagnosticCode2;

			$diagnosticCode3 = $itemRecordVO -> diagnosticCode3;
			$itemRecord .= $diagnosticCode3;

			$diagnosticExp = $itemRecordVO -> diagnosticExp;
			$itemRecord .= $diagnosticExp;
			
			
			$serviceLocationCD = $itemRecordVO -> serviceLocationCD;
			if(strlen($serviceLocationCD) != 1){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","service Location CD is invalid",
				$serviceLocationCD,"1 digit needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $serviceLocationCD;

			$refPract1CD = $itemRecordVO -> refPract1CD;
			if(strlen($refPract1CD) != 1){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Ref Practitioner CD is invalid",
				$refPract1CD,"1 digit needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $refPract1CD;
			
			
			$refPract1Number = $itemRecordVO -> refPract1Number;
			if(strlen($refPract1Number) != 5){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Ref Practitioner Number is invalid",
				$refPract1Number,"5 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $refPract1Number;
			
			$refPract2CD = $itemRecordVO -> refPract2CD;
			if(strlen($refPract2CD) != 1){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Ref To Practitioner CD is invalid",
				$refPract2CD,"1 digit needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $refPract2CD;
			
			
			$refPract2Number = $itemRecordVO -> refPract2Number;
			if(strlen($refPract2Number) != 5){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Ref To Practitioner Number is invalid",
				$refPract2Number,"5 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $refPract2Number;
			
			$timeCallRECVD = $itemRecordVO -> timeCallRECVD;
			$itemRecord .= $timeCallRECVD;

			$serviceTimeStart = $itemRecordVO -> serviceTimeStart;
			$itemRecord .= $serviceTimeStart;
			
			$serviceTimeFinish = $itemRecordVO -> serviceTimeFinish;
			$itemRecord .= $serviceTimeFinish;

			$birthDate = str_pad($itemRecordVO -> birthDate,8,"0",STR_PAD_LEFT);
			if(strlen($birthDate) != 8){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","DOB is invalid",
				$birthDate,"8 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $birthDate;			

			$officeFolioNumber = $itemRecordVO -> officeFolioNumber;
			$itemRecord .= $officeFolioNumber;

			$correspondenceCode = $itemRecordVO -> correspondenceCode;
			$itemRecord .= $correspondenceCode;

			$claimShortComment = strtoupper($itemRecordVO -> claimShortComment);
			if(strlen($claimShortComment) != 20){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","Claim Short Comment is invalid",
				$claimShortComment,"20 digits only",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $claimShortComment;
			

			$MVAClaimCode = $itemRecordVO -> MVAClaimCode;
			if(strlen($MVAClaimCode) != 1){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","MVA Code is invalid",
				$MVAClaimCode,"1 digit needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $MVAClaimCode;
			

			$ICBCClaimNumber = $itemRecordVO -> ICBCClaimNumber;
			/// for icbc claim
			if($itemRecordVO -> submissionCode == 'I'){
				if(strlen($ICBCClaimNumber) != 8){
					$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","ICBC ClaimNumber is invalid",
					$ICBCClaimNumber,"8 digit needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
				}
			}
			//////
			$itemRecord .= $ICBCClaimNumber;
			
			$originalMSPFileNumber = str_pad($itemRecordVO -> originalMSPFileNumber,20,"0");
			$itemRecord .= $originalMSPFileNumber;

			$facilityNumber = $itemRecordVO -> facilityNumber;
			$itemRecord .= $facilityNumber;

			$facilitySubNumber = $itemRecordVO -> facilitySubNumber;
			$itemRecord .= $facilitySubNumber;

			$filler = $itemRecordVO -> filler;
			$itemRecord .= $filler;

			$OINInsurerCode = strtoupper($itemRecordVO -> OINInsurerCode);
			if(strlen($OINInsurerCode) != 2){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","OIN Insurer Code is invalid",
				$OINInsurerCode,"2 digit needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}			
			$itemRecord .= $OINInsurerCode;
			
			$OINRegNumber = str_replace('-','',$itemRecordVO -> OINRegNumber);
			if(strlen($OINRegNumber) != 12){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","OIN Registration# is invalid",
				$OINRegNumber,"12 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}			
			$itemRecord .= $OINRegNumber;

			$OINBirthDate = $itemRecordVO -> OINBirthDate;
			$itemRecord .= $OINBirthDate;

			$OINFirstName = str_pad($itemRecordVO -> OINFirstName,12," ");
			if(strlen($OINFirstName) > 12){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","OIN Patient First name is invalid",
				$OINFirstName,"Maximum 12 digits",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= strtoupper($OINFirstName);

			$OINSecondName = $itemRecordVO -> OINSecondName;
			$itemRecord .= $OINSecondName;

			$OINSurname = str_pad($itemRecordVO -> OINSurname,18," ");
			if(strlen($OINSurname) > 18){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","OIN Patient Last name is invalid",
				$OINSurname,"Maximum 18 digits",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= strtoupper($OINSurname);

			$OINSex = strtoupper($itemRecordVO -> OINSex);
			if(strlen($OINSex) != 1){
				$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","OIN Gender is invalid",
				$OINSex,"1 digit needed(M or F)",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			$itemRecord .= $OINSex;


			
			/// For optedout 
			if($itemRecordVO -> OINInsurerCode == 'PP'){
				$OINAddress1 = strtoupper(trim($itemRecordVO -> OINAddress1));
				if(strlen($OINAddress1) < 6){
					$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","OIN Address1 is invalid",
					$OINAddress1,"more than 5 letters needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
				}
				if(strlen($OINAddress1) > 100){
					$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","OIN Address is too long",
					$OINAddress1,"100 letters only allowed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
				}
				
				$OINAddress1 = str_pad($OINAddress1,100," ");
				$itemRecord .= $OINAddress1;
				
			}
			/// For wsbc
			if($itemRecordVO -> OINInsurerCode == 'WC'){
				$OINAddress1 = strtoupper($itemRecordVO -> OINAddress1);
				$OINAddress1 = str_pad($OINAddress1,25," ");
				$itemRecord .= $OINAddress1;
	
				$OINAddress2 = strtoupper($itemRecordVO -> OINAddress2);
				$OINAddress2 = str_pad($OINAddress2,25," ");
				$itemRecord .= $OINAddress2;
	
				$OINAddress3 = strtoupper($itemRecordVO -> OINAddress3);
				$OINAddress3 = str_pad($OINAddress3,25," ");
				$itemRecord .= $OINAddress3;
	
				$OINAddress4 = strtoupper($itemRecordVO -> OINAddress4);
				$OINAddress4 = str_pad($OINAddress4,25," ");
				$itemRecord .= $OINAddress4;				
			}
			
			$OINPostalCode = strtoupper($itemRecordVO -> OINPostalCode);

			///// For optedout 
			if($itemRecordVO -> OINInsurerCode == 'PP'){
				if(strlen($OINPostalCode) != 6){
					$this->errorCollection .= $this->getErrorTag("Claim Detail Record Error","OIN PostalCode is invalid",
					$OINPostalCode,"6 digits needed (ANANAN)",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
				}
			}
			$OINPostalCode = str_pad($OINPostalCode,6," ");
			$itemRecord .= $OINPostalCode;

			//////////// for note record ////////////////
			if($itemRecordVO -> submissionCode == 'E' && $itemRecordVO -> correspondenceCode != "N"){
				$this->errorCollection .= $this->getErrorTag("Note Record Error","Note Data Line is invalid",
					$submissionCode,"Some comments needed if submission code is E. maximum 400 letters",
					$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
			}
			if($itemRecordVO -> correspondenceCode == "N"){
				$itemRecord .= "\r\n";
				$itemRecord .= "N01";
				$itemRecord .= $dataCentreNumber;
				
				$noteDCNseqNumber = $itemRecordVO -> noteDCNseqNumber;
				if(strlen($noteDCNseqNumber) != 7){
					$this->errorCollection .= $this->getErrorTag("Note Record Error","Data Centre Seq Number is invalid",
					$noteDCNseqNumber,"7 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
				}
				$itemRecord .= $noteDCNseqNumber;
				
				$itemRecord .= $payeeNumber;
				$itemRecord .= $practitionerNumber;					
				$noteDataType = $itemRecordVO -> noteDataType;
				$itemRecord .= $noteDataType;
				$noteDataLine = str_pad(strtoupper($itemRecordVO -> noteDataLine),400," ");
				if(strlen($noteDataLine) != 400){
					$this->errorCollection .= $this->getErrorTag("Note Record Error","Note Data Line is invalid",
					$noteDataLine,"Some comments needed maximum 400 letters",$itemRecordVO->OHIPItemId,$itemRecordVO->patientName);
				}
				$itemRecord .= $noteDataLine;			
			}
			/////////////////////////////////////////////
			
			return $itemRecord;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////
	
	
	
	
	///////////////////////////////////// To save error values /////////////////////////
	
	public function getErrorTag($error,$errorDescription,$currentValue,$expectingFormat,$ohipItemId=-1,$patName='')
	{
		$errorTag = "<errorTag>";
		$errorTag .= "<error>".$error."</error>";
		$errorTag .= "<errorDescription>".$errorDescription."</errorDescription>";
		$errorTag .= "<currentValue>".$currentValue."</currentValue>";				
		$errorTag .= "<expectingFormat>".$expectingFormat."</expectingFormat>";	
		$errorTag .= "<ohipItemId>".$ohipItemId."</ohipItemId>";
		$errorTag .= "<patientName>".$patName."</patientName>";
		$errorTag .= "</errorTag>";
		return $errorTag;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////
}
?>