<?php
namespace App\Http\ASCII;

class RejectionASCIIFileCompiler
{
	var $errorCollection="";
	var $rejectMROCollection="";
	
	public function getMRORecord($filenameFlag,$fileContent)
	{
		if($filenameFlag == "X"){
			$rejectMROCollection = $this->getEntireFileRejectRecord($fileContent);
		}
		else if($filenameFlag == "B"){
			$rejectMROCollection = $this->getBatchRejectRecord($fileContent);
		}
		else if($filenameFlag == "E" || $filenameFlag == "F"){
			$rejectMROCollection = $this->getClaimRejectRecord($fileContent);
		}
		else{
			$rejectMROCollection = "<error>File format not supported.</error>";
		}
		
		return $rejectMROCollection;
	}
	
	
	/**
	** Entire file rejection type
	**/
	
	public function getEntireFileRejectRecord($fileContent){
		$mroCollection = "";
		$startCharPos = 0;
		$endCharPos = 118;  // each line has 118 chars
		
		
		/// check valid file contents and check the provider is in system
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "M01"){
			// can do for provider check
		}else{
			return "<error>Invalid file content</error>";
		}
		
		
		$mroCollection = "<MRO>";
		// file Header
			$mroCollection .= $this->getFileHeaderEntireRejection();
		
		// Rejection reason
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "M01"){
			// firstline info
			$firstLine = substr($fileContent,$startCharPos,$endCharPos);
			$firstInfoEntireRejection = $this->getFirstInfoEntireRejection($firstLine);
			$mroCollection .= $firstInfoEntireRejection;
		}
		
		$startCharPos += 120;  // 120 is the length of the each line includin \n actual length is 118
		
		// second line info
		
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "M02"){
			$secondLine = substr($fileContent,$startCharPos,$endCharPos);
			$secondInfoEntireRejection = $this->getSecondInfoEntireRejection($secondLine);
			$mroCollection .= $secondInfoEntireRejection;
		}
		
		$mroCollection .= "</MRO>";	
		
		return $mroCollection;	
	}
	
	public function getFirstInfoEntireRejection($firstLine)
	{
		$firstInfoXML = "<firstInfo>";
		$firstInfoXML .= "<reason>".substr($firstLine,3,20)."</reason>";
		$firstInfoXML .= "<submitedRecLen>".substr($firstLine,23,5)."</submitedRecLen>";
		$firstInfoXML .= "<recordImage>".substr($firstLine,39,37)."</recordImage>";
		$firstInfoXML .= "</firstInfo>";
		return $firstInfoXML;
	}
	
	public function getSecondInfoEntireRejection($secondLine)
	{
		$secondInfoXML = "<secondInfo>";
		$secondInfoXML .= "<providerFileName>".substr($secondLine,8,12)."</providerFileName>";
		$secondInfoXML .= "<dateUploadedEDT>".substr($secondLine,25,4)."-".substr($secondLine,29,2)."-".substr($secondLine,31,2)."</dateUploadedEDT>";
		$secondInfoXML .= "<processDate>".substr($secondLine,50,4)."-".substr($secondLine,54,2)."-".substr($secondLine,56,2)."</processDate>";
		$secondInfoXML .= "</secondInfo>";
		return $secondInfoXML;
		
	}
	public function getFileHeaderEntireRejection()
	{
		$headerXML = "<fileHeader>";
		$headerXML .= "<fileType>Entire File Rejection</fileType>";		
		$headerXML .= "</fileHeader>";
		return $headerXML;
	}	
	
	////////////////////////////////////
	
	/****
	**  Batch rejection type
	****/
	
	public function getBatchRejectRecord($fileContent){
		$mroCollection = "";
		$startCharPos = 0;
		$endCharPos = 132;  // each line has 132 chars
		
		
		/// check valid file contents and check the provider is in system
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HB1"){
				//can do for provider check
		}else{
			return "<error>Invalid file content</error>";
		}
		
		
		$mroCollection = "<MRO>";
		// file Header
			$mroCollection .= $this->getFileHeaderBatchRejection();
		
		// Rejection information
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HB1"){
			// info
			$firstLine = substr($fileContent,$startCharPos,$endCharPos);
			$infoBatchRejection = $this->getInfoBatchRejection($firstLine);
			$mroCollection .= $infoBatchRejection;
		}
		$mroCollection .= "</MRO>";	
		
		return $mroCollection;	
	}	
	
	
	private function getFileHeaderBatchRejection()
	{
		$headerXML = "<fileHeader>";
		$headerXML .= "<fileType>Batch Rejection</fileType>";		
		$headerXML .= "</fileHeader>";
		return $headerXML;
	
	}
	
	public function getInfoBatchRejection($firstLine)
	{
		$firstInfoXML = "<info>";
		$firstInfoXML .= "<batchNumber>".substr($firstLine,6,5)."</batchNumber>";
		$firstInfoXML .= "<operatorNumber>".substr($firstLine,11,6)."</operatorNumber>";
		$firstInfoXML .= "<batchCreatedDate>".substr($firstLine,17,4)."-".substr($firstLine,21,2)."-".substr($firstLine,23,2)."</batchCreatedDate>";
		$firstInfoXML .= "<batchSequenceNo>".substr($firstLine,25,4)."</batchSequenceNo>";
		$firstInfoXML .= "<microStart>".substr($firstLine,29,11)."</microStart>";
		$firstInfoXML .= "<microEnd>".substr($firstLine,40,5)."</microEnd>";
		$firstInfoXML .= "<groupNo>".substr($firstLine,52,4)."</groupNo>";
		$firstInfoXML .= "<providerNo>".substr($firstLine,56,6)."</providerNo>";
		$firstInfoXML .= "<numberOfClaims>".substr($firstLine,62,5)."</numberOfClaims>";
		$firstInfoXML .= "<numberOfRecs>".substr($firstLine,67,6)."</numberOfRecs>";
		$firstInfoXML .= "<batchProcessDate>".substr($firstLine,73,4)."-".substr($firstLine,77,2)."-".substr($firstLine,79,2)."</batchProcessDate>";
		$firstInfoXML .= "<editMessage>".substr($firstLine,81,40)."</editMessage>";
		
		$firstInfoXML .= "</info>";
		return $firstInfoXML;
	}	
	///////////////////////////////////
	
	/****
	**  Claim rejection type
	****/
	
	public function getClaimRejectRecord($fileContent){
		$mroCollection = "";
		$healthProvider = "";
		$specialityCode = "";
		$startCharPos = 0;
		$endCharPos = 79;  // each line has 79 chars

		/// check valid file contents and check the provider is in system
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HX1"){
			$headerLine = substr($fileContent,$startCharPos,$endCharPos);
			if(!$this->checkProviderFile($headerLine))
			{
				return "<error>File error or this file hasn't valid provider</error>";
			}
		}else{
			return "<error>Invalid file content</error>";
		}
		
		
		$mroCollection = "<MRO>";
		// file Header
		while(1){
			if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HX1"){

				$headerLine = substr($fileContent,$startCharPos,$endCharPos);
				$healthProvider = substr($headerLine,27,6);		
				$specialityCode = substr($headerLine,33,6);		
				$fileHeader = $this->getFileHeader($headerLine);
				$mroCollection .= $fileHeader;
			}
			
			$startCharPos += 81;  // 81 is the length of the each line includin \n actual length is 79
			
			//Claim header records
			$mroCollection .= "<claims>";

			while(1){
				if(strlen($fileContent) >= $startCharPos && substr($fileContent,$startCharPos,3) == "HXH"){
					$claimHeader = substr($fileContent,$startCharPos,$endCharPos);
					$isProviderClaim = false;
					$claimHeaderRecord = "<claimHeader>";
					$claimHeaderRecord .= $this->getClaimHeaderRecord($claimHeader,$healthProvider,$specialityCode);
					$startCharPos += 81;
					
					while(1){
						if(strlen($fileContent) >= $startCharPos && substr($fileContent,$startCharPos,3) == "HXT"){
							$claimItem = substr($fileContent,$startCharPos,$endCharPos);
							if($this->checkProviderClaim($claimHeader,$claimItem)){
								$isProviderClaim = true;
								$claimHeaderRecord .= "<claimItem>";
								$claimHeaderRecord .= $this->getClaimItemRecord($claimItem,$claimHeader);
								$claimHeaderRecord .= "</claimItem>";
								if($startCharPos > strlen($fileContent)){
									break;
								}
							}
						}
						else if(strlen($fileContent) >= $startCharPos && substr($fileContent,$startCharPos,3) == "HXR"){
							/// To do if need the HXR in header record
						}
						else if(strlen($fileContent) >= $startCharPos && substr($fileContent,$startCharPos,3) == "HX8"){
							/// To do if need the HX8 reason in seperate collection
						}
						else{
							break;
						}
						$startCharPos += 81;
						
					}
					$claimHeaderRecord .= "</claimHeader>";
					
					
					if($isProviderClaim == true){
						$mroCollection .= $claimHeaderRecord;		
					}
					
					if($startCharPos > strlen($fileContent)){
						break;
					}
		
				}
				else{
					break;
				}
			
			}
			
			
			$mroCollection .= "</claims>";

			if($startCharPos > strlen($fileContent)){
				break;
			}
			$startCharPos += 81;
		}
		
		
		$mroCollection .= "</MRO>";	

		return $mroCollection;
	}
	
	public function getFileHeader($headerLine)
	{
		$healthProvider = substr($headerLine,27,6);
		$headerXML = "<fileHeader>";
		$headerXML .= "<fileType>Claim Rejection type</fileType>";		
		$headerXML .= "<healthcareProvider>".substr($headerLine,27,6)."</healthcareProvider>";
		$headerXML .= "<speciality>".substr($headerLine,33,2)."</speciality>";
		$headerXML .= "<mohOfficeCode>".substr($headerLine,6,1)."</mohOfficeCode>";
		$headerXML .= "<paymentDate>".substr($headerLine,38,8)."</paymentDate>";
		$headerXML .= "<payeeName></payeeName>";
		// total amount even the record is not in our provider
		$headerXML .= "<totalAmount></totalAmount>"; 
		$headerXML .= "<negativeSign></negativeSign>";
		$headerXML .= "<chequeNumber></chequeNumber>";
		
		$rejectionASCIIFileDBHelper = new RejectionASCIIFileDBHelper();
		$doctorXml = $rejectionASCIIFileDBHelper -> getDoctorDetailsByProvider($healthProvider);
		$headerXML	.= $doctorXml;
		
		$headerXML .= "</fileHeader>";
		return $headerXML;
	}
	
	public function getClaimHeaderRecord($claimHeader,$healthProvider,$specialityCode)
	{
		$healthcardNumber = substr($claimHeader,3,4)."-".substr($claimHeader,7,3)."-".substr($claimHeader,10,3)."-".substr($claimHeader,13,2);
			
		$claimHeaderXML = "<ministryRefNumber></ministryRefNumber>";
		$claimHeaderXML .= "<transactionType></transactionType>";
		$claimHeaderXML .= "<healthcareProvider>".$healthProvider."</healthcareProvider>";		
		$claimHeaderXML .= "<speciality>".$specialityCode."</speciality>";		
		$claimHeaderXML .= "<accountingNumber>".substr($claimHeader,23,8)."</accountingNumber>";		
		$claimHeaderXML .= "<patientLastName></patientLastName>";						
		$claimHeaderXML .= "<patientFirstName></patientFirstName>";								
		$claimHeaderXML .= "<province></province>";										
		$claimHeaderXML .= "<healthRegNumber>".substr($claimHeader,3,12)."</healthRegNumber>";												
		$claimHeaderXML .= "<versionCode>".substr($claimHeader,13,2)."</versionCode>";														
		$claimHeaderXML .= "<paymentProgram>".substr($claimHeader,31,3)."</paymentProgram>";														
		$claimHeaderXML .= "<serviceLocation>".substr($claimHeader,57,4)."</serviceLocation>";														
		$claimHeaderXML .= "<mohGroupId></mohGroupId>";	
		

		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$patXml = $mroAsciiFileDBHelper -> getPatientDetailsByCard($healthcardNumber);
		$claimHeaderXML	.= $patXml;
		
		$doctorXml = $mroAsciiFileDBHelper -> getDoctorDetailsByProvider($healthProvider);
		$claimHeaderXML	.= $doctorXml;
		
		return $claimHeaderXML;
	}
	
	public function getClaimItemRecord($claimItem,$claimHeader)
	{
		$rejectionASCIIFileDBHelper = new RejectionASCIIFileDBHelper();
		$claimItemXML  = "<ministryRefnumber></ministryRefnumber>";														
		$claimItemXML .= "<transactionType></transactionType>";														
		$claimItemXML .= "<serviceDate>".substr($claimItem,18,8)."</serviceDate>";														
		$claimItemXML .= "<noservices>".substr($claimItem,16,2)."</noservices>";														
		$claimItemXML .= "<serviceCode>".substr($claimItem,3,5)."</serviceCode>";														
		$claimItemXML .= "<submitedAmount>".$rejectionASCIIFileDBHelper -> getAmountByAccNumber(substr($claimHeader,23,8))."</submitedAmount>";														
		$claimItemXML .= "<amountPaid>0000.00</amountPaid>";														
		$claimItemXML .= "<negativeSign></negativeSign>";
		$claimItemXML .= "<explanatoryCode>".trim(substr($claimItem,62,2))."</explanatoryCode>";	

		$reasonXml = $rejectionASCIIFileDBHelper -> getRemittanceAdviceReason(substr($claimItem,62,2));
		$claimItemXML.= $reasonXml;
		
		$errorCode = array();
		
		
		//from header
		$errorPos = 64;
		for($headi=0;$headi<5;$headi++){
			$errData = substr($claimHeader,$errorPos,3);
			if($errData != "   " && $errData != ""){
				$errorCode[] = "'".$errData."'";
			}
			$errorPos += 3;		
		}
		
		// from item
		$errorPos = 64;
		$itemi = 0;
		
		for($itemi=0;$itemi<5;$itemi++){
			$errData = substr($claimItem,$errorPos,3);
			if($errData != "" && $errData != "   "){
				$errorCode[] = "'".$errData."'";
			}
			$errorPos += 3;		
		}		
		
		$claimItemXML.= "<explanatoryForErrors>".implode(',',$errorCode)."</explanatoryForErrors>";
		$errorCollection = $rejectionASCIIFileDBHelper -> getErrorCodeReasons($errorCode);
		$claimItemXML.= "<errors>".$errorCollection."</errors>";
		
		
		return $claimItemXML;
	}
	
	
	public function checkProviderClaim($claimHeader,$claimItem)
	{
		$healthcardNumber = substr($claimHeader,3,4)."-".substr($claimHeader,7,3)."-".substr($claimHeader,10,3)."-".substr($claimHeader,13,2);
		$accountingNumber = substr($claimHeader,23,8);
		$serviceDate = substr($claimItem,18,4).'-'.substr($claimItem,22,2).'-'.substr($claimItem,24,2);
		$rejectionASCIIFileDBHelper = new RejectionASCIIFileDBHelper();
		$isOwnRecord = $rejectionASCIIFileDBHelper -> checkProviderClaim($accountingNumber,$serviceDate,$healthcardNumber);
		return $isOwnRecord;
				
	}
	
	public function checkProviderFile($headerLine)
	{
		$healthcareProvider = substr($headerLine,27,6);
		$speciality = substr($headerLine,33,2);
		$mohOfficeCode = substr($headerLine,6,1);

		$rejectionAsciiFileDBHelper = new RejectionASCIIFileDBHelper();
		$isOwnRecord = $rejectionAsciiFileDBHelper -> checkProviderFile($healthcareProvider,$speciality,$mohOfficeCode);
		return $isOwnRecord;
		
	}
	
	//////////////////////////////////	
	
}
?>