<?php
namespace App\Http\ASCII;
use App\Http\ASCII\OHIPStatusHistory;
use App\Models\ecpatientbilling;
use Carbon\Carbon;
use DB;

class MROASCIIFileDBHelper
{

	public function getDoctorDetailsByProvider($provider)
	{
		$query = "SELECT * FROM ecusers where ohipRegNum = '".$provider."'";
		
		$providerNumber ="";					
		
		$res = DB::select($query);
		
		$doctorDetails = "<doctor>";
		if($row = json_decode(json_encode((array) $res), true)[0])
		{
			$doctorDetails .= "<name>".stripslashes($row['FIRST_NAME'])." ".stripslashes($row['LAST_NAME'])."</name>";
			$doctorDetails .= "<id>".$row['USERID']."</id>";
		}
		$doctorDetails .= "</doctor>";		
		return $doctorDetails;
		
	}
	public function getPatientDetailsByCard($healthcardNumber)
	{
		$query = "SELECT PAT_ID,FIRST_NAME,LAST_NAME FROM ecpatmaster where OHIP = '".$healthcardNumber."'";
		
		$providerNumber ="";					
		
		$res = DB::select($query);
		
		$doctorDetails = "<patient>";
		if($row = json_decode(json_encode((array) $res), true))
		{
			$doctorDetails .= "<name>".stripslashes($row[0]['FIRST_NAME'])." ".stripslashes($row[0]['LAST_NAME'])."</name>";
			$doctorDetails .= "<id>".$row[0]['PAT_ID']."</id>";
		}
		$doctorDetails .= "</patient>";		
		return $doctorDetails;

	}	
	
	public function getRemittanceAdviceReason($code){
		$query = "SELECT * FROM ecremittanceadvicecodes WHERE code = '".$code."'";
		
		$res = DB::select($query);
		$reason = "<reason>";
		foreach(json_decode(json_encode((array) $res), true) as $row)
		{
			$reason .= $row['explanation'];
		}
		$reason .= "</reason>";		
		return $reason;
		
	}
	
	public function checkProviderClaim($accountingNumber,$serviceDate,$healthcardNumber)
	{
		$query = "SELECT id FROM ecpatientbilling ECPB 
		WHERE ECPB.accountingnumber = '".$accountingNumber."' AND date_format(ECPB.billing_date,'%Y-%m-%d') = '".$serviceDate."' 
		AND ECPB.OHIP = '".$healthcardNumber."';";
		
		$res = DB::select($query);
		
		if(count($res) > 0){
			return true;
		}else{
			return false;
		}
		
	}
	
	public function checkProviderFile($healthcareProvider,$speciality,$mohOfficeCode,$groupNumber)
	{
		$query = "SELECT ECU.ohipRegNum,ECU.licenseNumber,ECMO.claimcardid 
		FROM ecusers ECU 
		LEFT OUTER JOIN ecmohoffices ECMO ON ECU.MOH_ID = ECMO.id
		WHERE ECU.ohipRegNum = '".$healthcareProvider."' AND ECU.licenseNumber = '".$speciality."';";
		
		$res = DB::select($query);
		if(count($res) > 0){
			return true;
		}else{
			$queryGroup = "SELECT ECU.ohipRegNum,ECU.licenseNumber
						FROM ecusers ECU 
						WHERE ECU.ohip_group_number = '".$groupNumber."' AND ECU.licenseNumber = '".$speciality."';";
			
			$resGroup = DB::select($queryGroup);
			if(count($resGroup) > 0){
				return true;
			}
			return false;
		}
		
	}
	
	public function addFileUploadHistroy($fileName,$userId)
	{
		$now = Carbon::now();
		$todayTime = $now->format('Y-m-d H:i:s');
		$query = "INSERT INTO ecmrofilehistory(`fileName`,`uploadedby`,`uploadeddate`)
		VALUES('".$fileName."','".$userId."','".$todayTime."')";
		
		DB::select($query);		
			
	}
	
	public function checkMROFileExist($fileName)
	{
		$now = Carbon::now();
		$year = $now->format('Y');
		$query = "SELECT * FROM ecmrofilehistory WHERE fileName = '".$fileName."'  AND DATE_FORMAT(uploadeddate,'%Y')=".$year;
		$res = DB::select($query);	
		if(count($res) > 0){
			return "exist";
		}else{
			return "not exist";
		}
		
	}
	
	public function deleteMROFile($fileId)
	{
		$query = "DELETE FROM ecmrofilehistory WHERE `id`='".$fileId."';";
		
		$res = DB::select($query);	
		
		if($res > 0)
		{
			return "<message>Deleted Successfully</message>";
		}else{
			return "<message>Delete Failed</message>";
		}
		
	}
	
	public function proceedMROChanges($accountingNumber,$amountSubmitted,$amountPaid,$paymentDate,$status,$explanatoryCode)
	{
		$queryAlreadyPaid = "SELECT id FROM ecpatientbilling WHERE accountingnumber = '".$accountingNumber."' 
								AND ohip_status IN('FP','PP','RP','WP');";
		
		if($status != "R"){
			$query = "UPDATE ecpatientbilling SET
			`amountsubmitted` = '".$amountSubmitted."',
			`amountpaid` = '".$amountPaid."',
			`paymentdate` = '".$paymentDate."',
			`ohip_status` = '".$status."'
			WHERE `accountingnumber` = '".$accountingNumber."'";
		}else{
			$query = "UPDATE ecpatientbilling SET
			`amountsubmitted` = '".$amountSubmitted."',
			`amountpaid` = '".$amountPaid."',
			`ohip_status` = '".$status."',
			`explanatoryCode` = '".$explanatoryCode."'
			WHERE `accountingnumber` = '".$accountingNumber."'";
		}
		
		$res = DB::select($queryAlreadyPaid);	
		if(count($res) == 0){		// we have to lock the record updation if the record is already paid
			DB::select($query);
			///// add ohip status history
			$ohipStatusHistory = new OHIPStatusHistory();
			$ohipStatusHistory->addOhipHistory($accountingNumber,$status);
			////////////			
		}
		
	}

	
}