<?php
namespace App\Http\ASCII;

use App\Http\ASCII\MROASCIIFileDBHelper;

class MROASCIIFileCompiler
{
	var $errorCollection="";
	var $mroCollection="";
	
	public function getMRORecord($fileContent)
	{
		$startCharPos = 0;
		$endCharPos = 79;  // each line has 79 chars

		/// check valid file contents and check the provider is in system
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HR1"){
			$headerLine = substr($fileContent,$startCharPos,$endCharPos);
			if(!$this->checkProviderFile($headerLine))
			{
				return "<error>File error or this file hasn't valid provider</error>";
			}
		}else{
			return "<error>Invalid file content</error>";
		}
		
		
		$mroCollection = "<MRO>";
		// file Header
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HR1"){
			$headerLine = substr($fileContent,$startCharPos,81);
			$fileHeader = $this->getFileHeader($headerLine);
			$mroCollection .= $fileHeader;
		}
		
		$startCharPos += 81;  // 81 is the length of the each line includin \n actual length is 79
		$endCharPos += 81;
		
		// address record
		$mroCollection .= "<addresses>";
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HR2"){
			$addressOne = substr($fileContent,$startCharPos,81);
			$addressOneRecord = $this->getAddressOneRecord($addressOne);
			$mroCollection .= $addressOneRecord;
		}
		
		$startCharPos += 81;
		$endCharPos += 81;
		
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HR3"){
			$addressTwo = substr($fileContent,$startCharPos,81);
			$addressTwoRecord = $this->getAddressTwoRecord($addressTwo);
			$mroCollection .= $addressTwoRecord;
		}
		$mroCollection .= "</addresses>";

		
		$startCharPos += 81;
		$endCharPos += 81;
		
		//Claim header records
		$mroCollection .= "<claims>";

		while(1){
			if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HR4"){
				$claimHeader = substr($fileContent,$startCharPos,81);
				$isProviderClaim = false;
				
				
				
				$claimHeaderRecord = "<claimHeader>";
				$claimHeaderRecord .= $this->getClaimHeaderRecord($claimHeader);
				$startCharPos += 81;
				$endCharPos += 81;
				
				while(1){
					if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HR5"){
						$claimItem = substr($fileContent,$startCharPos,81);
						if($this->checkProviderClaim($claimHeader,$claimItem)){
							$isProviderClaim = true;
							$claimHeaderRecord .= "<claimItem>";
							$claimHeaderRecord .= $this->getClaimItemRecord($claimItem);
							$claimHeaderRecord .= "</claimItem>";
							if($endCharPos > strlen($fileContent)){
								break;
							}
						}
					}else{
						break;
					}
					$startCharPos += 81;
					$endCharPos += 81;
					
				}
				$claimHeaderRecord .= "</claimHeader>";
				
				
				if($isProviderClaim == true){
					$mroCollection .= $claimHeaderRecord;		
				}
				
				if($endCharPos > strlen($fileContent)){
					break;
				}
	
			}else{
				break;
			}

			
		
		}
		
		
		$mroCollection .= "</claims>";
		
		
		
		/// Balance forword record
		
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HR6"){
			$balanceForwordLine = substr($fileContent,$startCharPos,81);
			$balanceForwordRecord = $this->getBalanceForwordRecord($balanceForwordLine);
			$mroCollection .= $balanceForwordRecord;
		}
		
		$startCharPos += 81;
		$endCharPos += 81;
		
		
		/// Accounting transaction record
		
		if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HR7"){
			$accountTransactionLine = substr($fileContent,$startCharPos,81);
			$accountTransactionRecord = $this->getAccountTransactionRecord($accountTransactionLine);
			$mroCollection .= $accountTransactionRecord;
		}
		
		$startCharPos += 81;
		$endCharPos += 81;
		
		
		/// Message facility record
		$mroCollection .= "<messages>";
		while(1){
			if(strlen($fileContent) >= $endCharPos && substr($fileContent,$startCharPos,3) == "HR8"){
				$messageFacilityLine = substr($fileContent,$startCharPos,81);
				$messageFacilityRecord = $this->getMessageRecord($messageFacilityLine);
				$mroCollection .= "<![CDATA[".$messageFacilityRecord."]]>";
				$startCharPos += 81;
				$endCharPos += 81;
			}else{
				break;			
			}
			
		}
		$mroCollection .= "</messages>";
		
		$mroCollection .= "</MRO>";	
		
		return $mroCollection;
	}
	
	public function getFileHeader($headerLine)
	{
		$healthProvider = substr($headerLine,11,6);
		$headerXML = "<fileHeader>";
		$headerXML .= "<fileType>MRO</fileType>";		
		$headerXML .= "<healthcareProvider>".substr($headerLine,11,6)."</healthcareProvider>";
		$headerXML .= "<speciality>".substr($headerLine,17,2)."</speciality>";
		$headerXML .= "<mohOfficeCode>".substr($headerLine,19,1)."</mohOfficeCode>";
		$headerXML .= "<paymentDate>".substr($headerLine,21,8)."</paymentDate>";
		$headerXML .= "<payeeName>".substr($headerLine,29,30)."</payeeName>";
		// total amount even the record is not in our provider
		$headerXML .= "<totalAmount>".substr($headerLine,59,7).".".substr($headerLine,66,2)."</totalAmount>"; 
		$headerXML .= "<negativeSign>".substr($headerLine,68,1)."</negativeSign>";
		$headerXML .= "<chequeNumber>".substr($headerLine,69,8)."</chequeNumber>";
		
		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$doctorXml = $mroAsciiFileDBHelper -> getDoctorDetailsByProvider($healthProvider);
		$headerXML	.= $doctorXml;
		
		$headerXML .= "</fileHeader>";
		return $headerXML;
	}
	
	public function getAddressOneRecord($addressOne)
	{
		$addressOneXML = "<addressOne>";
		$addressOneXML .= "<billingAgent>".substr($addressOne,3,30)."</billingAgent>";
		$addressOneXML .= "<addressLineOne>".substr($addressOne,33,25)."</addressLineOne>";		
		$addressOneXML .= "</addressOne>";
		return $addressOneXML;
	}
	
	public function getAddressTwoRecord($addressTwo)
	{
		$addressTwoXML = "<addressTwo>";
		$addressTwoXML .= "<addressLineTwo>".substr($addressTwo,3,25)."</addressLineTwo>";
		$addressTwoXML .= "<addressLineThree>".substr($addressTwo,28,25)."</addressLineThree>";
		$addressTwoXML .= "</addressTwo>";
		return $addressTwoXML;
	}
	
	public function getClaimHeaderRecord($claimHeader)
	{
		$healthProvider = substr($claimHeader,15,6);
		$healthcardNumber = substr($claimHeader,52,4)."-".substr($claimHeader,56,3)."-".substr($claimHeader,59,3)."-".substr($claimHeader,64,2);
			
		$claimHeaderXML = "<ministryRefNumber>".substr($claimHeader,3,11)."</ministryRefNumber>";
		$claimHeaderXML .= "<transactionType>".substr($claimHeader,14,1)."</transactionType>";
		$claimHeaderXML .= "<healthcareProvider>".$healthProvider."</healthcareProvider>";		
		$claimHeaderXML .= "<speciality>".substr($claimHeader,21,2)."</speciality>";		
		$claimHeaderXML .= "<accountingNumber>".substr($claimHeader,23,8)."</accountingNumber>";		
		$claimHeaderXML .= "<patientLastName>".substr($claimHeader,31,14)."</patientLastName>";						
		$claimHeaderXML .= "<patientFirstName>".substr($claimHeader,45,5)."</patientFirstName>";								
		$claimHeaderXML .= "<province>".substr($claimHeader,50,2)."</province>";										
		$claimHeaderXML .= "<healthRegNumber>".substr($claimHeader,52,12)."</healthRegNumber>";												
		$claimHeaderXML .= "<versionCode>".substr($claimHeader,64,2)."</versionCode>";														
		$claimHeaderXML .= "<paymentProgram>".substr($claimHeader,66,3)."</paymentProgram>";														
		$claimHeaderXML .= "<serviceLocation>".substr($claimHeader,69,4)."</serviceLocation>";														
		$claimHeaderXML .= "<mohGroupId>".substr($claimHeader,73,4)."</mohGroupId>";	
		

		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$patXml = $mroAsciiFileDBHelper -> getPatientDetailsByCard($healthcardNumber);
		$claimHeaderXML	.= $patXml;
		
		$doctorXml = $mroAsciiFileDBHelper -> getDoctorDetailsByProvider($healthProvider);
		$claimHeaderXML	.= $doctorXml;
		
		return $claimHeaderXML;
	}
	
	public function getClaimItemRecord($claimItem)
	{
		$claimItemXML  = "<ministryRefnumber>".substr($claimItem,3,11)."</ministryRefnumber>";														
		$claimItemXML .= "<transactionType>".substr($claimItem,14,1)."</transactionType>";														
		$claimItemXML .= "<serviceDate>".substr($claimItem,15,8)."</serviceDate>";														
		$claimItemXML .= "<noservices>".substr($claimItem,23,2)."</noservices>";														
		$claimItemXML .= "<serviceCode>".substr($claimItem,25,5)."</serviceCode>";														
		$claimItemXML .= "<submitedAmount>".substr($claimItem,31,4).".".substr($claimItem,35,2)."</submitedAmount>";														
		$claimItemXML .= "<amountPaid>".substr($claimItem,37,4).".".substr($claimItem,41,2)."</amountPaid>";														
		$claimItemXML .= "<negativeSign>".substr($claimItem,43,1)."</negativeSign>";
		$claimItemXML .= "<explanatoryCode>".trim(substr($claimItem,44,2))."</explanatoryCode>";	

		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$reasonXml = $mroAsciiFileDBHelper -> getRemittanceAdviceReason(substr($claimItem,44,2));
		$claimItemXML.= $reasonXml;
		
		return $claimItemXML;
	}
	
	public function getBalanceForwordRecord($balanceForwordLine)
	{
		$balanceForwordXML = "<balanceForword>";
		$balanceForwordXML .= "<adjustmentAmountForword>".substr($balanceForwordLine,3,7).".".
								substr($balanceForwordLine,10,2)."</adjustmentAmountForword>";
		$balanceForwordXML .= "<adjustmentAmountSign>".substr($balanceForwordLine,12,1)."</adjustmentAmountSign>";
		$balanceForwordXML .= "<advanceAmountForword>".substr($balanceForwordLine,13,7).".".
								substr($balanceForwordLine,22,2)."</advanceAmountForword>";
		$balanceForwordXML .= "<advanceAmountSign>".substr($balanceForwordLine,22,1)."</advanceAmountSign>";		
		$balanceForwordXML .= "<reductionAmountForword>".substr($balanceForwordLine,23,7).".".
								substr($balanceForwordLine,30,2)."</reductionAmountForword>";		
		$balanceForwordXML .= "<reductionAmountSign>".substr($balanceForwordLine,32,1)."</reductionAmountSign>";		
		$balanceForwordXML .= "<deductionAmountForword>".substr($balanceForwordLine,33,7).".".
								substr($balanceForwordLine,40,2)."</deductionAmountForword>";		
		$balanceForwordXML .= "<deductionAmountSign>".substr($balanceForwordLine,42,1)."</deductionAmountSign>";		
		$balanceForwordXML .= "</balanceForword>";
		return $balanceForwordXML;
	
	}
	
	
	public function getAccountTransactionRecord($accountTransaction)
	{
		$accountTransactionXML = "<accountTransaction>";
		$accountTransactionXML .= "<transactionCode>".substr($accountTransaction,3,2)."</transactionCode>";
		$accountTransactionXML .= "<chequeIndicator>".substr($accountTransaction,5,1)."</chequeIndicator>";
		$accountTransactionXML .= "<transactionDate>".substr($accountTransaction,6,8)."</transactionDate>";
		$accountTransactionXML .= "<transactionAmount>".substr($accountTransaction,14,6).".".
									substr($accountTransaction,20,2)."</transactionAmount>";
		$accountTransactionXML .= "<transactionAmountSign>".substr($accountTransaction,22,1)."</transactionAmountSign>";
		$accountTransactionXML .= "<transactionMessage>".substr($accountTransaction,23,50)."</transactionMessage>";
		$accountTransactionXML .= "</accountTransaction>";
		return $accountTransactionXML;
		
	}
	
	public function getMessageRecord($messageFacilityLine)
	{
		$messageXML = "<message>";
		$messageXML .= "<messageText>".substr($messageFacilityLine,3,70)."&#13;</messageText>";
		$messageXML .= "</message>";
		return $messageXML;
		
	}
	
	public function checkProviderClaim($claimHeader,$claimItem)
	{
		$accountingNumber = substr($claimHeader,23,8);
		$serviceDate = substr($claimItem,15,4).'-'.substr($claimItem,19,2).'-'.substr($claimItem,21,2);
		$healthcardNumber = substr($claimHeader,52,4)."-".substr($claimHeader,56,3)."-".substr($claimHeader,59,3)."-".substr($claimHeader,64,2);
		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$isOwnRecord = $mroAsciiFileDBHelper -> checkProviderClaim($accountingNumber,$serviceDate,$healthcardNumber);
		return $isOwnRecord;
				
	}
	
	public function checkProviderFile($headerLine)
	{
		$groupNumber = substr($headerLine,7,4);
		$healthcareProvider = substr($headerLine,11,6);
		$speciality = substr($headerLine,17,2);
		$mohOfficeCode = substr($headerLine,19,1);
		$mroAsciiFileDBHelper = new MROASCIIFileDBHelper();
		$isOwnRecord = $mroAsciiFileDBHelper -> checkProviderFile($healthcareProvider,$speciality,$mohOfficeCode,$groupNumber);
		return $isOwnRecord;
		
	}
	
}
?>