<?php
namespace App\Http\ASCII;

use App\Http\ASCII\BatchHeaderVO;
use App\Http\ASCII\ClaimHeaderVO;
use Carbon\Carbon;
use DB;

class ASCIIFileDBHelper
{


	public function getHealthcareProvider($doctorId)
	{

		$query = "SELECT ohipRegNum as providerNumber FROM ecusers where USERID = ".$doctorId;
		
		$providerNumber ="";					
		
		$res = DB::select($query);
		if($row = json_decode(json_encode((array) $res), true))
		{
			$providerNumber = $row[0]['providerNumber'];
		}
		
		return $providerNumber;
		
	}
	public function getBatchHeaderRecord($doctorId)
	{
		$batchHeaderVO = new BatchHeaderVO();
		$query = "SELECT FIRST_NAME,LAST_NAME,licenseNumber as specialityCode,ohipRegNum as providerNumber,ohip_group_number,
					ECMOHOFF.mriid FROM ecusers ECU
					LEFT OUTER JOIN ecmohoffices ECMOHOFF ON ECMOHOFF.id = ECU.MOH_ID
					where USERID = ".$doctorId;
		$res = DB::select($query);
		
		if($row=json_decode(json_encode((array) $res), true)[0])
		{
			$batchHeaderVO ->mohOfficeCode = $row['mriid'];
			$batchHeaderVO ->doctorPrivateNumber = $row['providerNumber'];
			$batchHeaderVO ->specialityCode = $row['specialityCode'];
			$batchHeaderVO ->groupNumber = $row['ohip_group_number'];
		}
		
		return $batchHeaderVO;
		
	}
	
	public function getClaimHeaderRecords($recordIds)
	{
	    $query = "SELECT DATE_FORMAT(ECPM.DOB,'%Y%m%d') PAT_DOB,
					CONCAT(ECPM.FIRST_NAME,' ',ECPM.LAST_NAME) patname,ECAB.ab_ohipbilling_number,ECPB.id,
					ECPB.review_indicator ,ECPB.accountingnumber,ECPB.ref_doc_id,ECPB.OHIP
					FROM ecpatientbilling ECPB 
					LEFT OUTER JOIN ecpatmaster ECPM ON ECPB.pat_id = ECPM.PAT_ID
					LEFT OUTER JOIN ecpatcasemaster ECPCM ON ECPCM.CASE_ID = ECPB.case_id
					LEFT OUTER JOIN ecregnumq ECRQ ON ECRQ.ECRQ_ID = ECPCM.ECRQ_ID
					LEFT OUTER JOIN ecaddressbook ECAB ON ECAB.ab_id = ECPB.ref_doc_id
					WHERE ECPB.id IN(".$recordIds.") ORDER BY ECPB.accountingnumber";
		
		$res = DB::select($query);
		
		$claimHeaders = array();
		
		foreach(json_decode(json_encode((array) $res), true) as $row)
		{
			$claimHeader = new ClaimHeaderVO();
			
			$claimHeader -> OHIPItemId = $row['id'];
			$claimHeader -> patientName = $row['patname'];
			
			$cardNumber = preg_replace('/-/', '', $row['OHIP']);
			
			if($cardNumber != '' && strlen($cardNumber) >= 10){
				$claimHeader -> healthCardNumber = substr($cardNumber,0,10);
			}
			
			if($cardNumber != '' && strlen($cardNumber) >= 11){
				$claimHeader -> versionCode = substr($cardNumber,10,2);
			}
			
			$claimHeader -> patDOB = $row['PAT_DOB'];
			if($row['ab_ohipbilling_number'] != ""){
				$claimHeader -> refDocNumber = $row['ab_ohipbilling_number'];
			}
			$claimHeader -> refDocId = $row['ref_doc_id'];
			
			if($row['review_indicator'] != "Blank"){
				$claimHeader -> manualReviewId = $row['review_indicator'];
			}
			
			if($row['accountingnumber'] != "" && strlen($row['accountingnumber']) != 0){
				$claimHeader -> accountingNo = $row['accountingnumber'];
			}

			
			$claimHeaders[] = $claimHeader;
			
		}	
		
		return $claimHeaders;
		
	}
	
	public function getItemRecords($recordIds)
	{
	
	    $query = "SELECT ECPB.billing_code,ECPB.id,CONCAT(ECPM.FIRST_NAME,' ',ECPM.LAST_NAME) patname,
						ECPB.amount,ECPB.service_count,
						DATE_FORMAT(ECPB.billing_date,'%Y%m%d') serviceDate ,ECPB.diagnosis_code
						FROM ecpatientbilling ECPB 
						LEFT OUTER JOIN ecpatmaster ECPM ON ECPB.pat_id = ECPM.PAT_ID
						WHERE ECPB.id IN(".$recordIds.") ORDER BY ECPB.accountingnumber";
		$res = DB::select($query);
		
		$itemRecords = array();
		
		foreach(json_decode(json_encode((array) $res), true) as $row )
		{
			$itemRecord = new ItemRecordVO();
			
			$itemRecord -> OHIPItemId = $row['id'];
			$itemRecord -> patientName = $row['patname'];
			
			if($row['billing_code'] != ""){
				$itemRecord -> serviceCode = $row['billing_code'];
			}
			
			if($row['amount'] != ""){
				$itemRecord -> feeSubmit = number_format($row['amount'],2,'.','');
			}
			
			if($row['service_count'] != ""){
				$itemRecord -> numServices = $row['service_count'];
			}
			
			if($row['serviceDate'] != ""){
				$itemRecord -> serviceDate = $row['serviceDate'];
			}
			
			if($row['diagnosis_code'] != ""){
				$itemRecord -> diagnosisCode = $row['diagnosis_code'];
			}
			
			$itemRecords[] = $itemRecord;
			
		}	
		
		return $itemRecords;	
	
	}
	
	public function getFileSequenceNumber($month)
	{
		$query = "SELECT * FROM ecuniqueohipsequence ECUS";
		$res = DB::select($query);
		
		if(count($res) == 0){
			$query = "INSERT INTO ecuniqueohipsequence(`id`,`sequencenumber`,`updatedmonth`)VALUES(1,1,".$month.")";
			DB::select($query);
		}else{
			$query = "SELECT `sequencenumber` FROM ecuniqueohipsequence ECUS WHERE id = 1";
			$res = DB::select($query);
			$row = json_decode(json_encode((array) $res), true);
			if($row[0]['sequencenumber'] >= 999){
				$update = "UPDATE ecuniqueohipsequence SET `sequencenumber` = 1,`updatedmonth` = ".$month." WHERE id = 1";
				DB::select($update);
			}else{
				$update = "UPDATE ecuniqueohipsequence SET `sequencenumber` = `sequencenumber`+1 WHERE id = 1";
				DB::select($update);
			}
		}
		$query = "SELECT sequencenumber FROM ecuniqueohipsequence ECUS WHERE id = 1";
		$res = DB::select($query);
		$row = json_decode(json_encode((array) $res), true);
		return $row[0]['sequencenumber'];
	
	}
	
	/////////////////////////////// To save MRI file history ///////////////////////////
	public function saveMRIHistory($fileName,$userId,$doctorId,$currentDate){
	
		$query = "INSERT INTO `ecmrifilehistory`
					(
					`fileName`,
					`downloadedBy`,
					`doctorId`,
					`downloadedDate`)
					VALUES
					(
					'".$fileName."',
					'".$userId."',
					'".$doctorId."',
					'".$currentDate."')";
					
		DB::select($query);
	}


}
?>