<?php
namespace App\Http\ASCII;

use App\Models\Ecpatientbilling;
use Carbon\Carbon;
use DB;

class ASCIIFileCompiler
{
	
	
	var $errorCollection="";
	
	//////////////////////////////////    To get Ascii file name //////////////////////////////////////
	public function getAsciiFileName($healthcareProvider,$sequenceNumber)
	{
		//Format
		//HA123456.001
		$processCycle = $this -> getCurrentProcessingCycle();
		$healthcareProviderNumber = $this ->getHealthcareProviderNo($healthcareProvider);
		$sequenceNumber = $this ->getSequenceNo($sequenceNumber);
		$fileName = "H".$processCycle.$healthcareProviderNumber.".".$sequenceNumber;
		return $fileName;
	}
	
	public function getCurrentMonth()
	{
		return Carbon::now()->month;
	}
	
	public function getCurrentProcessingCycle()
	{
		$asciiStart = 65; // ascii for 'A'
		$month = $this->getCurrentMonth()-1;
		return chr($asciiStart+$month);
	}
	
	public function getHealthcareProviderNo($healthcareProvider)
	{
		if($healthcareProvider != "" && strlen($healthcareProvider) == 6){
			return $healthcareProvider;
		}
		$this->errorCollection .= $this->getErrorTag("FileName Error","HealthcareProvider mismatch",$healthcareProvider,"6digits needed");
		
		return "000000"; // for undifined providers
	}
	
	public function getSequenceNo($sequenceNumber)
	{
		// each file has different file names if we submit more than one ascii files by the same time
		if($sequenceNumber == ""){
			$this->errorCollection .= $this->getErrorTag("FileName Error","Sequence Number is Empty",$sequenceNumber,"Atleast 1 digit needed");
		}
		return str_pad($sequenceNumber,3,'0',STR_PAD_LEFT);

	}
	
	
	/////////////////////////////////////////////////////////////////////////////////
	
	
	/////////////////////  To get Batch Header Record   ////////////////////////////
	
	public function getBatchHeaderRecord($batchHeaderVo)
	{
		
		$headerRecord = "HEBV03";  // first 6 letters for all batchHeaderRecords
		
		$mohOfficeCode = $batchHeaderVo -> mohOfficeCode;
		
		if($mohOfficeCode == ""){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","MOH Office code is Empty",$mohOfficeCode,"1 digit needed");
		}
		$mohOfficeCode = str_pad($mohOfficeCode,1," ");
		$headerRecord .= $mohOfficeCode;
		
		$currentDate = $batchHeaderVo -> currentDate;
		if($currentDate == "" || strlen($currentDate) != 8){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","File Creation Date is not in format",$currentDate,
			"8 digit needed");
		}
		$headerRecord .= $currentDate;
		
		$submission = $batchHeaderVo -> submissionNumber;
		$submission = str_pad($submission,4,"0");
		if($submission == "" || strlen($submission) != 4){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","Submission sequence not valid",$submission,"4 digit needed");
		}
		$headerRecord .= $submission;

		if(strlen($batchHeaderVo -> operatorNumber) != 6){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","Operator number not valid",$batchHeaderVo -> operatorNumber,
			"6 digit needed");
		}
		$headerRecord .= $batchHeaderVo -> operatorNumber;

		if(strlen($batchHeaderVo -> groupNumber) != 4){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","Group number not valid",$batchHeaderVo -> groupNumber,
			"4 digit needed");
		}
		$headerRecord .= $batchHeaderVo -> groupNumber;
		
		$doctorPrivateNumber = $batchHeaderVo -> doctorPrivateNumber;
		if($doctorPrivateNumber == "" || strlen($doctorPrivateNumber) != 6){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","Healthcare provider not valid",$doctorPrivateNumber,
			"6 digit needed");
		}
		$headerRecord .= $doctorPrivateNumber;
		
		$specialityCode = $batchHeaderVo -> specialityCode;
		if($specialityCode == "" || strlen($specialityCode) != 2){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","Speciality Code not valid",$specialityCode,"2 digit needed");
		}
		$headerRecord .= $specialityCode;

		if(strlen($batchHeaderVo ->mohUse) != 42){
			$this->errorCollection .= $this->getErrorTag("Batch Header Record Error","Spaces not valid for MOH use",$batchHeaderVo ->mohUse,
			"42 spaces needed");
		}
	    $headerRecord .= $batchHeaderVo ->mohUse;
		
		return $headerRecord;
		
	}
	
	//////////////////////////////////////////////////////////////////////////////////
	
	
	
	////////////////////////// To get claim header record ////////////////////////////
	
	
	public function getClaimHeaderRecord($claimHeaderRecord){
	
		$claimHeader = "HEH";  // for first 3 
		
		$healthcardNumber = $claimHeaderRecord -> healthCardNumber;
		if(strlen($healthcardNumber) != 10 || $healthcardNumber == '          '){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","Healthcard number not valid",$healthcardNumber,
			"10 digits needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $healthcardNumber;
		
		$versionCode = str_pad($claimHeaderRecord -> versionCode,2," ",STR_PAD_RIGHT);

		if(strlen($versionCode) != 2)
		{
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","VersionCode number not valid",$versionCode,
			"2 digits needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $versionCode;		
		
		if(strlen($claimHeaderRecord -> patDOB) != 8){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","Patient DOB not valid",
			$claimHeaderRecord -> patDOB,"8 digits needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> patDOB;
		
		if(strlen($claimHeaderRecord -> accountingNo) != 8){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","Accounting number not valid",
			$claimHeaderRecord -> accountingNo,"8 digits needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> accountingNo;
		
		if(strlen($claimHeaderRecord -> paymentProgram) != 3){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","PaymentProgram is not valid",
			$claimHeaderRecord -> paymentProgram,"3 digits needed",$claimHeaderRecord -> OHIPItemId,
			$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> paymentProgram;
		
		if(strlen($claimHeaderRecord -> payee) != 1){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","Payee is not valid",
			$claimHeaderRecord -> payee,"1 digit needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> payee;	
		
		$refDocNumber = $claimHeaderRecord -> refDocNumber;
		$refDocId = $claimHeaderRecord -> refDocId;
		if(strlen($refDocNumber) != 6 || ($refDocNumber == '      ' && $refDocId != 0)){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","Doctor Ref Number is not valid",
			$refDocNumber,"6 digit needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $refDocNumber;	

		if(strlen($claimHeaderRecord -> masterNumber) != 4){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","Master number is not valid",
			$claimHeaderRecord -> masterNumber,"4 digit needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> masterNumber;

		if(strlen($claimHeaderRecord -> admissionDate) != 8){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","AdmissionDate is not valid",
			$claimHeaderRecord -> admissionDate,"8 digit needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> admissionDate;

		if(strlen($claimHeaderRecord -> labLicenseNumber) != 4){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","LabLicenseNumber is not valid",
			$claimHeaderRecord -> labLicenseNumber,"4 digit needed",$claimHeaderRecord -> OHIPItemId,
			$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> labLicenseNumber;		

		if(strlen($claimHeaderRecord -> manualReviewId) != 1){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","Manual Review Id is not valid",
			$claimHeaderRecord -> manualReviewId,"1 digit needed",$claimHeaderRecord -> OHIPItemId,
			$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> manualReviewId;
		
		if(strlen($claimHeaderRecord -> serviceLocationId) != 4){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","Service location ID is not valid",
			$claimHeaderRecord -> serviceLocationId,"4 digit needed",$claimHeaderRecord -> OHIPItemId,
			$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> serviceLocationId;				
	
	
		if(strlen($claimHeaderRecord -> oocUse) != 11){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","OOC Use spaces is invalid",
			$claimHeaderRecord -> oocUse,"11 spaces needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> oocUse;					

		if(strlen($claimHeaderRecord -> mohUse) != 6){
			$this->errorCollection .= $this->getErrorTag("Claim Header Record Error","MOH Use spaces is invalid",
			$claimHeaderRecord -> mohUse,"6 spaces needed",$claimHeaderRecord -> OHIPItemId,$claimHeaderRecord -> patientName);
		}
		$claimHeader .= $claimHeaderRecord -> mohUse;					
		
		
		return $claimHeader;

	
	}
	
	
	
	///////////////////////////////////////////////////////////////////////////////////
	
	
	
	
	////////////////////////////// To get item record //////////////////////////////////
	
	public function getItemRecord($itemRecordVO)
	{
	
			$itemRecord = "HET";
			
			$serviceCode = $itemRecordVO ->serviceCode;
			if(strlen($serviceCode) != 5 || substr($serviceCode,0,1) == 'I' || substr($serviceCode,0,1) == 'O' || 
			substr($serviceCode,0,1) == 'U' || (substr($serviceCode,4,1) != 'A' && substr($serviceCode,4,1) != 'B' && 
			substr($serviceCode,4,1) != 'C')){
				$this->errorCollection .= $this->getErrorTag("Item Record Error","ServiceCode is invalid",$serviceCode,
				"ANNNA format needed",$itemRecordVO->OHIPItemId,$itemRecordVO -> patientName);
			}
			$itemRecord .= $itemRecordVO -> serviceCode;
			
			
			if(strlen($itemRecordVO -> mohUse) != 2){
				$this->errorCollection .= $this->getErrorTag("Item Record Error","MOH Use spaces is invalid",
				$itemRecordVO -> mohUse,"2 spaces needed",$itemRecordVO->OHIPItemId,$itemRecordVO -> patientName);
			}
			$itemRecord .= $itemRecordVO -> mohUse;
			
			$feeSubmit = str_replace('.','',$itemRecordVO ->feeSubmit);
			$feeSubmit = str_pad($feeSubmit,6,"0",STR_PAD_LEFT);
			if(strlen($feeSubmit) != 6){
				$this->errorCollection .= $this->getErrorTag("Item Record Error","Fee Submitted is invalid",$feeSubmit,
				"6 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO -> patientName);
			}
			$itemRecord .= $feeSubmit;
			
			$numberOfServices = str_pad($itemRecordVO -> numServices,2,"0",STR_PAD_LEFT);
			if(strlen($numberOfServices) != 2){
				$this->errorCollection .= $this->getErrorTag("Item Record Error","Number of services is invalid",
				$numberOfServices,"2 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO -> patientName);
			}
			$itemRecord .= $numberOfServices;
			
			$serviceDate = $itemRecordVO -> serviceDate;
			if(strlen($serviceDate) != 8){
				$this->errorCollection .= $this->getErrorTag("Item Record Error","Service Date is invalid",
				$serviceDate,"8 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO -> patientName);
			}
			$itemRecord .= $serviceDate;

			$diagnosticCode = str_pad($itemRecordVO -> diagnosisCode,4," ",STR_PAD_RIGHT);
			if(strlen($diagnosticCode) != 4){
				$this->errorCollection .= $this->getErrorTag("Item Record Error","Diagnostic code is invalid",
				$diagnosticCode,"4 digits needed",$itemRecordVO->OHIPItemId,$itemRecordVO -> patientName);
			}
			$itemRecord .= $diagnosticCode;
			
			
			if(strlen($itemRecordVO -> oocUse) != 10){
				$this->errorCollection .= $this->getErrorTag("Item Record Error","OOC Use spaces is invalid",
				$itemRecordVO -> oocUse,"10 spaces needed",$itemRecordVO->OHIPItemId,$itemRecordVO -> patientName);
			}
			$itemRecord .= $itemRecordVO -> oocUse;
			
			if(strlen($itemRecordVO -> mohUseSecond) != 1){
				$this->errorCollection .= $this->getErrorTag("Item Record Error","MOH Use spaces is invalid",
				$itemRecordVO -> mohUseSecond,"1 space needed",$itemRecordVO->OHIPItemId,$itemRecordVO -> patientName);
			}
			$itemRecord .= $itemRecordVO -> mohUseSecond;			

			if(strlen($itemRecordVO -> item2Use) != 38){
				$this->errorCollection .= $this->getErrorTag("Item Record Error","Optional Item2 spaces is invalid",
				$itemRecordVO -> item2Use,"38 space needed",$itemRecordVO->OHIPItemId,$itemRecordVO -> patientName);
			}
			$itemRecord .= $itemRecordVO -> item2Use;						
			
			return $itemRecord;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////
	
	
	
	//////////////////////////////  To get footer record ///////////////////////////////
	
	public function getFooterRecord($recordIds){
		
		$footerRecord = "HEE";
		$idArray = explode(',',$recordIds);
		$itemCount = count($idArray);
		
		$claimHeaderCount = str_pad($itemCount,4,"0",STR_PAD_LEFT);
		if(strlen($claimHeaderCount) != 4){
			$this->errorCollection .= $this->getErrorTag("Batch Trailer/Footer Record Error","Claim Header count is invalid",
			$claimHeaderCount,"4 digits needed");
		}
		$footerRecord .= $claimHeaderCount;
		
		$footerRecord .= "0000";
		
		$itemRecordCount = 	str_pad($itemCount,5,"0",STR_PAD_LEFT);
		if(strlen($itemRecordCount) != 5){
			$this->errorCollection .= $this->getErrorTag("Batch Trailer/Footer Record Error","Item Record count is invalid",
			$itemRecordCount,"5 digits needed");
		}
		$footerRecord .= $itemRecordCount;
		
		$mohUseSpace = "                                                               ";
		if(strlen($mohUseSpace) != 63){
			$this->errorCollection .= $this->getErrorTag("Batch Trailer/Footer Record Error","MOH spaces invalid",
			$mohUseSpace,"63 spaces needed");
		}
		$footerRecord .= $mohUseSpace;
		
		return $footerRecord;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////
	
	
	///////////////////////////////////// To save error values /////////////////////////
	
	public function getErrorTag($error,$errorDescription,$currentValue,$expectingFormat,$ohipItemId=-1,$patName='')
	{
		$errorTag = "<errorTag>";
		$errorTag .= "<error>".$error."</error>";
		$errorTag .= "<errorDescription>".$errorDescription."</errorDescription>";
		$errorTag .= "<currentValue>".$currentValue."</currentValue>";				
		$errorTag .= "<expectingFormat>".$expectingFormat."</expectingFormat>";	
		$errorTag .= "<ohipItemId>".$ohipItemId."</ohipItemId>";
		$errorTag .= "<patientName>".$patName."</patientName>";
		$errorTag .= "</errorTag>";
		return $errorTag;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////
}
?>